/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.util.Runner;

public class StripedPageArray
extends PageArray {
    private final PageArray[] mArrays;
    private final int mDirectPageSize;
    private final boolean mReadOnly;
    private final Syncer[] mSyncers;

    public StripedPageArray(PageArray ... arrays) {
        super(StripedPageArray.pageSize(arrays));
        this.mArrays = arrays;
        int directPageSize = arrays[0].directPageSize();
        for (int i = 1; i < arrays.length; ++i) {
            if (arrays[i].directPageSize() == directPageSize) continue;
            directPageSize = this.pageSize();
            break;
        }
        this.mDirectPageSize = directPageSize;
        boolean readOnly = false;
        for (PageArray pa : arrays) {
            readOnly |= pa.isReadOnly();
        }
        this.mReadOnly = readOnly;
        this.mSyncers = new Syncer[arrays.length - 1];
        for (int i = 0; i < this.mSyncers.length; ++i) {
            this.mSyncers[i] = new Syncer(arrays[i]);
        }
    }

    private static int pageSize(PageArray ... arrays) {
        int pageSize = arrays[0].pageSize();
        for (int i = 1; i < arrays.length; ++i) {
            if (arrays[i].pageSize() == pageSize) continue;
            throw new IllegalArgumentException("Inconsistent page sizes");
        }
        return pageSize;
    }

    @Override
    public final int directPageSize() {
        return this.mDirectPageSize;
    }

    @Override
    public boolean isFullyMapped() {
        for (PageArray pa : this.mArrays) {
            if (pa.isFullyMapped()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.mReadOnly;
    }

    @Override
    public boolean isEmpty() throws IOException {
        for (PageArray pa : this.mArrays) {
            if (pa.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public long pageCount() throws IOException {
        long count = 0L;
        for (PageArray pa : this.mArrays) {
            if ((count += pa.pageCount()) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return count;
    }

    @Override
    public void truncatePageCount(long count) throws IOException {
        this.setPageCount(count, true);
    }

    @Override
    public void expandPageCount(long count) throws IOException {
        this.setPageCount(count, false);
    }

    private void setPageCount(long count, boolean truncate) throws IOException {
        int stripes = this.mArrays.length;
        count = (count + (long)stripes - 1L) / (long)stripes;
        for (PageArray pa : this.mArrays) {
            if (truncate) {
                pa.truncatePageCount(count);
                continue;
            }
            pa.expandPageCount(count);
        }
    }

    @Override
    public long pageCountLimit() throws IOException {
        long limit = -1L;
        for (PageArray pa : this.mArrays) {
            long subLimit = pa.pageCountLimit();
            if (subLimit < 0L) continue;
            limit = limit < 0L ? subLimit : Math.min(limit, subLimit);
        }
        return limit < 0L ? limit : limit * (long)this.mArrays.length;
    }

    @Override
    public void readPage(long index, byte[] dst, int offset, int length) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        arrays[(int)(index % (long)stripes)].readPage(index / (long)stripes, dst, offset, length);
    }

    @Override
    public void readPage(long index, byte[] dst, int off, int len, ByteBuffer tail) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        arrays[(int)(index % (long)stripes)].readPage(index / (long)stripes, dst, off, len, tail);
    }

    @Override
    public void readPage(long index, long dstPtr, int offset, int length) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        arrays[(int)(index % (long)stripes)].readPage(index / (long)stripes, dstPtr, offset, length);
    }

    @Override
    public void readPage(long index, long dstPtr, int off, int len, ByteBuffer tail) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        arrays[(int)(index % (long)stripes)].readPage(index / (long)stripes, dstPtr, off, len, tail);
    }

    @Override
    public void writePage(long index, byte[] src, int offset) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        arrays[(int)(index % (long)stripes)].writePage(index / (long)stripes, src, offset);
    }

    @Override
    public void writePage(long index, byte[] src, int off, ByteBuffer tail) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        arrays[(int)(index % (long)stripes)].writePage(index / (long)stripes, src, off, tail);
    }

    @Override
    public void writePage(long index, long srcPtr, int offset) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        arrays[(int)(index % (long)stripes)].writePage(index / (long)stripes, srcPtr, offset);
    }

    @Override
    public void writePage(long index, long srcPtr, int off, ByteBuffer tail) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        arrays[(int)(index % (long)stripes)].writePage(index / (long)stripes, srcPtr, off, tail);
    }

    @Override
    public byte[] evictPage(long index, byte[] buf) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        return arrays[(int)(index % (long)stripes)].evictPage(index / (long)stripes, buf);
    }

    @Override
    public long evictPage(long index, long bufPtr) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        return arrays[(int)(index % (long)stripes)].evictPage(index / (long)stripes, bufPtr);
    }

    @Override
    public long directPagePointer(long index) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        return arrays[(int)(index % (long)stripes)].directPagePointer(index / (long)stripes);
    }

    @Override
    public long copyPage(long srcIndex, long dstIndex) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        PageArray src = arrays[(int)(srcIndex % (long)stripes)];
        srcIndex /= (long)stripes;
        PageArray dst = arrays[(int)(dstIndex % (long)stripes)];
        dstIndex /= (long)stripes;
        if (src == dst) {
            return dst.copyPage(srcIndex, dstIndex);
        }
        return dst.copyPageFromPointer(src.directPagePointer(srcIndex), dstIndex);
    }

    @Override
    public long copyPageFromPointer(long srcPointer, long dstIndex) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        return arrays[(int)(dstIndex % (long)stripes)].copyPageFromPointer(srcPointer, dstIndex / (long)stripes);
    }

    @Override
    public synchronized void sync(boolean metadata) throws IOException {
        int i;
        Syncer[] syncers = this.mSyncers;
        for (i = 0; i < syncers.length; ++i) {
            Syncer syncer = syncers[i];
            syncer.reset(metadata);
            Runner.start(syncer);
        }
        this.mArrays[i].sync(metadata);
        for (Syncer syncer : syncers) {
            syncer.check();
        }
    }

    @Override
    public void syncPage(long index) throws IOException {
        PageArray[] arrays = this.mArrays;
        int stripes = arrays.length;
        arrays[(int)(index % (long)stripes)].syncPage(index / (long)stripes);
    }

    @Override
    public void close(Throwable cause) throws IOException {
        IOException ex = null;
        for (PageArray pa : this.mArrays) {
            ex = Utils.closeQuietly(ex, pa, cause);
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public StripedPageArray open() throws IOException {
        for (int i = 0; i < this.mArrays.length; ++i) {
            this.mArrays[i] = this.mArrays[i].open();
        }
        return this;
    }

    private static class Syncer
    implements Runnable {
        private final PageArray mArray;
        private boolean mMetadata;
        private boolean mFinished;
        private Throwable mException;

        Syncer(PageArray pa) {
            this.mArray = pa;
        }

        @Override
        public synchronized void run() {
            try {
                this.mArray.sync(this.mMetadata);
            }
            catch (Throwable e) {
                this.mException = e;
            }
            finally {
                this.mFinished = true;
                this.notify();
            }
        }

        synchronized void reset(boolean metadata) {
            this.mMetadata = metadata;
            this.mFinished = false;
            this.mException = null;
        }

        synchronized void check() throws IOException {
            try {
                while (!this.mFinished) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            Throwable e = this.mException;
            if (e != null) {
                throw new IOException(e.toString(), e);
            }
        }
    }
}

