/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class UnsafeAccess {
    private static final Unsafe UNSAFE;
    private static final Throwable UNSUPPORTED;
    private static final long ARRAY_OFFSET;

    private UnsafeAccess() {
    }

    public static Unsafe tryObtain() {
        return UNSAFE;
    }

    public static Unsafe obtain() throws UnsupportedOperationException {
        if (UNSAFE == null) {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }
        return UNSAFE;
    }

    public static long alloc(int size) {
        return UNSAFE.allocateMemory(size);
    }

    public static long alloc(int size, boolean aligned) {
        return aligned ? JNA.valloc(size) : UNSAFE.allocateMemory(size);
    }

    public static long calloc(int size, boolean aligned) {
        long ptr = UnsafeAccess.alloc(size, aligned);
        UNSAFE.setMemory(ptr, size, (byte)0);
        return ptr;
    }

    public static void fill(long ptr, long len, byte value) {
        UNSAFE.setMemory(ptr, len, value);
    }

    public static void copy(long srcPtr, long dstPtr, long len) {
        UNSAFE.copyMemory(srcPtr, dstPtr, len);
    }

    public static void copy(byte[] src, int srcOffset, long dstPtr, long len) {
        UNSAFE.copyMemory(src, ARRAY_OFFSET + (long)srcOffset, null, dstPtr, len);
    }

    public static void copy(long srcPtr, byte[] dst, int dstOffset, long len) {
        UNSAFE.copyMemory(null, srcPtr, dst, ARRAY_OFFSET + (long)dstOffset, len);
    }

    public static void free(long ptr) {
        UNSAFE.freeMemory(ptr);
    }

    static {
        Unsafe unsafe = null;
        Throwable unsupported = null;
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            unsafe = (Unsafe)theUnsafe.get(null);
        }
        catch (Throwable e) {
            unsupported = e;
        }
        UNSAFE = unsafe;
        UNSUPPORTED = unsupported;
        ARRAY_OFFSET = unsafe == null ? 0L : (long)unsafe.arrayBaseOffset(byte[].class);
    }

    static class JNA {
        JNA() {
        }

        static native long valloc(int var0);

        static {
            Native.register((String)Platform.C_LIBRARY_NAME);
        }
    }
}

