/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cojen.tupl.CorruptDatabaseException;
import org.cojen.tupl.io.CauseCloseable;
import org.cojen.tupl.io.UnsafeAccess;
import sun.misc.Unsafe;

public class Utils {
    private static final VarHandle cShortArrayLEHandle;
    private static final VarHandle cShortArrayBEHandle;
    private static final VarHandle cIntArrayLEHandle;
    private static final VarHandle cIntArrayBEHandle;
    private static final VarHandle cLongArrayLEHandle;
    private static final VarHandle cLongArrayBEHandle;
    private static volatile int cDeleteSupport;
    private static Map<Closeable, Thread> cCloseThreads;

    protected Utils() {
    }

    public static boolean increment(byte[] value, int start, int end) {
        while (--end >= start) {
            int n = end;
            value[n] = (byte)(value[n] + 1);
            if (value[n] == 0) continue;
            return true;
        }
        return false;
    }

    public static boolean decrement(byte[] value, int start, int end) {
        while (--end >= start) {
            int n = end;
            value[n] = (byte)(value[n] - 1);
            if (value[n] == -1) continue;
            return true;
        }
        return false;
    }

    public static void encodeShortBE(byte[] b, int offset, int v) {
        cShortArrayBEHandle.set(b, offset, (short)v);
    }

    public static void encodeShortLE(byte[] b, int offset, int v) {
        cShortArrayLEHandle.set(b, offset, (short)v);
    }

    public static void encodeIntBE(byte[] b, int offset, int v) {
        cIntArrayBEHandle.set(b, offset, v);
    }

    public static void encodeIntLE(byte[] b, int offset, int v) {
        cIntArrayLEHandle.set(b, offset, v);
    }

    public static void encodeInt48BE(byte[] b, int offset, long v) {
        Utils.encodeShortBE(b, offset, (int)(v >> 32));
        Utils.encodeIntBE(b, offset + 2, (int)v);
    }

    public static void encodeInt48LE(byte[] b, int offset, long v) {
        Utils.encodeIntLE(b, offset, (int)v);
        Utils.encodeShortLE(b, offset + 4, (int)(v >> 32));
    }

    public static void encodeLongBE(byte[] b, int offset, long v) {
        cLongArrayBEHandle.set(b, offset, v);
    }

    public static void encodeLongLE(byte[] b, int offset, long v) {
        cLongArrayLEHandle.set(b, offset, v);
    }

    public static short decodeShortBE(byte[] b, int offset) {
        return cShortArrayBEHandle.get(b, offset);
    }

    public static short decodeShortLE(byte[] b, int offset) {
        return cShortArrayLEHandle.get(b, offset);
    }

    public static int decodeUnsignedShortBE(byte[] b, int offset) {
        return cShortArrayBEHandle.get(b, offset) & 0xFFFF;
    }

    public static int decodeUnsignedShortLE(byte[] b, int offset) {
        return cShortArrayLEHandle.get(b, offset) & 0xFFFF;
    }

    public static int decodeIntBE(byte[] b, int offset) {
        return cIntArrayBEHandle.get(b, offset);
    }

    public static int decodeIntLE(byte[] b, int offset) {
        return cIntArrayLEHandle.get(b, offset);
    }

    public static long decodeUnsignedIntBE(byte[] b, int offset) {
        return (long)cIntArrayBEHandle.get(b, offset) & 0xFFFFFFFFL;
    }

    public static long decodeUnsignedIntLE(byte[] b, int offset) {
        return (long)cIntArrayLEHandle.get(b, offset) & 0xFFFFFFFFL;
    }

    public static long decodeUnsignedInt48BE(byte[] b, int offset) {
        return (long)Utils.decodeUnsignedShortBE(b, offset) << 32 | Utils.decodeUnsignedIntBE(b, offset + 2);
    }

    public static long decodeUnsignedInt48LE(byte[] b, int offset) {
        return Utils.decodeUnsignedIntLE(b, offset) | (long)Utils.decodeUnsignedShortLE(b, offset + 4) << 32;
    }

    public static long decodeLongBE(byte[] b, int offset) {
        return cLongArrayBEHandle.get(b, offset);
    }

    public static long decodeLongLE(byte[] b, int offset) {
        return cLongArrayLEHandle.get(b, offset);
    }

    public static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        if (len > 0) {
            Utils.doReadFully(in, b, off, len);
        }
    }

    private static void doReadFully(InputStream in, byte[] b, int off, int len) throws IOException {
        while (true) {
            int amt;
            if ((amt = in.read(b, off, len)) <= 0) {
                throw new EOFException();
            }
            if ((len -= amt) <= 0) break;
            off += amt;
        }
    }

    public static boolean delete(Buffer b) {
        ByteBuffer bb;
        return b instanceof ByteBuffer && Utils.delete(bb = (ByteBuffer)b);
    }

    public static boolean delete(ByteBuffer bb) {
        if (!bb.isDirect()) {
            return false;
        }
        int deleteSupport = cDeleteSupport;
        if (deleteSupport < 0) {
            return false;
        }
        try {
            Unsafe u = UnsafeAccess.obtain();
            Method m = u.getClass().getMethod("invokeCleaner", ByteBuffer.class);
            m.invoke((Object)u, bb);
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IllegalArgumentException) {
                return false;
            }
            throw Utils.rethrow(cause);
        }
        catch (Throwable e) {
            cDeleteSupport = -1;
            return false;
        }
    }

    static synchronized void unregister(Closeable resource) {
        if (cCloseThreads != null) {
            cCloseThreads.remove(resource);
            if (cCloseThreads.isEmpty()) {
                cCloseThreads = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static IOException closeOnFailure(Closeable resource, Throwable cause) throws IOException {
        try {
            var4_2 = Utils.class;
            synchronized (Utils.class) {
                if (Utils.cCloseThreads == null) {
                    Utils.cCloseThreads = new HashMap<Closeable, Thread>(4);
                } else {
                    closer = Utils.cCloseThreads.get(resource);
                    if (closer != null) {
                        joinMillis = 0;
                        // ** MonitorExit[var4_2] (shouldn't be in output)
                        ** break block21
                    }
                }
                closer = new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$closeOnFailure$0(java.io.Closeable java.lang.Throwable ), ()V)((Closeable)resource, (Throwable)cause));
                Utils.cCloseThreads.put(resource, closer);
                // ** MonitorExit[var4_2] (shouldn't be in output)
                closer.setDaemon(true);
                closer.start();
                joinMillis = 1000;
            }
        }
        catch (Throwable e2) {
            closer = null;
            joinMillis = 0;
        }
lbl-1000:
        // 3 sources

        {
            if (closer == null) {
                try {
                    Utils.close(resource, cause);
                }
                catch (IOException e2) {
                }
                finally {
                    Utils.unregister(resource);
                }
            } else if (joinMillis > 0) {
                try {
                    closer.join(joinMillis);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
            }
            if (cause instanceof RuntimeException) {
                e /* !! */  = (RuntimeException)cause;
                throw e /* !! */ ;
            }
            if (cause instanceof Error) {
                e /* !! */  = (Error)cause;
                throw e /* !! */ ;
            }
            if (cause instanceof IOException) {
                e /* !! */  = (IOException)cause;
                throw e /* !! */ ;
            }
            throw new CorruptDatabaseException(cause);
        }
    }

    public static void closeQuietly(Closeable resource) {
        Utils.closeQuietly(null, resource);
    }

    public static void closeQuietly(Closeable resource, Throwable cause) {
        Utils.closeQuietly(null, resource, cause);
    }

    public static IOException closeQuietly(IOException first, Closeable resource) {
        block3: {
            if (resource != null) {
                try {
                    resource.close();
                }
                catch (IOException e) {
                    if (first != null) break block3;
                    return e;
                }
            }
        }
        return first;
    }

    public static IOException closeQuietly(IOException first, Closeable resource, Throwable cause) {
        block3: {
            if (resource != null) {
                try {
                    Utils.close(resource, cause);
                }
                catch (IOException e) {
                    if (first != null) break block3;
                    return e;
                }
            }
        }
        return first;
    }

    public static void close(Closeable resource, Throwable cause) throws IOException {
        if (resource instanceof CauseCloseable) {
            CauseCloseable cc = (CauseCloseable)resource;
            cc.close(cause);
        } else {
            resource.close();
        }
    }

    public static void suppress(Throwable target, Throwable toSuppress) {
        try {
            if (target == null || toSuppress == null) {
                return;
            }
            Throwable t = target;
            do {
                Throwable s = toSuppress;
                do {
                    if (t != s) continue;
                    return;
                } while ((s = s.getCause()) != null);
            } while ((t = t.getCause()) != null);
            Throwable[] s1 = target.getSuppressed();
            Throwable[] s2 = toSuppress.getSuppressed();
            if (s1.length != 0 || s2.length != 0) {
                HashSet<Throwable> all = new HashSet<Throwable>();
                all.add(target);
                if (!Utils.gatherSuppressed(all, s1) || !Utils.gatherSuppressed(all, s2)) {
                    return;
                }
                if (all.contains(toSuppress)) {
                    return;
                }
            }
            target.addSuppressed(toSuppress);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean gatherSuppressed(Set<Throwable> all, Throwable[] suppressed) {
        for (Throwable s : suppressed) {
            if (Utils.gatherSuppressed(all, s)) continue;
            return false;
        }
        return true;
    }

    private static boolean gatherSuppressed(Set<Throwable> all, Throwable e) {
        if (!all.add(e)) {
            return false;
        }
        for (Throwable s : e.getSuppressed()) {
            if (Utils.gatherSuppressed(all, s)) continue;
            return false;
        }
        return true;
    }

    public static Throwable rootCause(Throwable e) {
        if (e == null) {
            return null;
        }
        Throwable cause;
        while ((cause = e.getCause()) != null) {
            e = cause;
        }
        return e;
    }

    public static void uncaught(Throwable e) {
        Thread t = Thread.currentThread();
        t.getUncaughtExceptionHandler().uncaughtException(t, e);
    }

    public static RuntimeException rethrow(Throwable e) {
        Utils.castAndThrow(e);
        return null;
    }

    public static RuntimeException rethrow(Throwable e, Throwable cause) {
        if (cause != null && e != cause && e.getCause() == null) {
            try {
                e.initCause(Utils.rootCause(cause));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Utils.castAndThrow(e);
        return null;
    }

    private static <T extends Throwable> void castAndThrow(Throwable e) throws T {
        throw e;
    }

    private static /* synthetic */ void lambda$closeOnFailure$0(Closeable resource, Throwable cause) {
        try {
            Utils.close(resource, cause);
        }
        catch (IOException iOException) {
        }
        finally {
            Utils.unregister(resource);
        }
    }

    static {
        try {
            cShortArrayLEHandle = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.LITTLE_ENDIAN);
            cShortArrayBEHandle = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.BIG_ENDIAN);
            cIntArrayLEHandle = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
            cIntArrayBEHandle = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN);
            cLongArrayLEHandle = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
            cLongArrayBEHandle = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);
        }
        catch (Throwable e) {
            throw new ExceptionInInitializerError();
        }
    }
}

