/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.W32APIOptions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import org.cojen.tupl.io.MappedPageArray;
import org.cojen.tupl.io.OpenOption;

class WindowsMappedPageArray
extends MappedPageArray {
    private static final Kernel32Ex cKernel = (Kernel32Ex)Native.load((String)"kernel32", Kernel32Ex.class, (Map)W32APIOptions.UNICODE_OPTIONS);
    private final File mFile;
    private final EnumSet<OpenOption> mOptions;
    private final WinNT.HANDLE mFileHandle;
    private final WinNT.HANDLE mMappingHandle;
    private final boolean mNonDurable;
    private volatile boolean mEmpty;

    WindowsMappedPageArray(int pageSize, long pageCount, File file, EnumSet<OpenOption> options) throws IOException {
        super(pageSize, pageCount, options);
        long mappingSize;
        WinNT.HANDLE hFile;
        this.mFile = file;
        this.mOptions = options;
        if (file == null) {
            long mappingPtr = cKernel.VirtualAlloc(0L, (long)pageSize * pageCount, 12288, 4);
            if (mappingPtr == 0L) {
                int error = cKernel.GetLastError();
                throw new IOException(Kernel32Util.formatMessage((int)error));
            }
            this.setMappingPtr(mappingPtr);
            this.mFileHandle = null;
            this.mMappingHandle = null;
            this.mNonDurable = true;
            this.mEmpty = true;
            return;
        }
        String path = file.getPath();
        this.mEmpty = file.length() == 0L;
        this.mNonDurable = options.contains((Object)OpenOption.NON_DURABLE);
        int access = Integer.MIN_VALUE;
        boolean readOnly = options.contains((Object)OpenOption.READ_ONLY);
        if (!readOnly) {
            access |= 0x40000000;
        }
        int create = options.contains((Object)OpenOption.CREATE) ? 4 : 3;
        int flags = this.mNonDurable ? 256 : 128;
        if (options.contains((Object)OpenOption.RANDOM_ACCESS)) {
            flags |= 0x10000000;
        }
        if ((hFile = cKernel.CreateFile(path, access, 0, null, create, flags, null)) == null || hFile == WinNT.INVALID_HANDLE_VALUE) {
            int error = cKernel.GetLastError();
            throw new FileNotFoundException(Kernel32Util.formatMessage((int)error));
        }
        WinNT.HANDLE hMapping = cKernel.CreateFileMapping(hFile, null, readOnly ? 2 : 4, (int)((mappingSize = (long)pageSize * pageCount) >>> 32), (int)mappingSize, null);
        if (hMapping == null || hMapping == WinNT.INVALID_HANDLE_VALUE) {
            int error = cKernel.GetLastError();
            WindowsMappedPageArray.closeHandle(hFile);
            throw WindowsMappedPageArray.toException(error);
        }
        Pointer ptr = cKernel.MapViewOfFile(hMapping, readOnly ? 4 : 2, 0, 0, mappingSize);
        if (ptr == null) {
            int error = cKernel.GetLastError();
            WindowsMappedPageArray.closeHandle(hMapping);
            WindowsMappedPageArray.closeHandle(hFile);
            throw WindowsMappedPageArray.toException(error);
        }
        this.mFileHandle = hFile;
        this.mMappingHandle = hMapping;
        this.setMappingPtr(Pointer.nativeValue((Pointer)ptr));
    }

    @Override
    public long pageCount() {
        return this.mEmpty ? 0L : super.pageCount();
    }

    @Override
    public void truncatePageCount(long count) {
        this.mEmpty = count == 0L;
    }

    @Override
    MappedPageArray doOpen() throws IOException {
        boolean empty = this.mEmpty;
        WindowsMappedPageArray pa = new WindowsMappedPageArray(this.pageSize(), super.pageCount(), this.mFile, this.mOptions);
        pa.mEmpty = empty;
        return pa;
    }

    @Override
    void doSync(long mappingPtr, boolean metadata) throws IOException {
        if (!this.mNonDurable) {
            if (!cKernel.FlushViewOfFile(mappingPtr, super.pageCount() * (long)this.pageSize())) {
                throw WindowsMappedPageArray.toException(cKernel.GetLastError());
            }
            this.fsync();
        }
        this.mEmpty = false;
    }

    @Override
    void doSyncPage(long mappingPtr, long index) throws IOException {
        if (!this.mNonDurable) {
            int pageSize = this.pageSize();
            if (!cKernel.FlushViewOfFile(mappingPtr + index * (long)pageSize, pageSize)) {
                throw WindowsMappedPageArray.toException(cKernel.GetLastError());
            }
            this.fsync();
        }
        this.mEmpty = false;
    }

    @Override
    void doClose(long mappingPtr) throws IOException {
        if (this.mFileHandle == null) {
            if (!cKernel.VirtualFree(mappingPtr, 0L, 32768)) {
                int error = cKernel.GetLastError();
                throw new IOException(Kernel32Util.formatMessage((int)error));
            }
        } else {
            cKernel.UnmapViewOfFile(new Pointer(mappingPtr));
            WindowsMappedPageArray.closeHandle(this.mMappingHandle);
            WindowsMappedPageArray.closeHandle(this.mFileHandle);
        }
    }

    private static IOException toException(int error) {
        return new IOException(Kernel32Util.formatMessage((int)error));
    }

    private static void closeHandle(WinNT.HANDLE handle) throws IOException {
        cKernel.CloseHandle(handle);
    }

    private void fsync() throws IOException {
        if (this.mFileHandle != null && !cKernel.FlushFileBuffers(this.mFileHandle)) {
            throw WindowsMappedPageArray.toException(cKernel.GetLastError());
        }
    }

    public static interface Kernel32Ex
    extends Kernel32 {
        public Pointer MapViewOfFile(WinNT.HANDLE var1, int var2, int var3, int var4, long var5);

        public boolean FlushViewOfFile(long var1, long var3);

        public long VirtualAlloc(long var1, long var3, int var5, int var6);

        public boolean VirtualFree(long var1, long var3, int var5);
    }
}

