/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.cojen.tupl.io.DirectAccess;
import org.cojen.tupl.io.PageCompressor;
import org.cojen.tupl.io.Utils;

class ZlibCompressor
implements PageCompressor {
    private final Deflater mDeflater;
    private final Inflater mInflater;
    private byte[] mCompressedBytes;
    private ByteBuffer mDirectBuffer;

    ZlibCompressor() {
        this(-1);
    }

    ZlibCompressor(int level) {
        this.mDeflater = new Deflater(level);
        this.mInflater = new Inflater();
    }

    @Override
    public int compress(byte[] src, int srcOff, int srcLen) {
        byte[] dst = this.mCompressedBytes;
        if (dst == null) {
            this.mCompressedBytes = dst = new byte[srcLen / 16];
        }
        try {
            this.mDeflater.setInput(src, srcOff, srcLen);
            this.mDeflater.finish();
            int dstOff = 0;
            int len = 0;
            while (true) {
                len += this.mDeflater.deflate(dst, dstOff, dst.length - dstOff);
                if (this.mDeflater.finished()) {
                    int n = len;
                    return n;
                }
                byte[] newDst = new byte[dst.length << 1];
                System.arraycopy(dst, 0, newDst, 0, len);
                dst = newDst;
                this.mCompressedBytes = newDst;
                dstOff = len;
            }
        }
        finally {
            this.mDeflater.reset();
        }
    }

    @Override
    public int compress(long srcPtr, int srcOff, int srcLen) {
        ByteBuffer bb = this.mDirectBuffer;
        if (bb == null) {
            this.mDirectBuffer = bb = DirectAccess.allocDirect();
        }
        DirectAccess.ref(bb, srcPtr + (long)srcOff, srcLen);
        byte[] dst = this.mCompressedBytes;
        if (dst == null) {
            this.mCompressedBytes = dst = new byte[srcLen / 16];
        }
        try {
            this.mDeflater.setInput(bb);
            this.mDeflater.finish();
            int dstOff = 0;
            int len = 0;
            while (true) {
                len += this.mDeflater.deflate(dst, dstOff, dst.length - dstOff);
                if (this.mDeflater.finished()) {
                    int n = len;
                    return n;
                }
                byte[] newDst = new byte[dst.length << 1];
                System.arraycopy(dst, 0, newDst, 0, len);
                dst = newDst;
                this.mCompressedBytes = newDst;
                dstOff = len;
            }
        }
        finally {
            this.mDeflater.reset();
        }
    }

    @Override
    public byte[] compressedBytes() {
        return this.mCompressedBytes;
    }

    @Override
    public void decompress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff, int dstLen) {
        try {
            this.mInflater.setInput(src, srcOff, srcLen);
            this.mInflater.inflate(dst, dstOff, dstLen);
        }
        catch (DataFormatException e) {
            throw Utils.rethrow(e);
        }
        finally {
            this.mInflater.reset();
        }
    }

    @Override
    public void decompress(byte[] src, int srcOff, int srcLen, long dstPtr, int dstOff, int dstLen) {
        ByteBuffer bb = this.mDirectBuffer;
        if (bb == null) {
            this.mDirectBuffer = bb = DirectAccess.allocDirect();
        }
        DirectAccess.ref(bb, dstPtr + (long)dstOff, dstLen);
        try {
            this.mInflater.setInput(src, srcOff, srcLen);
            this.mInflater.inflate(bb);
        }
        catch (DataFormatException e) {
            throw Utils.rethrow(e);
        }
        finally {
            this.mInflater.reset();
        }
    }

    @Override
    public void close() {
        this.mDeflater.end();
        this.mInflater.end();
    }
}

