/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.cojen.tupl.Database;
import org.cojen.tupl.diag.DatabaseStats;
import org.cojen.tupl.diag.VerificationObserver;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.jmx.DatabaseMBean;
import org.cojen.tupl.util.Runner;

public class Registration {
    private static final ReferenceQueue<Object> queue = new ReferenceQueue();

    public static void register(Database db, String base) {
        Registration.cleanup();
        base = Registration.sanitize(base);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            DbBeanWrapper bean = new DbBeanWrapper(db, base);
            ObjectName name = Registration.newObjectName(base);
            if (server.isRegistered(name)) {
                server.unregisterMBean(name);
            }
            server.registerMBean(bean, name);
        }
        catch (JMException e) {
            throw Utils.rethrow(e);
        }
    }

    public static void unregister(String base) {
        Registration.cleanup();
        Registration.doUnregister(Registration.sanitize(base));
    }

    private static void doUnregister(String base) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(Registration.newObjectName(base));
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    private static void cleanup() {
        Reference<Object> ref;
        while ((ref = queue.poll()) != null) {
            if (!(ref instanceof DbBean)) continue;
            DbBean bean = (DbBean)ref;
            Registration.doUnregister(bean.mBase);
        }
    }

    private static String sanitize(String base) {
        return base.replace(',', '_').replace('=', '_').replace(':', '_').replace('\"', '_');
    }

    private static ObjectName newObjectName(String base) throws JMException {
        return new ObjectName("org.cojen.tupl", "database", base);
    }

    private static class DbBeanWrapper
    extends StandardMBean
    implements NotificationEmitter {
        DbBeanWrapper(Database db, String base) throws NotCompliantMBeanException {
            super(new DbBean(db, base), DatabaseMBean.class);
            this.dbBean().mSource = this;
        }

        @Override
        public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
            this.dbBean().addNotificationListener(listener, filter, handback);
        }

        @Override
        public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
            this.dbBean().removeNotificationListener(listener);
        }

        @Override
        public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
            this.dbBean().removeNotificationListener(listener, filter, handback);
        }

        @Override
        public MBeanNotificationInfo[] getNotificationInfo() {
            return this.dbBean().getNotificationInfo();
        }

        private DbBean dbBean() {
            return (DbBean)this.getImplementation();
        }
    }

    private static class DbBean
    extends WeakReference<Database>
    implements DatabaseMBean,
    NotificationEmitter {
        private final String mBase;
        private Object mSource;
        private DatabaseStats mStats;
        private long mStatsTimestamp;
        private boolean mAsyncRunning;
        private final Map<Listener, Boolean> mListeners = new ConcurrentHashMap<Listener, Boolean>(2);
        private long mSequenceNumber;

        DbBean(Database db, String base) {
            super(db);
            this.mBase = base;
        }

        @Override
        public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
            this.mListeners.put(new Listener(listener, filter, handback), true);
        }

        @Override
        public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
            this.removeNotificationListener(listener, null, null);
        }

        @Override
        public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
            if (!this.mListeners.remove(new Listener(listener, filter, handback)).booleanValue()) {
                throw new ListenerNotFoundException();
            }
        }

        @Override
        public MBeanNotificationInfo[] getNotificationInfo() {
            return new MBeanNotificationInfo[0];
        }

        private Notification newNotification(String type, String message) {
            return this.newNotification(type, message, null);
        }

        private Notification newNotification(String type, Throwable ex) {
            return this.newNotification(type, ex.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Notification newNotification(String type, String message, Object param) {
            long num;
            String prefix = "Database." + (String)type;
            if (param != null) {
                prefix = prefix + "(" + param + ")";
            }
            message = prefix + " " + (String)message;
            type = Database.class.getName() + "." + (String)type;
            DbBean dbBean = this;
            synchronized (dbBean) {
                num = ++this.mSequenceNumber;
            }
            return new Notification((String)type, this.mSource, num, System.currentTimeMillis(), (String)message);
        }

        private void notifyAll(Notification n) {
            for (Listener listener : this.mListeners.keySet()) {
                if (listener.filter != null && !listener.filter.isNotificationEnabled(n)) continue;
                try {
                    listener.listener.handleNotification(n, listener.handback);
                }
                catch (Throwable e) {
                    Utils.uncaught(e);
                }
            }
        }

        @Override
        public long getFreeBytes() {
            DatabaseStats stats = this.stats();
            return stats == null ? 0L : stats.freePages * (long)stats.pageSize;
        }

        @Override
        public long getTotalBytes() {
            DatabaseStats stats = this.stats();
            return stats == null ? 0L : stats.totalPages * (long)stats.pageSize;
        }

        @Override
        public long getCacheBytes() {
            DatabaseStats stats = this.stats();
            return stats == null ? 0L : stats.cachePages * (long)stats.pageSize;
        }

        @Override
        public long getDirtyBytes() {
            DatabaseStats stats = this.stats();
            return stats == null ? 0L : stats.dirtyPages * (long)stats.pageSize;
        }

        @Override
        public int getOpenIndexes() {
            DatabaseStats stats = this.stats();
            return stats == null ? 0 : stats.openIndexes;
        }

        @Override
        public long getLockCount() {
            DatabaseStats stats = this.stats();
            return stats == null ? 0L : stats.lockCount;
        }

        @Override
        public long getCursorCount() {
            DatabaseStats stats = this.stats();
            return stats == null ? 0L : stats.cursorCount;
        }

        @Override
        public long getTransactionCount() {
            DatabaseStats stats = this.stats();
            return stats == null ? 0L : stats.transactionCount;
        }

        @Override
        public long getCheckpointDuration() {
            DatabaseStats stats = this.stats();
            return stats == null ? 0L : stats.checkpointDuration;
        }

        @Override
        public long getReplicationBacklog() {
            DatabaseStats stats = this.stats();
            return stats == null ? 0L : stats.replicationBacklog;
        }

        @Override
        public void flush() {
            this.asyncOp(db -> {
                try {
                    db.flush();
                    return this.newNotification("flush", "finished");
                }
                catch (Throwable e) {
                    return this.newNotification("flush", e);
                }
            });
        }

        @Override
        public void sync() {
            this.asyncOp(db -> {
                try {
                    db.sync();
                    return this.newNotification("sync", "finished");
                }
                catch (Throwable e) {
                    return this.newNotification("sync", e);
                }
            });
        }

        @Override
        public void checkpoint() {
            this.asyncOp(db -> {
                try {
                    db.checkpoint();
                    return this.newNotification("checkpoint", "finished");
                }
                catch (Throwable e) {
                    return this.newNotification("checkpoint", e);
                }
            });
        }

        @Override
        public void compactFile(double target) {
            if (target < 0.0 || target > 1.0) {
                throw new IllegalArgumentException("Illegal compaction target: " + target);
            }
            this.asyncOp(db -> {
                try {
                    boolean result = db.compactFile(null, target);
                    return this.newNotification("compactFile", result ? "finished" : "aborted", target);
                }
                catch (Throwable e) {
                    return this.newNotification("compactFile", e);
                }
            });
        }

        @Override
        public void verify() {
            this.asyncOp(db -> {
                try {
                    return this.newNotification("verify", this.doVerify(db));
                }
                catch (Throwable e) {
                    return this.newNotification("verify", e);
                }
            });
        }

        private String doVerify(Database db) throws IOException {
            var observer = new VerificationObserver(){
                volatile String failed;

                @Override
                public boolean indexNodeFailed(long id, int level, String message) {
                    StringBuilder b = new StringBuilder("failed: ");
                    this.appendFailedMessage(b, id, level, message);
                    this.failed = b.toString();
                    return false;
                }
            };
            if (db.verify(observer)) {
                return "passed";
            }
            String message = observer.failed;
            if (message == null) {
                message = "failed";
            }
            return message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DatabaseStats stats() {
            DbBean dbBean = this;
            synchronized (dbBean) {
                DatabaseStats stats = this.mStats;
                if (stats != null && System.nanoTime() - this.mStatsTimestamp < 1000000L) {
                    return stats;
                }
                Database db = this.db();
                if (db != null) {
                    this.mStats = stats = db.stats();
                    this.mStatsTimestamp = System.nanoTime();
                    return stats;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void asyncOp(Op op) {
            Database db = this.db();
            if (db == null) {
                throw new IllegalStateException("Database is closed");
            }
            DbBean dbBean = this;
            synchronized (dbBean) {
                if (this.mAsyncRunning) {
                    throw new IllegalStateException("Another operation is in progress");
                }
                Runner.start(() -> {
                    Notification n;
                    try {
                        n = op.run(db);
                    }
                    finally {
                        DbBean dbBean = this;
                        synchronized (dbBean) {
                            this.mAsyncRunning = false;
                        }
                    }
                    if (n != null) {
                        this.notifyAll(n);
                    }
                });
                this.mAsyncRunning = true;
            }
        }

        private Database db() {
            Database db = (Database)this.get();
            if (db != null && !db.isClosed()) {
                return db;
            }
            this.clear();
            Runner.start(() -> Registration.cleanup());
            return null;
        }
    }

    @FunctionalInterface
    private static interface Op {
        public Notification run(Database var1);
    }

    private record Listener(NotificationListener listener, NotificationFilter filter, Object handback) {
    }
}

