/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.util.function.Function;
import org.cojen.dirmi.RemoteException;
import org.cojen.tupl.remote.Disposable;
import org.cojen.tupl.rows.CommonCleaner;
import org.cojen.tupl.rows.WeakCache;

final class ClientCache
extends WeakCache<Object, Object, Function<Object, Object>> {
    private static final ClientCache THE = new ClientCache();

    public static <K, C> C get(K key, Function<K, C> factory) {
        return (C)THE.obtain((Object)key, factory);
    }

    public static void autoDispose(Object clientObj, Disposable remoteObj) {
        CommonCleaner.access().register(clientObj, () -> {
            try {
                remoteObj.dispose();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        });
    }

    public static void remove(Object clientObj) {
        THE.removeValues(c -> c == clientObj);
    }

    private ClientCache() {
    }

    @Override
    public Object newValue(Object key, Function<Object, Object> factory) {
        return factory.apply(key);
    }
}

