/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import org.cojen.dirmi.Pipe;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.remote.ClientTransaction;
import org.cojen.tupl.remote.ClientView;
import org.cojen.tupl.remote.RemoteCursor;
import org.cojen.tupl.remote.ValueInputStream;
import org.cojen.tupl.remote.ValueOutputStream;

public final class ClientCursor
implements Cursor {
    final ClientView mView;
    RemoteCursor mRemote;
    Transaction mTxn;
    boolean mAutoload = true;

    ClientCursor(ClientView view, RemoteCursor remote, Transaction txn) {
        this.mView = view;
        this.mRemote = remote;
        this.mTxn = txn;
    }

    @Override
    public Ordering ordering() {
        return this.remote().ordering();
    }

    @Override
    public Transaction link(Transaction txn) {
        Transaction old = this.mTxn;
        if (txn != old) {
            this.mRemote.link(this.mView.mDb.remoteTransaction(txn));
            this.mTxn = txn;
        }
        return old;
    }

    @Override
    public Transaction link() {
        return this.mTxn;
    }

    @Override
    public byte[] key() {
        return this.mRemote.key();
    }

    @Override
    public byte[] value() {
        Object value = this.mRemote.value();
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return bytes;
        }
        return NOT_LOADED;
    }

    @Override
    public boolean autoload(boolean mode) {
        boolean old = this.mAutoload;
        if (mode != old) {
            this.remote().autoload(mode);
            this.mAutoload = mode;
        }
        return old;
    }

    @Override
    public boolean autoload() {
        return this.mAutoload;
    }

    @Override
    public int compareKeyTo(byte[] rkey) {
        return this.remote().compareKeyTo(rkey);
    }

    @Override
    public int compareKeyTo(byte[] rkey, int offset, int length) {
        return this.compareKeyTo(Arrays.copyOfRange(rkey, offset, offset + length));
    }

    @Override
    public boolean register() throws IOException {
        return this.remoteTxn().register();
    }

    @Override
    public void unregister() {
        this.remote().unregister();
    }

    @Override
    public LockResult first() throws IOException {
        return this.remoteTxn().first();
    }

    @Override
    public LockResult last() throws IOException {
        return this.remoteTxn().last();
    }

    @Override
    public LockResult skip(long amount) throws IOException {
        return this.remoteTxn().skip(amount);
    }

    @Override
    public LockResult skip(long amount, byte[] limitKey, boolean inclusive) throws IOException {
        return this.remoteTxn().skip(amount, limitKey, inclusive);
    }

    @Override
    public LockResult next() throws IOException {
        return this.remoteTxn().next();
    }

    @Override
    public LockResult nextLe(byte[] limitKey) throws IOException {
        return this.remoteTxn().nextLe(limitKey);
    }

    @Override
    public LockResult nextLt(byte[] limitKey) throws IOException {
        return this.remoteTxn().nextLt(limitKey);
    }

    @Override
    public LockResult previous() throws IOException {
        return this.remoteTxn().previous();
    }

    @Override
    public LockResult previousGe(byte[] limitKey) throws IOException {
        return this.remoteTxn().previousGe(limitKey);
    }

    @Override
    public LockResult previousGt(byte[] limitKey) throws IOException {
        return this.remoteTxn().previousGt(limitKey);
    }

    @Override
    public LockResult find(byte[] key) throws IOException {
        return this.remoteTxn().find(key);
    }

    @Override
    public LockResult findGe(byte[] key) throws IOException {
        return this.remoteTxn().findGe(key);
    }

    @Override
    public LockResult findGt(byte[] key) throws IOException {
        return this.remoteTxn().findGt(key);
    }

    @Override
    public LockResult findLe(byte[] key) throws IOException {
        return this.remoteTxn().findLe(key);
    }

    @Override
    public LockResult findLt(byte[] key) throws IOException {
        return this.remoteTxn().findLt(key);
    }

    @Override
    public LockResult findNearby(byte[] key) throws IOException {
        return this.remoteTxn().findNearby(key);
    }

    @Override
    public LockResult findNearbyGe(byte[] key) throws IOException {
        return this.remoteTxn().findNearbyGe(key);
    }

    @Override
    public LockResult findNearbyGt(byte[] key) throws IOException {
        return this.remoteTxn().findNearbyGt(key);
    }

    @Override
    public LockResult findNearbyLe(byte[] key) throws IOException {
        return this.remoteTxn().findNearbyLe(key);
    }

    @Override
    public LockResult findNearbyLt(byte[] key) throws IOException {
        return this.remoteTxn().findNearbyLt(key);
    }

    @Override
    public LockResult random(byte[] lowKey, byte[] highKey) throws IOException {
        return this.remoteTxn().random(lowKey, highKey);
    }

    @Override
    public LockResult random(byte[] lowKey, boolean lowInclusive, byte[] highKey, boolean highInclusive) throws IOException {
        return this.remoteTxn().random(lowKey, lowInclusive, highKey, highInclusive);
    }

    @Override
    public boolean exists() throws IOException {
        return this.remoteTxn().exists();
    }

    @Override
    public LockResult lock() throws IOException {
        return this.remoteTxn().lock();
    }

    @Override
    public LockResult load() throws IOException {
        return this.remoteTxn().load();
    }

    @Override
    public void store(byte[] value) throws IOException {
        this.remoteTxn().store(value);
    }

    @Override
    public void delete() throws IOException {
        this.remoteTxn().delete();
    }

    @Override
    public void commit(byte[] value) throws IOException {
        this.remote().commit(value);
    }

    @Override
    public Cursor copy() {
        ClientCursor copy = new ClientCursor(this.mView, this.remote().copy(), this.mTxn);
        copy.mAutoload = this.mAutoload;
        return copy;
    }

    @Override
    public void reset() {
        RemoteCursor remote = this.mRemote;
        if (remote != null) {
            remote.reset();
            this.mRemote = null;
        }
    }

    @Override
    public long valueLength() throws IOException {
        return this.remoteValue().valueLength();
    }

    @Override
    public void valueLength(long length) throws IOException {
        this.remoteValue().valueLength(length);
    }

    @Override
    public int valueRead(long pos, byte[] buf, int off, int len) throws IOException {
        Object result;
        ClientCursor.posCheck(pos);
        Objects.checkFromIndexSize(off, len, buf.length);
        Pipe pipe = this.remoteValue().valueRead(pos, len, null);
        try {
            pipe.flush();
            result = pipe.readObject();
            if (result == null) {
                int actual = pipe.readInt();
                if (actual > 0) {
                    pipe.inputStream().readNBytes(buf, off, actual);
                }
                pipe.recycle();
                return actual;
            }
            pipe.recycle();
        }
        catch (Throwable e) {
            throw Utils.fail((AutoCloseable)pipe, e);
        }
        throw Utils.rethrow((Throwable)result);
    }

    @Override
    public void valueWrite(long pos, byte[] buf, int off, int len) throws IOException {
        Object result;
        ClientCursor.posCheck(pos);
        Objects.checkFromIndexSize(off, len, buf.length);
        Pipe pipe = this.remoteValue().valueWrite(pos, len, null);
        try {
            pipe.write(buf, off, len);
            pipe.flush();
            result = pipe.readObject();
            pipe.recycle();
        }
        catch (Throwable e) {
            throw Utils.fail((AutoCloseable)pipe, e);
        }
        if (result instanceof Throwable) {
            Utils.rethrow((Throwable)result);
        }
    }

    @Override
    public void valueClear(long pos, long length) throws IOException {
        ClientCursor.posCheck(pos);
        if (length < 0L) {
            throw new IllegalArgumentException();
        }
        this.remoteValue().valueClear(pos, length);
    }

    @Override
    public InputStream newValueInputStream(long pos) throws IOException {
        ClientCursor.posCheck(pos);
        return new ValueInputStream(this, this.remoteValue().valueReadTransfer(pos, null));
    }

    @Override
    public InputStream newValueInputStream(long pos, int bufferSize) throws IOException {
        ClientCursor.posCheck(pos);
        return new ValueInputStream(this, this.remoteValue().valueReadTransfer(pos, bufferSize, null));
    }

    @Override
    public OutputStream newValueOutputStream(long pos) throws IOException {
        return this.newValueOutputStream(pos, -1);
    }

    @Override
    public OutputStream newValueOutputStream(long pos, int bufferSize) throws IOException {
        ClientCursor.posCheck(pos);
        return new ValueOutputStream(this, this.remoteValue().valueWriteTransfer(pos, null), bufferSize);
    }

    private static void posCheck(long pos) {
        if (pos < 0L) {
            throw new IllegalArgumentException();
        }
    }

    public boolean equalPositions(ClientCursor other) throws IOException {
        return this.remote().equalPositions(other.remote());
    }

    public boolean verifyExtremities(byte extremity) throws IOException {
        return this.remote().verifyExtremities(extremity);
    }

    private RemoteCursor remote() {
        RemoteCursor remote = this.mRemote;
        return remote != null ? remote : this.resurrect();
    }

    private RemoteCursor remoteTxn() {
        RemoteCursor remote = this.mRemote;
        if (remote == null) {
            remote = this.resurrect();
        } else {
            Transaction txn = this.mTxn;
            if (txn instanceof ClientTransaction) {
                ClientTransaction ct = (ClientTransaction)txn;
                ct.activeTxn(this);
            }
        }
        return remote;
    }

    private RemoteCursor remoteValue() {
        RemoteCursor remote = this.mRemote;
        if (remote == null) {
            throw new IllegalStateException();
        }
        Transaction txn = this.mTxn;
        if (txn instanceof ClientTransaction) {
            ClientTransaction ct = (ClientTransaction)txn;
            ct.activeTxn(this);
        }
        return remote;
    }

    private RemoteCursor resurrect() {
        try {
            RemoteCursor remote = this.mView.mRemote.newCursor(this.mView.mDb.remoteTransaction(this.mTxn));
            if (!this.mAutoload) {
                try {
                    remote.autoload(false);
                }
                catch (Throwable e) {
                    try {
                        remote.reset();
                    }
                    catch (Throwable e2) {
                        e.addSuppressed(e2);
                    }
                    throw e;
                }
            }
            this.mRemote = remote;
            return remote;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw Utils.rethrow(e);
            }
            throw new IllegalStateException(e);
        }
    }
}

