/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.IOException;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.ext.CustomHandler;
import org.cojen.tupl.remote.ClientCache;
import org.cojen.tupl.remote.ClientDatabase;
import org.cojen.tupl.remote.RemoteCustomHandler;

final class ClientCustomHandler
implements CustomHandler {
    private final ClientDatabase mDb;
    private final RemoteCustomHandler mRemote;

    ClientCustomHandler(ClientDatabase db, RemoteCustomHandler remote) {
        this.mDb = db;
        this.mRemote = remote;
        ClientCache.autoDispose(this, remote);
    }

    @Override
    public void redo(Transaction txn, byte[] message) throws IOException {
        this.mRemote.redo(this.mDb.remoteTransaction(txn), message);
    }

    @Override
    public void redo(Transaction txn, byte[] message, long indexId, byte[] key) throws IOException {
        this.mRemote.redo(this.mDb.remoteTransaction(txn), message, indexId, key);
    }

    @Override
    public void undo(Transaction txn, byte[] message) throws IOException {
        this.mRemote.undo(this.mDb.remoteTransaction(txn), message);
    }
}

