/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLContext;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.Environment;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.RemoteException;
import org.cojen.dirmi.Session;
import org.cojen.tupl.ClosedIndexException;
import org.cojen.tupl.Database;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.Index;
import org.cojen.tupl.Server;
import org.cojen.tupl.Snapshot;
import org.cojen.tupl.Sorter;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;
import org.cojen.tupl.core.Pair;
import org.cojen.tupl.core.Triple;
import org.cojen.tupl.diag.CompactionObserver;
import org.cojen.tupl.diag.DatabaseStats;
import org.cojen.tupl.diag.VerificationObserver;
import org.cojen.tupl.ext.CustomHandler;
import org.cojen.tupl.ext.PrepareHandler;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.remote.ClientCache;
import org.cojen.tupl.remote.ClientCustomHandler;
import org.cojen.tupl.remote.ClientDeleteIndex;
import org.cojen.tupl.remote.ClientIndex;
import org.cojen.tupl.remote.ClientPrepareHandler;
import org.cojen.tupl.remote.ClientSnapshot;
import org.cojen.tupl.remote.ClientSorter;
import org.cojen.tupl.remote.ClientTransaction;
import org.cojen.tupl.remote.ClientView;
import org.cojen.tupl.remote.RemoteCustomHandler;
import org.cojen.tupl.remote.RemoteDatabase;
import org.cojen.tupl.remote.RemoteDeleteIndex;
import org.cojen.tupl.remote.RemoteIndex;
import org.cojen.tupl.remote.RemoteLeaderNotification;
import org.cojen.tupl.remote.RemotePrepareHandler;
import org.cojen.tupl.remote.RemoteSorter;
import org.cojen.tupl.remote.RemoteTransaction;
import org.cojen.tupl.remote.RemoteUtils;
import org.cojen.tupl.remote.RemoteView;
import org.cojen.tupl.remote.ServerCompactionObserver;
import org.cojen.tupl.remote.ServerRunnable;
import org.cojen.tupl.remote.ServerVerificationObserver;
import org.cojen.tupl.rows.ArrayKey;

public final class ClientDatabase
implements Database {
    private final RemoteDatabase mRemote;
    private final Environment mEnv;
    final ClientTransaction mBogus;

    public static ClientDatabase from(RemoteDatabase remote) throws RemoteException {
        return new ClientDatabase(remote, null);
    }

    public static ClientDatabase connect(SocketAddress addr, SSLContext context, long ... tokens) throws IOException {
        Environment env = RemoteUtils.createEnvironment();
        env.connector(session -> ClientDatabase.connect(session, context, tokens));
        RemoteDatabase remote = (RemoteDatabase)env.connect(RemoteDatabase.class, (Object)Database.class.getName(), addr).root();
        return new ClientDatabase(remote, env);
    }

    private static void connect(Session session, SSLContext context, long ... tokens) throws IOException {
        Socket s;
        SocketAddress address = session.remoteAddress();
        if (context != null) {
            s = context.getSocketFactory().createSocket();
        } else if (address instanceof InetSocketAddress) {
            s = new Socket();
        } else {
            SocketChannel sc = SocketChannel.open(address);
            ClientDatabase.initConnection(Channels.newInputStream(sc), Channels.newOutputStream(sc), tokens);
            session.connected(sc);
            return;
        }
        s.connect(address);
        ClientDatabase.initConnection(s.getInputStream(), s.getOutputStream(), tokens);
        session.connected(s);
    }

    static void initConnection(InputStream in, OutputStream out, long ... tokens) throws IOException {
        out.write(RemoteUtils.encodeConnectHeader(tokens));
        out.flush();
        if (!RemoteUtils.testConnection(in, null, tokens)) {
            throw new IOException("Connection rejected");
        }
    }

    private ClientDatabase(RemoteDatabase remote, Environment env) throws RemoteException {
        this.mRemote = remote;
        this.mEnv = env;
        this.mBogus = new ClientTransaction(this, remote.bogus(), null);
    }

    @Override
    public Index openIndex(byte[] name) throws IOException {
        return this.findIndex((byte[])name.clone(), true);
    }

    @Override
    public Index findIndex(byte[] name) throws IOException {
        return this.findIndex((byte[])name.clone(), false);
    }

    private ClientIndex findIndex(byte[] name, boolean open) throws IOException {
        return ClientCache.get(ArrayKey.make((Object)this, name), key -> {
            RemoteIndex rindex;
            try {
                rindex = open ? this.mRemote.openIndex(name) : this.mRemote.findIndex(name);
            }
            catch (IOException e) {
                throw Utils.rethrow(e);
            }
            return rindex == null ? null : new ClientIndex(this, rindex);
        });
    }

    @Override
    public ClientIndex indexById(long id) throws IOException {
        return ClientCache.get(new Pair<ClientDatabase, Long>(this, id), key -> {
            RemoteIndex rindex;
            try {
                rindex = this.mRemote.indexById(id);
            }
            catch (IOException e) {
                throw Utils.rethrow(e);
            }
            return rindex == null ? null : new ClientIndex(this, rindex);
        });
    }

    @Override
    public void renameIndex(Index index, byte[] newName) throws IOException {
        this.mRemote.renameIndex(this.remoteIndex(index), newName);
    }

    @Override
    public ClientDeleteIndex deleteIndex(Index index) throws IOException {
        Objects.requireNonNull(index);
        RemoteDeleteIndex remote = this.mRemote.deleteIndex(this.remoteIndex(index));
        ClientCache.remove(index);
        return new ClientDeleteIndex((ClientIndex)index, remote);
    }

    @Override
    public Index newTemporaryIndex() throws IOException {
        return new ClientIndex.Temp(this, this.mRemote.newTemporaryIndex());
    }

    @Override
    public View indexRegistryByName() throws IOException {
        return this.indexRegistry(true);
    }

    @Override
    public View indexRegistryById() throws IOException {
        return this.indexRegistry(false);
    }

    private View indexRegistry(boolean byName) throws IOException {
        return ClientCache.get(new Pair<ClientDatabase, Boolean>(this, byName), key -> {
            RemoteView rview;
            try {
                rview = byName ? this.mRemote.indexRegistryByName() : this.mRemote.indexRegistryById();
            }
            catch (IOException e) {
                throw Utils.rethrow(e);
            }
            return new ClientView<RemoteView>(this, rview);
        });
    }

    @Override
    public Transaction newTransaction() {
        return new ClientTransaction(this, this.newRemoteTransaction(), null);
    }

    RemoteTransaction newRemoteTransaction() {
        return this.mRemote.newTransaction();
    }

    @Override
    public Transaction newTransaction(DurabilityMode dm) {
        return new ClientTransaction(this, this.newRemoteTransaction(dm), dm);
    }

    RemoteTransaction newRemoteTransaction(DurabilityMode dm) {
        return this.mRemote.newTransaction(dm);
    }

    @Override
    public CustomHandler customWriter(String name) throws IOException {
        return ClientCache.get(new Triple<Class<CustomHandler>, ClientDatabase, String>(CustomHandler.class, this, name), key -> {
            RemoteCustomHandler handler;
            try {
                handler = this.mRemote.customWriter(name);
            }
            catch (IOException e) {
                throw Utils.rethrow(e);
            }
            return new ClientCustomHandler(this, handler);
        });
    }

    @Override
    public PrepareHandler prepareWriter(String name) throws IOException {
        return ClientCache.get(new Triple<Class<PrepareHandler>, ClientDatabase, String>(PrepareHandler.class, this, name), key -> {
            RemotePrepareHandler handler;
            try {
                handler = this.mRemote.prepareWriter(name);
            }
            catch (IOException e) {
                throw Utils.rethrow(e);
            }
            return new ClientPrepareHandler(this, handler);
        });
    }

    @Override
    public Sorter newSorter() {
        return new ClientSorter(this);
    }

    RemoteSorter newRemoteSorter() throws RemoteException {
        return this.mRemote.newSorter();
    }

    @Override
    public long preallocate(long bytes) throws IOException {
        return this.mRemote.preallocate(bytes);
    }

    @Override
    public long capacityLimit() {
        return this.mRemote.capacityLimit();
    }

    @Override
    public Snapshot beginSnapshot() throws IOException {
        return new ClientSnapshot(this.mRemote.beginSnapshot());
    }

    @Override
    public void createCachePrimer(OutputStream out) throws IOException {
        try (Pipe pipe = this.mRemote.createCachePrimer(null);){
            pipe.flush();
            pipe.inputStream().transferTo(out);
        }
    }

    @Override
    public void applyCachePrimer(InputStream in) throws IOException {
        try (Pipe pipe = this.mRemote.applyCachePrimer(null);){
            pipe.flush();
            in.transferTo(pipe.outputStream());
            pipe.flush();
        }
    }

    @Override
    public Server newServer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DatabaseStats stats() {
        return this.mRemote.stats();
    }

    @Override
    public void flush() throws IOException {
        this.mRemote.flush();
    }

    @Override
    public void sync() throws IOException {
        this.mRemote.sync();
    }

    @Override
    public void checkpoint() throws IOException {
        this.mRemote.checkpoint();
    }

    @Override
    public void suspendCheckpoints() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resumeCheckpoints() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lock commitLock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean compactFile(CompactionObserver observer, double target) throws IOException {
        ServerCompactionObserver server = ServerCompactionObserver.make(this, observer);
        return server.check(this.mRemote.compactFile(server.flags(), server, target));
    }

    @Override
    public boolean verify(VerificationObserver observer) throws IOException {
        ServerVerificationObserver server = ServerVerificationObserver.make(this, observer);
        return server.check(this.mRemote.verify(server.flags(), server));
    }

    @Override
    public boolean isLeader() {
        return this.mRemote.isLeader();
    }

    @Override
    public void uponLeader(Runnable acquired, Runnable lost) {
        ServerRunnable serverAcquired = new ServerRunnable(acquired);
        ServerRunnable serverLost = new ServerRunnable(lost);
        if (!this.uponLeader(serverAcquired, serverLost)) {
            Session.access((Object)this.mRemote).addStateListener((session, exception) -> session.state() != Session.State.CONNECTED || !this.uponLeader(serverAcquired, serverLost));
        }
    }

    private boolean uponLeader(ServerRunnable acquired, ServerRunnable lost) {
        RemoteLeaderNotification notification;
        try {
            notification = this.mRemote.uponLeader(acquired, lost);
        }
        catch (RemoteException e) {
            return false;
        }
        lost.finishTask(() -> {
            try {
                notification.dispose();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        });
        return true;
    }

    @Override
    public boolean failover() throws IOException {
        return this.mRemote.failover();
    }

    @Override
    public void close(Throwable cause) throws IOException {
        this.dispose();
    }

    @Override
    public boolean isClosed() {
        try {
            return this.mRemote.isClosed();
        }
        catch (Exception e) {
            if (e instanceof ClosedException) {
                return true;
            }
            throw e;
        }
    }

    @Override
    public void shutdown() throws IOException {
        this.dispose();
    }

    private void dispose() throws RemoteException {
        if (this.mEnv != null) {
            this.mEnv.close();
        } else {
            this.mRemote.dispose();
            this.mBogus.mRemote.dispose();
        }
    }

    RemoteIndex remoteIndex(Index ix) throws ClosedIndexException {
        if (ix == null) {
            return null;
        }
        if (ix instanceof ClientIndex) {
            ClientIndex ci = (ClientIndex)ix;
            ci.checkClosed();
            if (ci.mDb == this) {
                return (RemoteIndex)ci.mRemote;
            }
        }
        throw new IllegalStateException("Index belongs to a different database");
    }

    RemoteTransaction remoteTransaction(Transaction txn) {
        if (txn == null) {
            return null;
        }
        if (txn instanceof ClientTransaction) {
            ClientTransaction ct = (ClientTransaction)txn;
            if (ct.mDb == this) {
                return ct.remote();
            }
        } else if (txn.isBogus()) {
            return this.mBogus.mRemote;
        }
        throw new IllegalStateException("Transaction belongs to a different database");
    }
}

