/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.IOException;
import org.cojen.dirmi.RemoteException;
import org.cojen.tupl.Filter;
import org.cojen.tupl.Index;
import org.cojen.tupl.Table;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.core.Pair;
import org.cojen.tupl.diag.IndexStats;
import org.cojen.tupl.diag.VerificationObserver;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.remote.ClientCache;
import org.cojen.tupl.remote.ClientDatabase;
import org.cojen.tupl.remote.ClientTable;
import org.cojen.tupl.remote.ClientView;
import org.cojen.tupl.remote.RemoteIndex;
import org.cojen.tupl.remote.RemoteTable;
import org.cojen.tupl.remote.ServerVerificationObserver;

class ClientIndex
extends ClientView<RemoteIndex>
implements Index {
    ClientIndex(ClientDatabase db, RemoteIndex remote) {
        super(db, remote);
    }

    @Override
    public long id() {
        return ((RemoteIndex)this.mRemote).id();
    }

    @Override
    public byte[] name() {
        return ((RemoteIndex)this.mRemote).name();
    }

    @Override
    public String nameString() {
        return ((RemoteIndex)this.mRemote).nameString();
    }

    @Override
    public <R> Table<R> asTable(Class<R> type) throws IOException {
        return ClientCache.get(new Pair<ClientIndex, Class<R>>(this, type), key -> {
            RemoteTable rtable;
            try {
                rtable = ((RemoteIndex)this.mRemote).asTable(type.getName());
            }
            catch (IOException e) {
                throw Utils.rethrow(e);
            }
            return new ClientTable(this.mDb, rtable, type);
        });
    }

    @Override
    public long evict(Transaction txn, byte[] lowKey, byte[] highKey, Filter evictionFilter, boolean autoload) throws IOException {
        return ((RemoteIndex)this.mRemote).evict(this.mDb.remoteTransaction(txn), lowKey, highKey, evictionFilter, autoload);
    }

    @Override
    public IndexStats analyze(byte[] lowKey, byte[] highKey) throws IOException {
        return ((RemoteIndex)this.mRemote).analyze(lowKey, highKey);
    }

    @Override
    public boolean verify(VerificationObserver observer) throws IOException {
        ServerVerificationObserver server = ServerVerificationObserver.make(this.mDb, observer);
        return server.check(((RemoteIndex)this.mRemote).verify(server.flags(), server));
    }

    @Override
    public void close() {
        this.close(true, false);
    }

    @Override
    public boolean isClosed() {
        try {
            return this.mClosed || ((RemoteIndex)this.mRemote).isClosed();
        }
        catch (RemoteException e) {
            this.close();
            return true;
        }
    }

    @Override
    public void drop() throws IOException {
        try {
            ((RemoteIndex)this.mRemote).drop();
        }
        catch (IOException e) {
            this.checkClosed();
            throw e;
        }
        this.close();
    }

    protected void close(boolean removeFromCache, boolean remoteClose) {
        if (!this.mClosed) {
            if (removeFromCache) {
                ClientCache.remove(this);
            }
            this.mClosed = true;
            try {
                if (remoteClose) {
                    ((RemoteIndex)this.mRemote).close();
                } else {
                    ((RemoteIndex)this.mRemote).dispose();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static final class Temp
    extends ClientIndex {
        Temp(ClientDatabase db, RemoteIndex remote) {
            super(db, remote);
        }

        @Override
        public void close() {
            this.close(false, true);
        }
    }
}

