/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.IOException;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.ext.PrepareHandler;
import org.cojen.tupl.remote.ClientCache;
import org.cojen.tupl.remote.ClientDatabase;
import org.cojen.tupl.remote.RemotePrepareHandler;

final class ClientPrepareHandler
implements PrepareHandler {
    private final ClientDatabase mDb;
    private final RemotePrepareHandler mRemote;

    ClientPrepareHandler(ClientDatabase db, RemotePrepareHandler remote) {
        this.mDb = db;
        this.mRemote = remote;
        ClientCache.autoDispose(this, remote);
    }

    @Override
    public void prepare(Transaction txn, byte[] message) throws IOException {
        this.mRemote.prepare(this.mDb.remoteTransaction(txn), message);
    }

    @Override
    public void prepareCommit(Transaction txn, byte[] message) throws IOException {
        this.mRemote.prepareCommit(this.mDb.remoteTransaction(txn), message);
    }
}

