/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.Closeable;
import java.io.IOException;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.RemoteException;
import org.cojen.tupl.Entry;
import org.cojen.tupl.Index;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.Sorter;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.remote.ClientDatabase;
import org.cojen.tupl.remote.ClientIndex;
import org.cojen.tupl.remote.PipeEntryScanner;
import org.cojen.tupl.remote.PipeEntryWriter;
import org.cojen.tupl.remote.RemoteSorter;
import org.cojen.tupl.util.Runner;

final class ClientSorter
implements Sorter {
    private final ClientDatabase mDb;
    private volatile RemoteSorter mSorter;

    ClientSorter(ClientDatabase db) {
        this.mDb = db;
    }

    @Override
    public void add(byte[] key, byte[] value) throws IOException {
        this.sorter().add(key, value);
    }

    @Override
    public void addBatch(byte[][] kvPairs, int offset, int size) throws IOException {
        if (size > 0) {
            Exception ex;
            int end = size << 1;
            if (end < 0 || end > kvPairs.length) {
                throw new IndexOutOfBoundsException();
            }
            Pipe pipe = this.sorter().addBatch(null);
            try {
                pipe.writeInt(size);
                int i = 0;
                do {
                    pipe.writeObject((Object)kvPairs[i++]);
                    pipe.writeObject((Object)kvPairs[i++]);
                } while (--size > 0);
                pipe.flush();
                ex = (Exception)pipe.readThrowable();
                pipe.recycle();
            }
            catch (IOException e) {
                Utils.closeQuietly((Closeable)pipe);
                throw e;
            }
            if (ex != null) {
                throw Utils.rethrow(ex);
            }
        }
    }

    @Override
    public void addAll(Scanner<Entry> s) throws IOException {
        PipeEntryWriter.writeAll(s, this.sorter().addAll(null), true);
    }

    @Override
    public Index finish() throws IOException {
        return new ClientIndex.Temp(this.mDb, this.finishSorter().finish());
    }

    @Override
    public Scanner<Entry> finishScan() throws IOException {
        return this.finishScan(false);
    }

    @Override
    public Scanner<Entry> finishScanReverse() throws IOException {
        return this.finishScan(true);
    }

    private Scanner<Entry> finishScan(boolean reverse) throws IOException {
        Pipe pipe = this.sorter().finishScan(reverse, null);
        try {
            pipe.flush();
        }
        catch (IOException e) {
            Utils.closeQuietly((Closeable)pipe);
        }
        return new PipeEntryScanner(pipe, true);
    }

    @Override
    public Scanner<Entry> finishScan(Scanner<Entry> s) throws IOException {
        return this.finishScan(false, s);
    }

    @Override
    public Scanner<Entry> finishScanReverse(Scanner<Entry> s) throws IOException {
        return this.finishScan(true, s);
    }

    public Scanner<Entry> finishScan(boolean reverse, Scanner<Entry> s) throws IOException {
        Pipe pipe = this.sorter().addAllFinishScan(reverse, null);
        Runner.start(() -> {
            try {
                PipeEntryWriter.writeAll(s, pipe, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        return new PipeEntryScanner(pipe, true);
    }

    @Override
    public long progress() {
        try {
            RemoteSorter sorter = this.mSorter;
            return sorter == null ? 0L : sorter.progress();
        }
        catch (RemoteException e) {
            return 0L;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        RemoteSorter sorter = this.mSorter;
        if (sorter != null) {
            this.mSorter = null;
            sorter.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteSorter sorter() throws RemoteException {
        RemoteSorter sorter = this.mSorter;
        if (sorter == null) {
            ClientSorter clientSorter = this;
            synchronized (clientSorter) {
                sorter = this.mSorter;
                if (sorter == null) {
                    this.mSorter = sorter = this.mDb.newRemoteSorter();
                }
            }
        }
        return sorter;
    }

    private synchronized RemoteSorter finishSorter() throws RemoteException {
        RemoteSorter sorter = this.mSorter;
        if (sorter == null) {
            sorter = this.mDb.newRemoteSorter();
        } else {
            this.mSorter = null;
        }
        return sorter;
    }
}

