/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Comparator;
import java.util.function.Predicate;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.RemoteException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.Table;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Updater;
import org.cojen.tupl.diag.QueryPlan;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.remote.ClientCache;
import org.cojen.tupl.remote.ClientDatabase;
import org.cojen.tupl.remote.ClientTransaction;
import org.cojen.tupl.remote.ClientUpdater;
import org.cojen.tupl.remote.RemoteTable;
import org.cojen.tupl.remote.RemoteTableProxy;
import org.cojen.tupl.remote.RemoteUpdater;
import org.cojen.tupl.rows.ClientTableHelper;
import org.cojen.tupl.rows.RowReader;

final class ClientTable<R>
implements Table<R> {
    final ClientDatabase mDb;
    final RemoteTable mRemote;
    final Class<R> mType;
    private final ClientTableHelper<R> mHelper;
    private RemoteTableProxy mProxy;
    static final VarHandle cProxyHandle;

    ClientTable(ClientDatabase db, RemoteTable remote, Class<R> type) {
        this.mDb = db;
        this.mRemote = remote;
        this.mType = type;
        ClientCache.autoDispose(this, remote);
        this.mHelper = ClientTableHelper.find(type);
    }

    @Override
    public Class<R> rowType() {
        return this.mType;
    }

    @Override
    public R newRow() {
        return this.mHelper.newRow();
    }

    @Override
    public R cloneRow(R row) {
        return this.mHelper.cloneRow(row);
    }

    @Override
    public void unsetRow(R row) {
        this.mHelper.unsetRow(row);
    }

    @Override
    public void copyRow(R from, R to) {
        this.mHelper.copyRow(from, to);
    }

    @Override
    public Scanner<R> newScanner(Transaction txn) throws IOException {
        return this.newScanner(this.mRemote.newScanner(this.mDb.remoteTransaction(txn), null));
    }

    @Override
    public Scanner<R> newScanner(Transaction txn, String query, Object ... args) throws IOException {
        return this.newScanner(this.mRemote.newScanner(this.mDb.remoteTransaction(txn), null, query, args));
    }

    private Scanner<R> newScanner(Pipe pipe) throws IOException {
        try {
            pipe.flush();
            return new RowReader<R, Pipe>(this.mType, pipe){

                @Override
                protected void close(Pipe pipe, boolean finished) throws IOException {
                    if (finished) {
                        pipe.recycle();
                    } else {
                        pipe.close();
                    }
                }
            };
        }
        catch (IOException e) {
            Utils.closeQuietly((Closeable)pipe);
            throw e;
        }
    }

    @Override
    public Updater<R> newUpdater(Transaction txn) throws IOException {
        return this.newUpdater(this.mRemote.newUpdater(this.mDb.remoteTransaction(txn), null));
    }

    @Override
    public Updater<R> newUpdater(Transaction txn, String query, Object ... args) throws IOException {
        return this.newUpdater(this.mRemote.newUpdater(this.mDb.remoteTransaction(txn), null, query, args));
    }

    private ClientUpdater<R> newUpdater(Pipe pipe) throws IOException {
        RemoteTableProxy proxy = this.proxy();
        pipe.writeObject((Object)proxy);
        pipe.flush();
        int characteristics = pipe.readInt();
        long size = (characteristics & 0x40) == 0 ? Long.MAX_VALUE : pipe.readLong();
        RemoteUpdater updater = (RemoteUpdater)pipe.readObject();
        try {
            Object row;
            if (updater == null) {
                row = null;
                pipe.recycle();
            } else {
                row = this.mHelper.newRow();
                this.mHelper.updaterRow(row, pipe);
            }
            return new ClientUpdater<Object>((ClientTableHelper<Object>)this.mHelper, proxy, characteristics, size, updater, row);
        }
        catch (Throwable e) {
            if (updater != null) {
                try {
                    updater.dispose();
                }
                catch (RemoteException e2) {
                    e.addSuppressed(e2);
                }
            }
            throw e;
        }
    }

    @Override
    public Transaction newTransaction(DurabilityMode dm) {
        return new ClientTransaction(this.mDb, this.mRemote.newTransaction(dm), dm);
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.mRemote.isEmpty();
    }

    @Override
    public boolean load(Transaction txn, R row) throws IOException {
        return this.mHelper.load(row, this.proxy().load(this.mDb.remoteTransaction(txn), null));
    }

    @Override
    public boolean exists(Transaction txn, R row) throws IOException {
        return this.mHelper.exists(row, this.proxy().exists(this.mDb.remoteTransaction(txn), null));
    }

    @Override
    public void store(Transaction txn, R row) throws IOException {
        this.mHelper.store(row, this.proxy().store(this.mDb.remoteTransaction(txn), null));
    }

    @Override
    public R exchange(Transaction txn, R row) throws IOException {
        return this.mHelper.exchange(row, this.proxy().exchange(this.mDb.remoteTransaction(txn), null));
    }

    @Override
    public boolean insert(Transaction txn, R row) throws IOException {
        return this.mHelper.insert(row, this.proxy().insert(this.mDb.remoteTransaction(txn), null));
    }

    @Override
    public boolean replace(Transaction txn, R row) throws IOException {
        return this.mHelper.replace(row, this.proxy().replace(this.mDb.remoteTransaction(txn), null));
    }

    @Override
    public boolean update(Transaction txn, R row) throws IOException {
        return this.mHelper.update(row, this.proxy().update(this.mDb.remoteTransaction(txn), null));
    }

    @Override
    public boolean merge(Transaction txn, R row) throws IOException {
        return this.mHelper.merge(row, this.proxy().merge(this.mDb.remoteTransaction(txn), null));
    }

    @Override
    public boolean delete(Transaction txn, R row) throws IOException {
        return this.mHelper.delete(row, this.proxy().delete(this.mDb.remoteTransaction(txn), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteTableProxy proxy() throws IOException {
        RemoteTableProxy proxy = cProxyHandle.getAcquire(this);
        if (proxy == null) {
            ClientTableHelper<R> clientTableHelper = this.mHelper;
            synchronized (clientTableHelper) {
                proxy = this.mProxy;
                if (proxy == null) {
                    proxy = this.mRemote.proxy(this.mHelper.rowDescriptor());
                    cProxyHandle.setRelease(this, proxy);
                }
            }
        }
        return proxy;
    }

    @Override
    public Comparator<R> comparator(String spec) {
        return this.mHelper.comparator(spec);
    }

    @Override
    public Predicate<R> predicate(String query, Object ... args) {
        return this.mHelper.predicate(query, args);
    }

    @Override
    public QueryPlan scannerPlan(Transaction txn, String query, Object ... args) throws IOException {
        return this.mRemote.scannerPlan(this.mDb.remoteTransaction(txn), query, args);
    }

    @Override
    public QueryPlan updaterPlan(Transaction txn, String query, Object ... args) throws IOException {
        return this.mRemote.updaterPlan(this.mDb.remoteTransaction(txn), query, args);
    }

    @Override
    public QueryPlan streamPlan(Transaction txn, String query, Object ... args) throws IOException {
        return this.mRemote.scannerPlan(this.mDb.remoteTransaction(txn), query, args);
    }

    @Override
    public void close() throws IOException {
        ClientCache.remove(this);
        try {
            this.mRemote.dispose();
        }
        catch (ClosedException closedException) {
            // empty catch block
        }
    }

    @Override
    public boolean isClosed() {
        try {
            return this.mRemote.isClosed();
        }
        catch (Exception e) {
            if (e instanceof ClosedException) {
                return true;
            }
            throw e;
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cProxyHandle = lookup.findVarHandle(ClientTable.class, "mProxy", RemoteTableProxy.class);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }
}

