/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.cojen.dirmi.RemoteException;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DeadlockException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.InvalidTransactionException;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.remote.ClientCursor;
import org.cojen.tupl.remote.ClientDatabase;
import org.cojen.tupl.remote.RemoteTransaction;

final class ClientTransaction
implements Transaction {
    final ClientDatabase mDb;
    RemoteTransaction mRemote;
    DurabilityMode mDurabilityMode;
    LockMode mLockMode;
    long mLockTimeoutNanos = Long.MIN_VALUE;
    Throwable mBorked;
    int mScopeCount;

    ClientTransaction(ClientDatabase db, RemoteTransaction remote, DurabilityMode dm) {
        this.mDb = db;
        this.mRemote = remote;
        this.mDurabilityMode = dm;
    }

    @Override
    public void lockMode(LockMode mode) {
        this.remote().lockMode(mode);
        this.mLockMode = mode;
    }

    @Override
    public LockMode lockMode() {
        LockMode mode = this.mLockMode;
        if (mode == null) {
            this.mLockMode = mode = this.remote().lockMode();
        }
        return mode;
    }

    @Override
    public void lockTimeout(long timeout, TimeUnit unit) {
        long timeoutNanos = Utils.toNanos(timeout, unit);
        this.remote().lockTimeoutNanos(timeoutNanos);
        this.mLockTimeoutNanos = timeoutNanos;
    }

    @Override
    public long lockTimeout(TimeUnit unit) {
        long timeoutNanos = this.mLockTimeoutNanos;
        if (timeoutNanos == Long.MIN_VALUE) {
            this.mLockTimeoutNanos = timeoutNanos = this.remote().lockTimeoutNanos();
        }
        return timeoutNanos < 0L ? -1L : unit.convert(timeoutNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public void durabilityMode(DurabilityMode dm) {
        this.remote().durabilityMode(dm);
        this.mDurabilityMode = dm;
    }

    @Override
    public DurabilityMode durabilityMode() {
        DurabilityMode dm = this.mDurabilityMode;
        if (dm == null) {
            this.mDurabilityMode = dm = this.remote().durabilityMode();
        }
        return dm;
    }

    @Override
    public void check() throws DatabaseException {
        RemoteTransaction remote = this.mRemote;
        if (remote != null) {
            remote.check();
        } else {
            this.checkBorked();
        }
    }

    private void checkBorked() throws DatabaseException {
        Throwable borked = this.mBorked;
        if (borked != null) {
            throw new InvalidTransactionException(borked);
        }
    }

    @Override
    public boolean isBogus() {
        return this == this.mDb.mBogus;
    }

    @Override
    public void commit() throws IOException {
        RemoteTransaction remote;
        if (!this.isBogus() && (remote = this.mRemote) != null) {
            remote.commit();
            if (this.mScopeCount == 0) {
                remote.dispose();
                this.mRemote = null;
            }
        }
    }

    @Override
    public void commitAll() throws IOException {
        if (!this.isBogus()) {
            RemoteTransaction remote = this.mRemote;
            if (this.isBogus()) {
                remote.commitAll();
            } else if (remote != null) {
                remote.commitAllAndDispose();
                this.mRemote = null;
            }
        }
    }

    @Override
    public void enter() throws IOException {
        if (this.isBogus()) {
            throw new IllegalStateException("Transaction is bogus");
        }
        this.remote().enter();
        ++this.mScopeCount;
    }

    @Override
    public void exit() throws IOException {
        RemoteTransaction remote;
        if (!this.isBogus() && (remote = this.mRemote) != null) {
            remote.exit();
            int count = this.mScopeCount;
            if (count > 0) {
                this.mScopeCount = count - 1;
            } else {
                remote.dispose();
                this.mRemote = null;
            }
        }
    }

    @Override
    public void reset() throws IOException {
        RemoteTransaction remote;
        if (!this.isBogus() && (remote = this.mRemote) != null) {
            remote.resetAndDispose();
            this.mRemote = null;
        }
    }

    @Override
    public void reset(Throwable cause) {
        if (!this.isBogus()) {
            try {
                RemoteTransaction remote = this.mRemote;
                if (remote != null) {
                    remote.resetAndDispose(cause);
                    this.mRemote = null;
                    this.mBorked = cause;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public LockResult lockShared(long indexId, byte[] key) throws LockFailureException {
        return this.remote().lockShared(indexId, key);
    }

    @Override
    public LockResult lockUpgradable(long indexId, byte[] key) throws LockFailureException {
        return this.remote().lockUpgradable(indexId, key);
    }

    @Override
    public LockResult lockExclusive(long indexId, byte[] key) throws LockFailureException {
        return this.remote().lockExclusive(indexId, key);
    }

    @Override
    public boolean isNested() {
        return this.mScopeCount != 0;
    }

    @Override
    public int nestingLevel() {
        return this.mScopeCount;
    }

    @Override
    public LockResult tryLockShared(long indexId, byte[] key, long nanosTimeout) throws DeadlockException, LockFailureException {
        return this.remote().tryLockShared(indexId, key, nanosTimeout);
    }

    @Override
    public LockResult lockShared(long indexId, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.remote().lockShared(indexId, key, nanosTimeout);
    }

    @Override
    public LockResult tryLockUpgradable(long indexId, byte[] key, long nanosTimeout) throws DeadlockException, LockFailureException {
        return this.remote().tryLockUpgradable(indexId, key, nanosTimeout);
    }

    @Override
    public LockResult lockUpgradable(long indexId, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.remote().lockUpgradable(indexId, key, nanosTimeout);
    }

    @Override
    public LockResult tryLockExclusive(long indexId, byte[] key, long nanosTimeout) throws DeadlockException, LockFailureException {
        return this.remote().tryLockExclusive(indexId, key, nanosTimeout);
    }

    @Override
    public LockResult lockExclusive(long indexId, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.remote().lockExclusive(indexId, key, nanosTimeout);
    }

    @Override
    public LockResult lockCheck(long indexId, byte[] key) {
        return this.remote().lockCheck(indexId, key);
    }

    @Override
    public long lastLockedIndex() {
        RemoteTransaction remote = this.mRemote;
        return remote == null ? 0L : remote.lastLockedIndex();
    }

    @Override
    public byte[] lastLockedKey() {
        RemoteTransaction remote = this.mRemote;
        return remote == null ? null : remote.lastLockedKey();
    }

    @Override
    public void unlock() {
        this.remote().unlock();
    }

    @Override
    public void unlockToShared() {
        this.remote().unlockToShared();
    }

    @Override
    public void unlockCombine() {
        this.remote().unlockCombine();
    }

    @Override
    public long id() {
        return this.remote().id();
    }

    @Override
    public void flush() throws IOException {
        RemoteTransaction remote = this.mRemote;
        if (remote != null) {
            remote.flush();
        }
    }

    RemoteTransaction remote() {
        RemoteTransaction remote = this.mRemote;
        return remote != null ? remote : this.resurrect();
    }

    void activeTxn(ClientCursor c) {
        RemoteTransaction remote = this.mRemote;
        if (remote == null) {
            remote = this.resurrect();
            c.mRemote.link(remote);
        }
    }

    private RemoteTransaction resurrect() {
        try {
            this.checkBorked();
            RemoteTransaction remote = this.mDurabilityMode == null ? this.mDb.newRemoteTransaction() : this.mDb.newRemoteTransaction(this.mDurabilityMode);
            try {
                if (this.mLockMode != null) {
                    this.remote().lockMode(this.mLockMode);
                }
                if (this.mLockTimeoutNanos != Long.MIN_VALUE) {
                    this.remote().lockTimeoutNanos(this.mLockTimeoutNanos);
                }
            }
            catch (Throwable e) {
                try {
                    remote.dispose();
                }
                catch (Throwable e2) {
                    e.addSuppressed(e2);
                }
                throw e;
            }
            this.mRemote = remote;
            return remote;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw Utils.rethrow(e);
            }
            throw new IllegalStateException(e);
        }
    }
}

