/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.IOException;
import java.util.Objects;
import org.cojen.dirmi.RemoteException;
import org.cojen.tupl.Updater;
import org.cojen.tupl.remote.RemoteTableProxy;
import org.cojen.tupl.remote.RemoteUpdater;
import org.cojen.tupl.rows.ClientTableHelper;

final class ClientUpdater<R>
implements Updater<R> {
    private final ClientTableHelper<R> mHelper;
    private final RemoteTableProxy mProxy;
    private final int mCharacteristics;
    private final long mSize;
    private RemoteUpdater mUpdater;
    private R mRow;

    ClientUpdater(ClientTableHelper<R> helper, RemoteTableProxy proxy, int characteristics, long size, RemoteUpdater updater, R row) {
        this.mHelper = helper;
        this.mProxy = proxy;
        this.mCharacteristics = characteristics;
        this.mSize = size;
        this.mUpdater = updater;
        this.mRow = row;
    }

    @Override
    public long estimateSize() {
        return this.mSize;
    }

    @Override
    public int characteristics() {
        return this.mCharacteristics;
    }

    @Override
    public R row() {
        return this.mRow;
    }

    @Override
    public R step() throws IOException {
        RemoteUpdater updater = this.mUpdater;
        return updater == null ? null : (R)this.doStep(updater, this.mHelper.newRow());
    }

    @Override
    public R step(R row) throws IOException {
        RemoteUpdater updater = this.mUpdater;
        return updater == null ? null : (R)this.doStep(updater, Objects.requireNonNull(row));
    }

    private R doStep(RemoteUpdater updater, R row) throws IOException {
        if (!this.mHelper.updaterStep(row, this.mProxy.step(updater, null))) {
            row = null;
            this.dispose(updater);
        }
        this.mRow = row;
        return row;
    }

    @Override
    public R update() throws IOException {
        return this.doUpdate(this.updater(), this.mHelper.newRow());
    }

    @Override
    public R update(R row) throws IOException {
        Objects.requireNonNull(row);
        return this.doUpdate(this.updater(), row);
    }

    private R doUpdate(RemoteUpdater updater, R newRow) throws IOException {
        if (!this.mHelper.updaterUpdate(this.mRow, newRow, this.mProxy.update(updater, null))) {
            newRow = null;
            this.dispose(updater);
        }
        this.mRow = newRow;
        return newRow;
    }

    @Override
    public R delete() throws IOException {
        return this.doDelete(this.updater(), this.mHelper.newRow());
    }

    @Override
    public R delete(R row) throws IOException {
        Objects.requireNonNull(row);
        return this.doDelete(this.updater(), row);
    }

    private R doDelete(RemoteUpdater updater, R newRow) throws IOException {
        if (!this.mHelper.updaterDelete(this.mRow, newRow, this.mProxy.delete(updater, null))) {
            newRow = null;
            this.dispose(updater);
        }
        this.mRow = newRow;
        return newRow;
    }

    @Override
    public void close() throws IOException {
        RemoteUpdater updater = this.mUpdater;
        if (updater != null) {
            this.mUpdater = null;
            this.mRow = null;
            updater.close();
        }
    }

    private void dispose(RemoteUpdater updater) {
        this.mUpdater = null;
        try {
            updater.dispose();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private RemoteUpdater updater() {
        RemoteUpdater updater = this.mUpdater;
        if (updater == null) {
            throw new IllegalStateException("No current row");
        }
        return updater;
    }
}

