/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.IOException;
import org.cojen.tupl.ClosedIndexException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DeadlockException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;
import org.cojen.tupl.ViewConstraintException;
import org.cojen.tupl.remote.ClientCache;
import org.cojen.tupl.remote.ClientCursor;
import org.cojen.tupl.remote.ClientDatabase;
import org.cojen.tupl.remote.ClientTransaction;
import org.cojen.tupl.remote.RemoteView;

class ClientView<R extends RemoteView>
implements View {
    final ClientDatabase mDb;
    final R mRemote;
    protected volatile boolean mClosed;

    ClientView(ClientDatabase db, R remote) {
        this.mDb = db;
        this.mRemote = remote;
        ClientCache.autoDispose(this, remote);
    }

    @Override
    public Ordering ordering() {
        return this.mRemote.ordering();
    }

    @Override
    public Cursor newCursor(Transaction txn) {
        return new ClientCursor(this, this.mRemote.newCursor(this.mDb.remoteTransaction(txn)), txn);
    }

    @Override
    public Cursor newAccessor(Transaction txn, byte[] key) throws IOException {
        return new ClientCursor(this, this.mRemote.newAccessor(this.mDb.remoteTransaction(txn), key), txn);
    }

    @Override
    public Transaction newTransaction(DurabilityMode dm) {
        return new ClientTransaction(this.mDb, this.mRemote.newTransaction(dm), dm);
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.mRemote.isEmpty();
    }

    @Override
    public long count(byte[] lowKey, byte[] highKey) throws IOException {
        return this.mRemote.count(lowKey, highKey);
    }

    @Override
    public long count(byte[] lowKey, boolean lowInclusive, byte[] highKey, boolean highInclusive) throws IOException {
        return this.mRemote.count(lowKey, lowInclusive, highKey, highInclusive);
    }

    @Override
    public byte[] load(Transaction txn, byte[] key) throws IOException {
        return this.mRemote.load(this.mDb.remoteTransaction(txn), key);
    }

    @Override
    public boolean exists(Transaction txn, byte[] key) throws IOException {
        return this.mRemote.exists(this.mDb.remoteTransaction(txn), key);
    }

    @Override
    public void store(Transaction txn, byte[] key, byte[] value) throws IOException {
        this.mRemote.store(this.mDb.remoteTransaction(txn), key, value);
    }

    @Override
    public byte[] exchange(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.mRemote.exchange(this.mDb.remoteTransaction(txn), key, value);
    }

    @Override
    public boolean insert(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.mRemote.insert(this.mDb.remoteTransaction(txn), key, value);
    }

    @Override
    public boolean replace(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.mRemote.replace(this.mDb.remoteTransaction(txn), key, value);
    }

    @Override
    public boolean update(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.mRemote.update(this.mDb.remoteTransaction(txn), key, value);
    }

    @Override
    public boolean update(Transaction txn, byte[] key, byte[] oldValue, byte[] newValue) throws IOException {
        return this.mRemote.update(this.mDb.remoteTransaction(txn), key, oldValue, newValue);
    }

    @Override
    public boolean delete(Transaction txn, byte[] key) throws IOException {
        return this.mRemote.delete(this.mDb.remoteTransaction(txn), key);
    }

    @Override
    public boolean remove(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.mRemote.remove(this.mDb.remoteTransaction(txn), key, value);
    }

    @Override
    public LockResult touch(Transaction txn, byte[] key) throws LockFailureException {
        return this.mRemote.touch(this.mDb.remoteTransaction(txn), key);
    }

    @Override
    public LockResult tryLockShared(Transaction txn, byte[] key, long nanosTimeout) throws DeadlockException, LockFailureException, ViewConstraintException {
        return this.mRemote.tryLockShared(this.mDb.remoteTransaction(txn), key, nanosTimeout);
    }

    @Override
    public LockResult lockShared(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mRemote.lockShared(this.mDb.remoteTransaction(txn), key);
    }

    @Override
    public LockResult tryLockUpgradable(Transaction txn, byte[] key, long nanosTimeout) throws DeadlockException, LockFailureException, ViewConstraintException {
        return this.mRemote.tryLockUpgradable(this.mDb.remoteTransaction(txn), key, nanosTimeout);
    }

    @Override
    public LockResult lockUpgradable(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mRemote.lockUpgradable(this.mDb.remoteTransaction(txn), key);
    }

    @Override
    public LockResult tryLockExclusive(Transaction txn, byte[] key, long nanosTimeout) throws DeadlockException, LockFailureException, ViewConstraintException {
        return this.mRemote.tryLockExclusive(this.mDb.remoteTransaction(txn), key, nanosTimeout);
    }

    @Override
    public LockResult lockExclusive(Transaction txn, byte[] key) throws LockFailureException, ViewConstraintException {
        return this.mRemote.lockExclusive(this.mDb.remoteTransaction(txn), key);
    }

    @Override
    public LockResult lockCheck(Transaction txn, byte[] key) throws ViewConstraintException {
        return this.mRemote.lockCheck(this.mDb.remoteTransaction(txn), key);
    }

    @Override
    public boolean isUnmodifiable() {
        return this.mRemote.isUnmodifiable();
    }

    @Override
    public boolean isModifyAtomic() {
        return this.mRemote.isModifyAtomic();
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    void checkClosed() throws ClosedIndexException {
        if (this.isClosed()) {
            throw new ClosedIndexException();
        }
    }
}

