/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.IOException;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.RemoteException;
import org.cojen.tupl.Database;
import org.cojen.tupl.Index;
import org.cojen.tupl.diag.CompactionObserver;
import org.cojen.tupl.remote.RemoteCompactionObserver;

final class CompactionObserverRelay
extends CompactionObserver {
    private final boolean mPassMessages;
    private final RemoteCompactionObserver mRemote;
    private Pipe mPipe;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compactFile(int flags, Database db, RemoteCompactionObserver remote, double target) throws IOException {
        if (remote == null) {
            return db.compactFile(new CompactionObserver(), target);
        }
        CompactionObserverRelay relay = new CompactionObserverRelay(flags, remote);
        try {
            boolean bl = db.compactFile(relay, target);
            return bl;
        }
        finally {
            relay.finished();
        }
    }

    private CompactionObserverRelay(int flags, RemoteCompactionObserver remote) {
        this.mPassMessages = (flags & 1) != 0;
        this.mRemote = remote;
    }

    private void finished() {
        try {
            try {
                if (this.mPipe != null) {
                    this.mPipe.flush();
                    this.mPipe.close();
                    this.mPipe = null;
                }
            }
            finally {
                this.mRemote.finished();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean indexBegin(Index index) {
        try {
            return this.mRemote.indexBegin(index.id());
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean indexComplete(Index index) {
        if (this.mPipe != null) {
            try {
                this.mPipe.writeLong(0L);
                this.mPipe.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            return this.mRemote.indexComplete(index.id());
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean indexNodeVisited(long id) {
        if (!this.mPassMessages) {
            return true;
        }
        try {
            Pipe pipe = this.mPipe;
            if (pipe == null) {
                this.mPipe = pipe = this.mRemote.indexNodeVisited(null);
                pipe.write(1);
                pipe.flush();
                if (pipe.read() < 0) {
                    return false;
                }
            }
            pipe.writeLong(id);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

