/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.IOException;
import java.util.Set;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.Serializer;
import org.cojen.tupl.DeadlockException;

public final class DeadlockExceptionSerializer
implements Serializer {
    static final DeadlockExceptionSerializer THE = new DeadlockExceptionSerializer();

    private DeadlockExceptionSerializer() {
    }

    public Set<Class<?>> supportedTypes() {
        return Set.of(DeadlockException.class);
    }

    public void write(Pipe pipe, Object obj) throws IOException {
        DeadlockException e = (DeadlockException)obj;
        pipe.writeObject((Object)e.getStackTrace());
        pipe.writeLong(e.timeoutNanos());
        Object att = e.ownerAttachment();
        if (att != null) {
            pipe.writeObject((Object)att.toString());
        } else {
            pipe.writeNull();
        }
        pipe.writeBoolean(e.isGuilty());
        pipe.writeObject(e.deadlockSet());
    }

    public Object read(Pipe pipe) throws IOException {
        StackTraceElement[] trace = (StackTraceElement[])pipe.readObject();
        long timeoutNanos = pipe.readLong();
        Object att = pipe.readObject();
        boolean guilty = pipe.readBoolean();
        Set set = (Set)pipe.readObject();
        DeadlockException e = new DeadlockException(timeoutNanos, att, guilty, set);
        e.setStackTrace(trace);
        return e;
    }
}

