/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.IOException;
import java.util.Set;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.Serializer;
import org.cojen.tupl.core.CoreDeadlockInfo;
import org.cojen.tupl.core.DetachedDeadlockInfo;
import org.cojen.tupl.diag.DeadlockInfo;

public final class DeadlockInfoSerializer
implements Serializer {
    static final DeadlockInfoSerializer THE = new DeadlockInfoSerializer();

    private DeadlockInfoSerializer() {
    }

    public Set<Class<?>> supportedTypes() {
        return Set.of(CoreDeadlockInfo.class, DetachedDeadlockInfo.class);
    }

    public void write(Pipe pipe, Object obj) throws IOException {
        DeadlockInfo info = (DeadlockInfo)obj;
        Object row = info.row();
        if (row != null) {
            pipe.writeObject((Object)row.toString());
        } else {
            pipe.writeNull();
        }
        pipe.writeLong(info.indexId());
        pipe.writeObject((Object)info.indexName());
        pipe.writeObject((Object)info.key());
        Object att = info.ownerAttachment();
        if (att != null) {
            pipe.writeObject((Object)att.toString());
        } else {
            pipe.writeNull();
        }
    }

    public Object read(Pipe pipe) throws IOException {
        Object row = pipe.readObject();
        long indexId = pipe.readLong();
        byte[] indexName = (byte[])pipe.readObject();
        byte[] key = (byte[])pipe.readObject();
        Object att = pipe.readObject();
        return new CoreDeadlockInfo(row, indexId, indexName, key, att);
    }
}

