/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.IOException;
import java.util.Set;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.Serializer;
import org.cojen.tupl.LockTimeoutException;

public final class LockTimeoutExceptionSerializer
implements Serializer {
    static final LockTimeoutExceptionSerializer THE = new LockTimeoutExceptionSerializer();

    private LockTimeoutExceptionSerializer() {
    }

    public Set<Class<?>> supportedTypes() {
        return Set.of(LockTimeoutException.class);
    }

    public void write(Pipe pipe, Object obj) throws IOException {
        LockTimeoutException e = (LockTimeoutException)obj;
        pipe.writeObject((Object)e.getStackTrace());
        pipe.writeLong(e.timeoutNanos());
        Object att = e.ownerAttachment();
        if (att != null) {
            pipe.writeObject((Object)att.toString());
        } else {
            pipe.writeNull();
        }
    }

    public Object read(Pipe pipe) throws IOException {
        StackTraceElement[] trace = (StackTraceElement[])pipe.readObject();
        long timeoutNanos = pipe.readLong();
        Object att = pipe.readObject();
        LockTimeoutException e = new LockTimeoutException(timeoutNanos, att);
        e.setStackTrace(trace);
        return e;
    }
}

