/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.Objects;
import org.cojen.dirmi.Pipe;
import org.cojen.tupl.Entry;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.core.EntryPopulator;
import org.cojen.tupl.io.Utils;

final class PipeEntryScanner
implements Scanner<Entry> {
    private static final MethodHandle POPULATOR = EntryPopulator.THE;
    private final long mSize;
    private final int mCharacteristics;
    private final boolean mRecycle;
    private Pipe mPipe;
    private Entry mEntry;

    PipeEntryScanner(Pipe pipe, boolean recycle) throws IOException {
        try {
            this.mSize = pipe.readLong();
            this.mCharacteristics = pipe.readInt();
        }
        catch (IOException e) {
            Utils.closeQuietly((Closeable)pipe);
            throw e;
        }
        this.mRecycle = recycle;
        this.mPipe = pipe;
        this.step();
    }

    @Override
    public long estimateSize() {
        return this.mSize;
    }

    @Override
    public int characteristics() {
        return this.mCharacteristics;
    }

    @Override
    public Entry row() {
        return this.mEntry;
    }

    @Override
    public Entry step() throws IOException {
        return this.doStep(null);
    }

    @Override
    public Entry step(Entry row) throws IOException {
        Objects.requireNonNull(row);
        return this.doStep(row);
    }

    private Entry doStep(Entry row) throws IOException {
        byte[] key;
        Pipe pipe = this.mPipe;
        if (pipe == null) {
            return null;
        }
        try {
            key = (byte[])pipe.readObject();
        }
        catch (Exception e) {
            Utils.closeQuietly(this);
            throw e;
        }
        if (key == null) {
            this.mEntry = null;
            this.mPipe = null;
            if (this.mRecycle) {
                pipe.write(1);
                pipe.flush();
                pipe.recycle();
            }
            return null;
        }
        try {
            byte[] value = (byte[])pipe.readObject();
            this.mEntry = row = POPULATOR.invokeExact(row, key, value);
            return row;
        }
        catch (Throwable e) {
            Utils.closeQuietly(this);
            throw Utils.rethrow(e);
        }
    }

    @Override
    public void close() throws IOException {
        Pipe pipe = this.mPipe;
        if (pipe != null) {
            this.mEntry = null;
            this.mPipe = null;
            pipe.close();
        }
    }
}

