/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.Closeable;
import java.io.IOException;
import org.cojen.dirmi.Pipe;
import org.cojen.tupl.Entry;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.io.Utils;

final class PipeEntryWriter {
    PipeEntryWriter() {
    }

    static void writeAll(Scanner<Entry> scanner, Pipe pipe, boolean recycle) throws IOException {
        try {
            pipe.writeLong(scanner.estimateSize());
            pipe.writeInt(scanner.characteristics());
            Entry row = scanner.row();
            while (row != null) {
                pipe.writeObject((Object)row.key());
                pipe.writeObject((Object)row.value());
                row = scanner.step(row);
            }
            pipe.writeNull();
            pipe.flush();
            if (recycle && pipe.read() >= 0) {
                pipe.recycle();
            }
        }
        catch (Throwable e) {
            Utils.closeQuietly((Closeable)pipe);
            Utils.closeQuietly(scanner);
            throw e;
        }
    }
}

