/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.IOException;
import java.util.Map;
import org.cojen.dirmi.Batched;
import org.cojen.dirmi.Disposer;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.Remote;
import org.cojen.dirmi.RemoteException;
import org.cojen.dirmi.RemoteFailure;
import org.cojen.dirmi.Restorable;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.diag.DatabaseStats;
import org.cojen.tupl.remote.Disposable;
import org.cojen.tupl.remote.RemoteCompactionObserver;
import org.cojen.tupl.remote.RemoteCustomHandler;
import org.cojen.tupl.remote.RemoteDeleteIndex;
import org.cojen.tupl.remote.RemoteIndex;
import org.cojen.tupl.remote.RemoteLeaderNotification;
import org.cojen.tupl.remote.RemotePrepareHandler;
import org.cojen.tupl.remote.RemoteRunnable;
import org.cojen.tupl.remote.RemoteSorter;
import org.cojen.tupl.remote.RemoteTransaction;
import org.cojen.tupl.remote.RemoteVerificationObserver;
import org.cojen.tupl.remote.RemoteView;

public interface RemoteDatabase
extends Remote,
Disposable {
    @Restorable
    public RemoteIndex openIndex(byte[] var1) throws IOException;

    @Restorable
    public RemoteIndex findIndex(byte[] var1) throws IOException;

    @Restorable
    public RemoteIndex indexById(long var1) throws IOException;

    public void renameIndex(RemoteIndex var1, byte[] var2) throws IOException;

    public RemoteDeleteIndex deleteIndex(RemoteIndex var1) throws IOException;

    public RemoteIndex newTemporaryIndex() throws IOException;

    @Restorable
    public RemoteView indexRegistryByName() throws IOException;

    @Restorable
    public RemoteView indexRegistryById() throws IOException;

    @Batched
    @RemoteFailure(declared=false)
    public RemoteTransaction newTransaction();

    @Batched
    @RemoteFailure(declared=false)
    public RemoteTransaction newTransaction(DurabilityMode var1);

    @Restorable
    public RemoteTransaction bogus() throws RemoteException;

    @Restorable
    public RemoteCustomHandler customWriter(String var1) throws IOException;

    @Restorable
    public RemotePrepareHandler prepareWriter(String var1) throws IOException;

    public RemoteSorter newSorter() throws RemoteException;

    public long preallocate(long var1) throws IOException;

    @RemoteFailure(declared=false)
    public long capacityLimit();

    public Map beginSnapshot() throws IOException;

    public Pipe createCachePrimer(Pipe var1) throws IOException;

    public Pipe applyCachePrimer(Pipe var1) throws IOException;

    @RemoteFailure(declared=false)
    public DatabaseStats stats();

    public void flush() throws IOException;

    public void sync() throws IOException;

    public void checkpoint() throws IOException;

    public boolean compactFile(int var1, RemoteCompactionObserver var2, double var3) throws IOException;

    public boolean verify(int var1, RemoteVerificationObserver var2) throws IOException;

    @RemoteFailure(declared=false)
    public boolean isLeader();

    @Restorable
    public RemoteLeaderNotification uponLeader(RemoteRunnable var1, RemoteRunnable var2) throws RemoteException;

    public boolean failover() throws IOException;

    @Disposer
    public void close() throws IOException;

    @Disposer
    public void close(Throwable var1) throws IOException;

    @RemoteFailure(declared=false)
    public boolean isClosed();

    @Disposer
    public void shutdown() throws IOException;
}

