/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.cojen.dirmi.Batched;
import org.cojen.dirmi.Disposer;
import org.cojen.dirmi.NoReply;
import org.cojen.dirmi.Remote;
import org.cojen.dirmi.RemoteException;
import org.cojen.dirmi.RemoteFailure;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DeadlockException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.remote.Disposable;

public interface RemoteTransaction
extends Remote,
Disposable {
    @Batched
    @RemoteFailure(declared=false)
    public void lockMode(LockMode var1);

    @RemoteFailure(declared=false)
    public LockMode lockMode();

    @Batched
    @RemoteFailure(declared=false)
    public void lockTimeout(long var1, TimeUnit var3);

    @Batched
    @RemoteFailure(declared=false)
    public void lockTimeoutNanos(long var1);

    @RemoteFailure(declared=false)
    public long lockTimeout(TimeUnit var1);

    @RemoteFailure(declared=false)
    public long lockTimeoutNanos();

    @Batched
    @RemoteFailure(declared=false)
    public void durabilityMode(DurabilityMode var1);

    @RemoteFailure(declared=false)
    public DurabilityMode durabilityMode();

    @RemoteFailure(exception=DatabaseException.class)
    public void check() throws DatabaseException;

    @RemoteFailure(declared=false)
    public boolean isBogus();

    public void commit() throws IOException;

    public void commitAll() throws IOException;

    @Disposer
    default public void commitAllAndDispose() throws IOException {
        this.commitAll();
    }

    @Batched
    public void enter() throws IOException;

    public void exit() throws IOException;

    public void reset() throws IOException;

    @Disposer
    default public void resetAndDispose() throws IOException {
        this.reset();
    }

    public void reset(Throwable var1) throws RemoteException;

    @NoReply
    @Disposer
    default public void resetAndDispose(Throwable cause) throws RemoteException {
        this.reset(cause);
    }

    @RemoteFailure(declared=false)
    public LockResult lockShared(long var1, byte[] var3) throws LockFailureException;

    @RemoteFailure(declared=false)
    public LockResult lockUpgradable(long var1, byte[] var3) throws LockFailureException;

    @RemoteFailure(declared=false)
    public LockResult lockExclusive(long var1, byte[] var3) throws LockFailureException;

    @RemoteFailure(declared=false)
    public boolean isNested();

    @RemoteFailure(declared=false)
    public int nestingLevel();

    @RemoteFailure(declared=false)
    public LockResult tryLockShared(long var1, byte[] var3, long var4) throws DeadlockException, LockFailureException;

    @RemoteFailure(declared=false)
    public LockResult lockShared(long var1, byte[] var3, long var4) throws LockFailureException;

    @RemoteFailure(declared=false)
    public LockResult tryLockUpgradable(long var1, byte[] var3, long var4) throws DeadlockException, LockFailureException;

    @RemoteFailure(declared=false)
    public LockResult lockUpgradable(long var1, byte[] var3, long var4) throws LockFailureException;

    @RemoteFailure(declared=false)
    public LockResult tryLockExclusive(long var1, byte[] var3, long var4) throws DeadlockException, LockFailureException;

    @RemoteFailure(declared=false)
    public LockResult lockExclusive(long var1, byte[] var3, long var4) throws LockFailureException;

    @RemoteFailure(declared=false)
    public LockResult lockCheck(long var1, byte[] var3);

    @RemoteFailure(declared=false)
    public long lastLockedIndex();

    @RemoteFailure(declared=false)
    public byte[] lastLockedKey();

    @RemoteFailure(declared=false)
    public void unlock();

    @RemoteFailure(declared=false)
    public void unlockToShared();

    @RemoteFailure(declared=false)
    public void unlockCombine();

    @RemoteFailure(declared=false)
    public long id();

    public void flush() throws IOException;
}

