/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.TimeUnit;
import org.cojen.dirmi.Environment;
import org.cojen.dirmi.Serializer;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.diag.DatabaseStats;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.remote.DeadlockExceptionSerializer;
import org.cojen.tupl.remote.DeadlockInfoSerializer;
import org.cojen.tupl.remote.LockTimeoutExceptionSerializer;

public class RemoteUtils {
    private static final VarHandle cLongArrayElementHandle;
    private static final long MAGIC_NUMBER = 2825672906279293275L;
    private static final long GROUP_ID = 5156919750013540996L;
    private static final int HEADER_SIZE = 44;

    public static Environment createEnvironment() {
        Environment env = Environment.create();
        env.customSerializers(new Serializer[]{Serializer.simple(DatabaseStats.class), Serializer.simple(TimeUnit.class), Serializer.simple(DurabilityMode.class), Serializer.simple(LockMode.class), Serializer.simple(LockResult.class), Serializer.simple(Ordering.class), LockTimeoutExceptionSerializer.THE, DeadlockInfoSerializer.THE, DeadlockExceptionSerializer.THE});
        return env;
    }

    public static byte[] encodeConnectHeader(long ... tokens) {
        if (tokens.length < 1 || tokens.length > 2) {
            throw new IllegalArgumentException("Must provide one or two tokens");
        }
        byte[] header = new byte[44];
        Utils.encodeLongLE(header, 0, 2825672906279293275L);
        Utils.encodeLongLE(header, 8, 5156919750013540996L);
        for (int i = 0; i < tokens.length; ++i) {
            long token = cLongArrayElementHandle.getAcquire(tokens, i);
            Utils.encodeLongLE(header, 28 + i * 8, token);
        }
        return header;
    }

    public static boolean testConnection(InputStream in, OutputStream out, long ... tokens) throws IOException {
        byte[] header = new byte[44];
        if (in.readNBytes(header, 0, header.length) < header.length) {
            return false;
        }
        if (Utils.decodeLongLE(header, 0) != 2825672906279293275L || Utils.decodeLongLE(header, 8) != 5156919750013540996L) {
            return false;
        }
        boolean passed = false;
        block0: for (int i = 0; i < 2; ++i) {
            long provided = Utils.decodeLongLE(header, 28 + i * 8);
            for (int j = 0; j < tokens.length; ++j) {
                long token = cLongArrayElementHandle.getAcquire(tokens, j);
                if (provided != token) continue;
                passed = true;
                break block0;
            }
        }
        if (out != null) {
            if (!passed) {
                Utils.encodeLongLE(header, 8, 0L);
            }
            out.write(header);
        }
        return passed;
    }

    static {
        try {
            cLongArrayElementHandle = MethodHandles.arrayElementVarHandle(long[].class);
        }
        catch (Throwable e) {
            throw new ExceptionInInitializerError();
        }
    }
}

