/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import org.cojen.dirmi.Pipe;
import org.cojen.tupl.Database;
import org.cojen.tupl.Index;
import org.cojen.tupl.diag.CompactionObserver;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.remote.RemoteCompactionObserver;
import org.cojen.tupl.util.Runner;

final class ServerCompactionObserver
implements RemoteCompactionObserver {
    private final int mFlags;
    private final Database mDb;
    private final CompactionObserver mObserver;
    private boolean mExpectTerminators;
    private boolean mTerminated;
    private Throwable mException;

    static ServerCompactionObserver make(Database db, CompactionObserver observer) {
        int flags;
        if (observer == null) {
            flags = 0;
            observer = new CompactionObserver();
        } else {
            flags = 1;
            try {
                Method method = observer.getClass().getMethod("indexNodeVisited", Long.TYPE);
                if (method.getDeclaringClass() == CompactionObserver.class) {
                    flags = 0;
                }
            }
            catch (Exception e) {
                throw Utils.rethrow(e);
            }
        }
        return new ServerCompactionObserver(flags, db, observer);
    }

    private ServerCompactionObserver(int flags, Database db, CompactionObserver observer) {
        this.mFlags = flags;
        this.mDb = db;
        this.mObserver = observer;
    }

    int flags() {
        return this.mFlags;
    }

    synchronized boolean check(boolean result) {
        Throwable ex = this.mException;
        if (ex != null) {
            throw Utils.rethrow(ex);
        }
        return result;
    }

    @Override
    public synchronized boolean indexBegin(long indexId) {
        return this.mObserver.indexBegin(this.indexFor(indexId));
    }

    @Override
    public synchronized boolean indexComplete(long indexId) {
        if (this.mExpectTerminators) {
            try {
                while (!this.mTerminated) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mTerminated = false;
        }
        return this.mObserver.indexComplete(this.indexFor(indexId));
    }

    @Override
    public Pipe indexNodeVisited(Pipe pipe) {
        Runner.start(() -> this.readIndexNodeVisited(pipe));
        return null;
    }

    @Override
    public void finished() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIndexNodeVisited(Pipe pipe) {
        ServerCompactionObserver serverCompactionObserver = this;
        synchronized (serverCompactionObserver) {
            this.mExpectTerminators = true;
        }
        try {
            pipe.read();
            pipe.write(1);
            pipe.flush();
            CompactionObserver observer = this.mObserver;
            while (true) {
                boolean keepGoing;
                long id;
                if ((id = pipe.readLong()) == 0L) {
                    ServerCompactionObserver serverCompactionObserver2 = this;
                    synchronized (serverCompactionObserver2) {
                        this.mTerminated = true;
                        this.notify();
                    }
                }
                ServerCompactionObserver serverCompactionObserver3 = this;
                synchronized (serverCompactionObserver3) {
                    try {
                        keepGoing = observer.indexNodeVisited(id);
                    }
                    catch (Throwable e) {
                        this.mException = e;
                        break;
                    }
                }
                if (!keepGoing) break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Utils.closeQuietly((Closeable)pipe);
    }

    private Index indexFor(long indexId) {
        try {
            return this.mDb.indexById(indexId);
        }
        catch (IOException | IllegalArgumentException e) {
            return null;
        }
    }
}

