/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.Session;
import org.cojen.dirmi.SessionAware;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.remote.RemoteCursor;
import org.cojen.tupl.remote.RemoteOutputControl;
import org.cojen.tupl.remote.RemoteTransaction;
import org.cojen.tupl.remote.ServerTransaction;

final class ServerCursor
implements RemoteCursor,
SessionAware {
    final Cursor mCursor;

    ServerCursor(Cursor c) {
        this.mCursor = c;
    }

    public void attached(Session<?> session) {
    }

    public void detached(Session<?> session) {
        this.mCursor.reset();
    }

    @Override
    public Ordering ordering() {
        return this.mCursor.ordering();
    }

    @Override
    public void link(RemoteTransaction txn) {
        this.mCursor.link(ServerTransaction.txn(txn));
    }

    @Override
    public byte[] key() {
        return this.mCursor.key();
    }

    @Override
    public Object value() {
        Object value = this.mCursor.value();
        if (value == Cursor.NOT_LOADED) {
            value = false;
        }
        return value;
    }

    @Override
    public void autoload(boolean mode) {
        this.mCursor.autoload(mode);
    }

    @Override
    public int compareKeyTo(byte[] rkey) {
        return this.mCursor.compareKeyTo(rkey);
    }

    @Override
    public boolean register() throws IOException {
        return this.mCursor.register();
    }

    @Override
    public void unregister() {
        this.mCursor.unregister();
    }

    @Override
    public LockResult first() throws IOException {
        return this.mCursor.first();
    }

    @Override
    public LockResult last() throws IOException {
        return this.mCursor.last();
    }

    @Override
    public LockResult skip(long amount) throws IOException {
        return this.mCursor.skip(amount);
    }

    @Override
    public LockResult skip(long amount, byte[] limitKey, boolean inclusive) throws IOException {
        return this.mCursor.skip(amount, limitKey, inclusive);
    }

    @Override
    public LockResult next() throws IOException {
        return this.mCursor.next();
    }

    @Override
    public LockResult nextLe(byte[] limitKey) throws IOException {
        return this.mCursor.nextLe(limitKey);
    }

    @Override
    public LockResult nextLt(byte[] limitKey) throws IOException {
        return this.mCursor.nextLt(limitKey);
    }

    @Override
    public LockResult previous() throws IOException {
        return this.mCursor.previous();
    }

    @Override
    public LockResult previousGe(byte[] limitKey) throws IOException {
        return this.mCursor.previousGe(limitKey);
    }

    @Override
    public LockResult previousGt(byte[] limitKey) throws IOException {
        return this.mCursor.previousGt(limitKey);
    }

    @Override
    public LockResult find(byte[] key) throws IOException {
        return this.mCursor.find(key);
    }

    @Override
    public LockResult findGe(byte[] key) throws IOException {
        return this.mCursor.findGe(key);
    }

    @Override
    public LockResult findGt(byte[] key) throws IOException {
        return this.mCursor.findGt(key);
    }

    @Override
    public LockResult findLe(byte[] key) throws IOException {
        return this.mCursor.findLe(key);
    }

    @Override
    public LockResult findLt(byte[] key) throws IOException {
        return this.mCursor.findLt(key);
    }

    @Override
    public LockResult findNearby(byte[] key) throws IOException {
        return this.mCursor.findNearby(key);
    }

    @Override
    public LockResult findNearbyGe(byte[] key) throws IOException {
        return this.mCursor.findNearbyGe(key);
    }

    @Override
    public LockResult findNearbyGt(byte[] key) throws IOException {
        return this.mCursor.findNearbyGe(key);
    }

    @Override
    public LockResult findNearbyLe(byte[] key) throws IOException {
        return this.mCursor.findNearbyLe(key);
    }

    @Override
    public LockResult findNearbyLt(byte[] key) throws IOException {
        return this.mCursor.findNearbyLt(key);
    }

    @Override
    public LockResult random(byte[] lowKey, byte[] highKey) throws IOException {
        return this.mCursor.random(lowKey, highKey);
    }

    @Override
    public LockResult random(byte[] lowKey, boolean lowInclusive, byte[] highKey, boolean highInclusive) throws IOException {
        return this.mCursor.random(lowKey, lowInclusive, highKey, highInclusive);
    }

    @Override
    public boolean exists() throws IOException {
        return this.mCursor.exists();
    }

    @Override
    public LockResult lock() throws IOException {
        return this.mCursor.lock();
    }

    @Override
    public LockResult load() throws IOException {
        return this.mCursor.load();
    }

    @Override
    public void store(byte[] value) throws IOException {
        this.mCursor.store(value);
    }

    @Override
    public void delete() throws IOException {
        this.mCursor.delete();
    }

    @Override
    public void commit(byte[] value) throws IOException {
        this.mCursor.commit(value);
    }

    @Override
    public RemoteCursor copy() {
        return new ServerCursor(this.mCursor.copy());
    }

    @Override
    public void reset() {
        this.mCursor.reset();
    }

    @Override
    public long valueLength() throws IOException {
        return this.mCursor.valueLength();
    }

    @Override
    public void valueLength(long length) throws IOException {
        this.mCursor.valueLength(length);
    }

    @Override
    public Pipe valueRead(long pos, int len, Pipe pipe) {
        try {
            block5: {
                int actual;
                byte[] buf = new byte[len];
                try {
                    actual = this.mCursor.valueRead(pos, buf, 0, len);
                }
                catch (Throwable e) {
                    pipe.writeObject((Object)e);
                    break block5;
                }
                pipe.writeNull();
                pipe.writeInt(actual);
                if (actual > 0) {
                    pipe.write(buf, 0, actual);
                }
            }
            pipe.flush();
            pipe.recycle();
            return null;
        }
        catch (Throwable e) {
            Utils.closeQuietly((Closeable)pipe);
            return null;
        }
    }

    @Override
    public Pipe valueWrite(long pos, int len, Pipe pipe) {
        try {
            block4: {
                byte[] buf = new byte[len];
                pipe.readFully(buf);
                try {
                    this.mCursor.valueWrite(pos, buf, 0, len);
                }
                catch (Throwable e) {
                    pipe.writeObject((Object)e);
                    break block4;
                }
                pipe.writeNull();
            }
            pipe.flush();
            pipe.recycle();
            return null;
        }
        catch (Throwable e) {
            Utils.closeQuietly((Closeable)pipe);
            return null;
        }
    }

    @Override
    public void valueClear(long pos, long length) throws IOException {
        this.mCursor.valueClear(pos, length);
    }

    @Override
    public Pipe valueReadTransfer(long pos, Pipe pipe) {
        try {
            this.readTransfer(pos, 4096, pipe);
            return null;
        }
        catch (Throwable e) {
            Utils.closeQuietly((Closeable)pipe);
            return null;
        }
    }

    @Override
    public Pipe valueReadTransfer(long pos, int bufferSize, Pipe pipe) {
        bufferSize = bufferSize <= 0 ? (bufferSize == 0 ? 1 : 4096) : Math.min(bufferSize, 32766);
        try {
            this.readTransfer(pos, bufferSize, pipe);
            return null;
        }
        catch (Throwable e) {
            Utils.closeQuietly((Closeable)pipe);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readTransfer(long pos, int bufferSize, Pipe pipe) throws IOException {
        c = this.mCursor.copy();
        try {
            try {
                buf = new byte[2 + bufferSize];
                in = c.newValueInputStream(pos, 0);
            }
            catch (Throwable e) {
                pipe.writeShort(65535);
                pipe.writeObject((Object)e);
                if (c != null) {
                    c.close();
                }
            }
        }
        catch (Throwable var6_7) {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Throwable var7_9) {
                    var6_7.addSuppressed(var7_9);
                }
            }
            throw var6_7;
        }
        while (true) {
            try {
                amt = in.readNBytes(buf, 2, bufferSize);
            }
            catch (Throwable e) {
                pipe.writeShort(65535);
                pipe.writeObject((Object)e);
                if (c != null) {
                    c.close();
                }
            }
            break;
        }
        {
            block18: {
                if (amt >= bufferSize) break block18;
                amt = Math.max(amt, 0);
                Utils.encodeShortBE(buf, 0, amt | 32768);
                pipe.write(buf, 0, 2 + amt);
                ** if (c == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    c.close();
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            Utils.encodeShortBE(buf, 0, amt);
            pipe.write(buf, 0, 2 + amt);
            continue;
        }
        pipe.flush();
        ack = pipe.read();
        if (ack < 0) {
            pipe.close();
        } else {
            pipe.recycle();
        }
    }

    @Override
    public Pipe valueWriteTransfer(long pos, Pipe pipe) {
        try {
            this.writeTransfer(pos, pipe);
            return null;
        }
        catch (Throwable e) {
            Utils.closeQuietly((Closeable)pipe);
            return null;
        }
    }

    private void writeTransfer(long pos, Pipe pipe) throws IOException {
        RemoteOutputControl control = (RemoteOutputControl)pipe.readObject();
        try (Cursor c = this.mCursor.copy();){
            OutputStream out = c.newValueOutputStream(pos, 0);
            while (true) {
                int header;
                int length;
                if ((length = (header = pipe.readUnsignedShort()) & Short.MAX_VALUE) != 0) {
                    if (pipe.transferTo(out, (long)length) < (long)length) {
                        throw new EOFException();
                    }
                    if ((header & 0x8000) == 0) continue;
                    break;
                }
                if (header == 32768) break;
                pipe.write(1);
                pipe.flush();
            }
            pipe.write(2);
            pipe.flush();
            pipe.recycle();
        }
        catch (Throwable e) {
            control.exception(e);
            pipe.close();
            return;
        }
        control.dispose();
    }

    @Override
    public boolean equalPositions(RemoteCursor other) {
        try {
            Class<?> clazz = this.mCursor.getClass();
            Method m = clazz.getDeclaredMethod("equalPositions", clazz);
            return (Boolean)m.invoke((Object)this.mCursor, ((ServerCursor)other).mCursor);
        }
        catch (Exception e) {
            throw Utils.rethrow(e);
        }
    }

    @Override
    public boolean verifyExtremities(byte extremity) throws IOException {
        try {
            Method m = this.mCursor.getClass().getDeclaredMethod("verifyExtremities", Byte.TYPE);
            return (Boolean)m.invoke((Object)this.mCursor, extremity);
        }
        catch (Exception e) {
            throw Utils.rethrow(e);
        }
    }
}

