/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.IOException;
import java.util.Map;
import org.cojen.dirmi.Pipe;
import org.cojen.tupl.Database;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.Index;
import org.cojen.tupl.Snapshot;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;
import org.cojen.tupl.diag.DatabaseStats;
import org.cojen.tupl.remote.ClientRunnable;
import org.cojen.tupl.remote.CompactionObserverRelay;
import org.cojen.tupl.remote.RemoteCompactionObserver;
import org.cojen.tupl.remote.RemoteCustomHandler;
import org.cojen.tupl.remote.RemoteDatabase;
import org.cojen.tupl.remote.RemoteDeleteIndex;
import org.cojen.tupl.remote.RemoteIndex;
import org.cojen.tupl.remote.RemoteLeaderNotification;
import org.cojen.tupl.remote.RemotePrepareHandler;
import org.cojen.tupl.remote.RemoteRunnable;
import org.cojen.tupl.remote.RemoteSorter;
import org.cojen.tupl.remote.RemoteTransaction;
import org.cojen.tupl.remote.RemoteVerificationObserver;
import org.cojen.tupl.remote.RemoteView;
import org.cojen.tupl.remote.ServerCustomHandler;
import org.cojen.tupl.remote.ServerDeleteIndex;
import org.cojen.tupl.remote.ServerIndex;
import org.cojen.tupl.remote.ServerPrepareHandler;
import org.cojen.tupl.remote.ServerSnapshot;
import org.cojen.tupl.remote.ServerSorter;
import org.cojen.tupl.remote.ServerTemporaryIndex;
import org.cojen.tupl.remote.ServerTransaction;
import org.cojen.tupl.remote.ServerView;
import org.cojen.tupl.remote.VerificationObserverRelay;

public final class ServerDatabase
implements RemoteDatabase {
    private final Database mDb;

    public static ServerDatabase from(Database db) {
        return new ServerDatabase(db);
    }

    private ServerDatabase(Database db) {
        this.mDb = db;
    }

    @Override
    public RemoteIndex openIndex(byte[] name) throws IOException {
        return new ServerIndex(this.mDb.openIndex(name));
    }

    @Override
    public RemoteIndex findIndex(byte[] name) throws IOException {
        Index ix = this.mDb.findIndex(name);
        return ix == null ? null : new ServerIndex(ix);
    }

    @Override
    public RemoteIndex indexById(long id) throws IOException {
        Index ix = this.mDb.indexById(id);
        return ix == null ? null : new ServerIndex(ix);
    }

    @Override
    public void renameIndex(RemoteIndex index, byte[] newName) throws IOException {
        this.mDb.renameIndex((Index)((ServerIndex)index).mView, newName);
    }

    @Override
    public RemoteDeleteIndex deleteIndex(RemoteIndex remote) throws IOException {
        ServerIndex server = (ServerIndex)remote;
        ServerDeleteIndex del = new ServerDeleteIndex(this.mDb.deleteIndex((Index)server.mView));
        if (server instanceof ServerTemporaryIndex) {
            ServerTemporaryIndex temp = (ServerTemporaryIndex)server;
            temp.deleted();
        }
        return del;
    }

    @Override
    public RemoteIndex newTemporaryIndex() throws IOException {
        return new ServerTemporaryIndex(this.mDb, this.mDb.newTemporaryIndex());
    }

    @Override
    public RemoteView indexRegistryByName() throws IOException {
        return new ServerView<View>(this.mDb.indexRegistryByName());
    }

    @Override
    public RemoteView indexRegistryById() throws IOException {
        return new ServerView<View>(this.mDb.indexRegistryById());
    }

    @Override
    public RemoteTransaction newTransaction() {
        return new ServerTransaction(this.mDb.newTransaction());
    }

    @Override
    public RemoteTransaction newTransaction(DurabilityMode dm) {
        return new ServerTransaction(this.mDb.newTransaction(dm));
    }

    @Override
    public RemoteTransaction bogus() {
        return new ServerTransaction(Transaction.BOGUS);
    }

    @Override
    public RemoteCustomHandler customWriter(String name) throws IOException {
        return new ServerCustomHandler(this.mDb.customWriter(name));
    }

    @Override
    public RemotePrepareHandler prepareWriter(String name) throws IOException {
        return new ServerPrepareHandler(this.mDb.prepareWriter(name));
    }

    @Override
    public RemoteSorter newSorter() {
        return new ServerSorter(this.mDb, this.mDb.newSorter());
    }

    @Override
    public long preallocate(long bytes) throws IOException {
        return this.mDb.preallocate(bytes);
    }

    @Override
    public long capacityLimit() {
        return this.mDb.capacityLimit();
    }

    @Override
    public Map beginSnapshot() throws IOException {
        Snapshot snapshot = this.mDb.beginSnapshot();
        return Map.of("snapshot", new ServerSnapshot(snapshot), "length", snapshot.length(), "position", snapshot.position(), "isCompressible", snapshot.isCompressible());
    }

    @Override
    public Pipe createCachePrimer(Pipe pipe) throws IOException {
        try (Pipe pipe2 = pipe;){
            this.mDb.createCachePrimer(pipe.outputStream());
            pipe.flush();
        }
        return null;
    }

    @Override
    public Pipe applyCachePrimer(Pipe pipe) throws IOException {
        try (Pipe pipe2 = pipe;){
            this.mDb.applyCachePrimer(pipe.inputStream());
        }
        return null;
    }

    @Override
    public DatabaseStats stats() {
        return this.mDb.stats();
    }

    @Override
    public void flush() throws IOException {
        this.mDb.flush();
    }

    @Override
    public void sync() throws IOException {
        this.mDb.sync();
    }

    @Override
    public void checkpoint() throws IOException {
        this.mDb.checkpoint();
    }

    @Override
    public boolean compactFile(int flags, RemoteCompactionObserver remote, double target) throws IOException {
        return CompactionObserverRelay.compactFile(flags, this.mDb, remote, target);
    }

    @Override
    public boolean verify(int flags, RemoteVerificationObserver remote) throws IOException {
        return VerificationObserverRelay.verify(flags, remote, this.mDb::verify);
    }

    @Override
    public boolean isLeader() {
        return this.mDb.isLeader();
    }

    @Override
    public RemoteLeaderNotification uponLeader(RemoteRunnable acquired, RemoteRunnable lost) {
        this.mDb.uponLeader(new ClientRunnable(acquired), new ClientRunnable(lost));
        return new RemoteLeaderNotification(){

            @Override
            public void dispose() {
            }
        };
    }

    @Override
    public boolean failover() throws IOException {
        return this.mDb.failover();
    }

    @Override
    public void close() throws IOException {
        this.mDb.close();
    }

    @Override
    public void close(Throwable cause) throws IOException {
        this.mDb.close(cause);
    }

    @Override
    public boolean isClosed() {
        return this.mDb.isClosed();
    }

    @Override
    public void shutdown() throws IOException {
        this.mDb.shutdown();
    }

    @Override
    public void dispose() {
    }
}

