/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.Session;
import org.cojen.dirmi.SessionAware;
import org.cojen.tupl.Database;
import org.cojen.tupl.Entry;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.Sorter;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.remote.PipeEntryScanner;
import org.cojen.tupl.remote.PipeEntryWriter;
import org.cojen.tupl.remote.RemoteIndex;
import org.cojen.tupl.remote.RemoteSorter;
import org.cojen.tupl.remote.ServerTemporaryIndex;

final class ServerSorter
implements RemoteSorter,
SessionAware {
    private final Database mDb;
    private final Sorter mSorter;

    ServerSorter(Database db, Sorter sorter) {
        this.mDb = db;
        this.mSorter = sorter;
    }

    public void attached(Session<?> session) {
    }

    public void detached(Session<?> session) {
        try {
            this.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void add(byte[] key, byte[] value) throws IOException {
        this.mSorter.add(key, value);
    }

    @Override
    public Pipe addBatch(Pipe pipe) {
        try {
            int size = pipe.readInt();
            byte[][] kvPairs = new byte[size << 1][];
            int i = 0;
            do {
                kvPairs[i++] = (byte[])pipe.readObject();
                kvPairs[i++] = (byte[])pipe.readObject();
            } while (--size > 0);
            Exception ex = null;
            try {
                this.mSorter.addBatch(kvPairs, 0, kvPairs.length >> 1);
            }
            catch (IOException | RuntimeException e) {
                ex = e;
            }
            pipe.writeObject((Object)ex);
            pipe.flush();
            pipe.recycle();
        }
        catch (IOException e) {
            Utils.closeQuietly((Closeable)pipe);
        }
        return null;
    }

    @Override
    public Pipe addAll(Pipe pipe) throws IOException {
        try {
            this.mSorter.addAll(new PipeEntryScanner(pipe, true));
        }
        catch (SocketException | ClosedChannelException | ClosedException throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public RemoteIndex finish() throws IOException {
        return new ServerTemporaryIndex(this.mDb, this.mSorter.finish());
    }

    @Override
    public Pipe finishScan(boolean reverse, Pipe pipe) throws IOException {
        try {
            Scanner<Entry> scanner = reverse ? this.mSorter.finishScanReverse() : this.mSorter.finishScan();
            PipeEntryWriter.writeAll(scanner, pipe, true);
        }
        catch (SocketException | ClosedChannelException | ClosedException throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Pipe addAllFinishScan(boolean reverse, Pipe pipe) throws IOException {
        try {
            PipeEntryScanner srcScanner = new PipeEntryScanner(pipe, false);
            Scanner<Entry> scanner = reverse ? this.mSorter.finishScanReverse(srcScanner) : this.mSorter.finishScan(srcScanner);
            PipeEntryWriter.writeAll(scanner, pipe, true);
        }
        catch (SocketException | ClosedChannelException | ClosedException throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public long progress() {
        return this.mSorter.progress();
    }

    @Override
    public void reset() throws IOException {
        this.mSorter.reset();
    }
}

