/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import org.cojen.dirmi.Pipe;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.Updater;
import org.cojen.tupl.diag.QueryPlan;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.remote.RemoteTable;
import org.cojen.tupl.remote.RemoteTableProxy;
import org.cojen.tupl.remote.RemoteTransaction;
import org.cojen.tupl.remote.ServerTransaction;
import org.cojen.tupl.remote.ServerUpdater;
import org.cojen.tupl.rows.BaseTable;
import org.cojen.tupl.rows.WeakCache;

final class ServerTable<R>
implements RemoteTable {
    final BaseTable<R> mTable;
    private final WeakCache<byte[], RemoteTableProxy, Object> mProxyCache;

    ServerTable(BaseTable<R> table) throws IOException {
        this.mTable = table;
        this.mProxyCache = new WeakCache<byte[], RemoteTableProxy, Object>(){

            @Override
            protected RemoteTableProxy newValue(byte[] descriptor, Object unused) {
                try {
                    return ServerTable.this.mTable.newRemoteProxy(descriptor);
                }
                catch (IOException e) {
                    throw Utils.rethrow(e);
                }
            }
        };
    }

    @Override
    public Pipe newScanner(RemoteTransaction txn, Pipe pipe) throws IOException {
        try {
            this.mTable.scanWrite(ServerTransaction.txn(txn), (DataOutput)pipe);
            pipe.flush();
            pipe.recycle();
            return null;
        }
        catch (Throwable e) {
            Utils.closeQuietly((Closeable)pipe);
            if (!(e instanceof IOException)) {
                throw e;
            }
            return null;
        }
    }

    @Override
    public Pipe newScanner(RemoteTransaction txn, Pipe pipe, String query, Object ... args) throws IOException {
        try {
            this.mTable.scanWrite(ServerTransaction.txn(txn), (DataOutput)pipe, query, args);
            pipe.flush();
            pipe.recycle();
            return null;
        }
        catch (Throwable e) {
            Utils.closeQuietly((Closeable)pipe);
            if (!(e instanceof IOException)) {
                throw e;
            }
            return null;
        }
    }

    @Override
    public Pipe newUpdater(RemoteTransaction txn, Pipe pipe) throws IOException {
        this.newUpdater(this.mTable.newUpdater(ServerTransaction.txn(txn)), pipe);
        return null;
    }

    @Override
    public Pipe newUpdater(RemoteTransaction txn, Pipe pipe, String query, Object ... args) throws IOException {
        this.newUpdater(this.mTable.newUpdater(ServerTransaction.txn(txn), query, args), pipe);
        return null;
    }

    private void newUpdater(Updater updater, Pipe pipe) throws IOException {
        block5: {
            try {
                RemoteTableProxy proxy = (RemoteTableProxy)pipe.readObject();
                int characteristics = updater.characteristics();
                pipe.writeInt(characteristics);
                if ((characteristics & 0x40) != 0) {
                    pipe.writeLong(updater.estimateSize());
                }
                if (updater.row() == null) {
                    pipe.writeNull();
                    pipe.flush();
                    pipe.recycle();
                } else {
                    ServerUpdater server = new ServerUpdater(updater);
                    pipe.writeObject((Object)server);
                    proxy.row(server, pipe);
                }
            }
            catch (Throwable e) {
                Utils.closeQuietly((Closeable)pipe);
                Utils.closeQuietly(updater);
                if (e instanceof IOException) break block5;
                throw e;
            }
        }
    }

    @Override
    public RemoteTransaction newTransaction(DurabilityMode dm) {
        return new ServerTransaction(this.mTable.newTransaction(dm));
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.mTable.isEmpty();
    }

    @Override
    public RemoteTableProxy proxy(byte[] descriptor) throws IOException {
        return (RemoteTableProxy)this.mProxyCache.obtain((Object)descriptor, null);
    }

    @Override
    public QueryPlan scannerPlan(RemoteTransaction txn, String query, Object ... args) throws IOException {
        return this.mTable.scannerPlan(ServerTransaction.txn(txn), query, args);
    }

    @Override
    public QueryPlan updaterPlan(RemoteTransaction txn, String query, Object ... args) throws IOException {
        return this.mTable.updaterPlan(ServerTransaction.txn(txn), query, args);
    }

    @Override
    public QueryPlan streamPlan(RemoteTransaction txn, String query, Object ... args) throws IOException {
        return this.mTable.streamPlan(ServerTransaction.txn(txn), query, args);
    }

    @Override
    public void close() throws IOException {
        this.mTable.close();
    }

    @Override
    public boolean isClosed() {
        return this.mTable.isClosed();
    }

    @Override
    public void dispose() {
    }
}

