/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import org.cojen.dirmi.Pipe;
import org.cojen.tupl.Database;
import org.cojen.tupl.Index;
import org.cojen.tupl.diag.VerificationObserver;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.remote.RemoteVerificationObserver;
import org.cojen.tupl.util.Runner;

final class ServerVerificationObserver
implements RemoteVerificationObserver {
    private final int mFlags;
    private final Database mDb;
    private final VerificationObserver mObserver;
    private boolean mExpectTerminators;
    private boolean mTerminated;
    private Throwable mException;

    static ServerVerificationObserver make(Database db, VerificationObserver observer) {
        int flags;
        if (observer == null) {
            flags = 0;
            observer = new VerificationObserver();
        } else {
            flags = 1;
            try {
                Method method = observer.getClass().getMethod("indexNodePassed", Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                if (method.getDeclaringClass() == VerificationObserver.class) {
                    flags = 0;
                }
            }
            catch (Exception e) {
                throw Utils.rethrow(e);
            }
        }
        return new ServerVerificationObserver(flags, db, observer);
    }

    private ServerVerificationObserver(int flags, Database db, VerificationObserver observer) {
        this.mFlags = flags;
        this.mDb = db;
        this.mObserver = observer;
    }

    int flags() {
        return this.mFlags;
    }

    synchronized boolean check(boolean result) {
        Throwable ex = this.mException;
        if (ex != null) {
            throw Utils.rethrow(ex);
        }
        return result;
    }

    @Override
    public synchronized boolean indexBegin(long indexId, int height) {
        return this.mObserver.indexBegin(this.indexFor(indexId), height);
    }

    @Override
    public synchronized boolean indexComplete(long indexId, boolean passed, String message) {
        if (this.mExpectTerminators) {
            try {
                while (!this.mTerminated) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mTerminated = false;
        }
        return this.mObserver.indexComplete(this.indexFor(indexId), passed, message);
    }

    @Override
    public Pipe indexNodePassed(Pipe pipe) {
        Runner.start(() -> this.readIndexNodePassed(pipe));
        return null;
    }

    @Override
    public synchronized boolean indexNodeFailed(long id, int level, String message) {
        return this.mObserver.indexNodeFailed(id, level, message);
    }

    @Override
    public void finished() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIndexNodePassed(Pipe pipe) {
        ServerVerificationObserver serverVerificationObserver = this;
        synchronized (serverVerificationObserver) {
            this.mExpectTerminators = true;
        }
        try {
            pipe.read();
            pipe.write(1);
            pipe.flush();
            VerificationObserver observer = this.mObserver;
            while (true) {
                boolean keepGoing;
                long id;
                if ((id = pipe.readLong()) == 0L) {
                    ServerVerificationObserver serverVerificationObserver2 = this;
                    synchronized (serverVerificationObserver2) {
                        this.mTerminated = true;
                        this.notify();
                    }
                }
                int level = pipe.readInt();
                int entryCount = pipe.readInt();
                int freeBytes = pipe.readInt();
                int largeValueCount = pipe.readInt();
                ServerVerificationObserver serverVerificationObserver3 = this;
                synchronized (serverVerificationObserver3) {
                    try {
                        keepGoing = observer.indexNodePassed(id, level, entryCount, freeBytes, largeValueCount);
                    }
                    catch (Throwable e) {
                        this.mException = e;
                        break;
                    }
                }
                if (!keepGoing) break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Utils.closeQuietly((Closeable)pipe);
    }

    private Index indexFor(long indexId) {
        try {
            return this.mDb.indexById(indexId);
        }
        catch (IOException | IllegalArgumentException e) {
            return null;
        }
    }
}

