/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.cojen.dirmi.Pipe;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.remote.ClientCursor;

final class ValueInputStream
extends InputStream {
    private final ClientCursor mCursor;
    private final Pipe mPipe;
    private int mChunkSize;
    private byte[] mChunkBuffer;
    private int mChunkPos;
    private int mChunkEnd;
    private Throwable mException;

    ValueInputStream(ClientCursor cursor, Pipe pipe) throws IOException {
        this.mCursor = cursor;
        this.mPipe = pipe;
        pipe.flush();
    }

    @Override
    public int read() throws IOException {
        int pos = this.mChunkPos;
        int avail = this.mChunkEnd - pos;
        if (avail <= 0) {
            avail = this.readChunk();
            if (avail <= 0) {
                return -1;
            }
            pos = 0;
        }
        int b = this.mChunkBuffer[pos++] & 0xFF;
        this.mChunkPos = pos;
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int pos = this.mChunkPos;
        int avail = this.mChunkEnd - pos;
        if (avail <= 0) {
            avail = this.readChunk();
            if (avail <= 0) {
                return -1;
            }
            pos = 0;
        }
        len = Math.min(avail, len);
        System.arraycopy(this.mChunkBuffer, pos, b, off, len);
        this.mChunkPos += len;
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        int avail = this.available();
        if (avail <= 0 && (avail = this.readChunk()) <= 0) {
            return 0L;
        }
        if (n >= (long)avail) {
            this.mChunkPos = this.mChunkEnd;
            return avail;
        }
        this.mChunkPos += (int)n;
        return n;
    }

    @Override
    public int available() {
        return this.mChunkEnd - this.mChunkPos;
    }

    @Override
    public void close() throws IOException {
        int size = this.mChunkSize;
        if (size != -1) {
            this.mChunkSize = -1;
            this.mChunkBuffer = null;
            this.mChunkPos = this.mChunkEnd;
            this.mCursor.reset();
            if ((size & 0x8000) == 0) {
                this.mPipe.close();
            }
        }
    }

    private int readChunk() throws IOException {
        int size = this.mChunkSize;
        if ((size & 0x8000) != 0) {
            if (size == -1) {
                throw new IllegalStateException("Stream closed");
            }
            Throwable ex = this.mException;
            if (ex != null) {
                Utils.rethrow(ex);
            }
            return -1;
        }
        try {
            this.mChunkSize = size = this.mPipe.readUnsignedShort();
        }
        catch (Throwable e) {
            this.failed();
            throw e;
        }
        if (size >= 65535) {
            Throwable ex;
            try {
                ex = (Throwable)this.mPipe.readThrowable();
            }
            catch (Throwable e) {
                this.failed();
                throw e;
            }
            this.mException = ex;
            this.finished();
            throw Utils.rethrow(ex);
        }
        int avail = size & Short.MAX_VALUE;
        byte[] buf = this.mChunkBuffer;
        if (buf == null || buf.length < avail) {
            this.mChunkBuffer = buf = new byte[avail];
        }
        try {
            this.mPipe.readFully(buf, 0, avail);
        }
        catch (Throwable e) {
            this.failed();
            throw e;
        }
        this.mChunkPos = 0;
        this.mChunkEnd = avail;
        if ((size & 0x8000) != 0) {
            this.finished();
        }
        return avail;
    }

    private void failed() {
        this.mChunkSize = 65535;
        Utils.closeQuietly((Closeable)this.mPipe);
    }

    private void finished() {
        Pipe pipe = this.mPipe;
        try {
            pipe.write(1);
            pipe.flush();
            pipe.recycle();
        }
        catch (Throwable e) {
            Utils.closeQuietly((Closeable)pipe);
        }
    }
}

