/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.cojen.dirmi.Pipe;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.remote.ClientCursor;
import org.cojen.tupl.remote.RemoteOutputControl;

final class ValueOutputStream
extends OutputStream
implements RemoteOutputControl {
    private final ClientCursor mCursor;
    private Pipe mPipe;
    private final byte[] mChunkBuffer;
    private int mChunkEnd;
    private volatile Throwable mException;

    ValueOutputStream(ClientCursor cursor, Pipe pipe, int bufferSize) throws IOException {
        this.mCursor = cursor;
        this.mPipe = pipe;
        bufferSize = bufferSize <= 0 ? (bufferSize == 0 ? 1 : 4096) : Math.min(bufferSize, 32766);
        this.mChunkBuffer = new byte[2 + bufferSize];
        this.mChunkEnd = 2;
        pipe.writeObject((Object)this);
        pipe.flush();
    }

    @Override
    public void write(int b) throws IOException {
        Pipe pipe = this.checkClosed();
        int end = this.mChunkEnd;
        byte[] buf = this.mChunkBuffer;
        if (end >= buf.length) {
            this.flushNoAck(pipe, end);
            end = 2;
        }
        buf[end++] = (byte)b;
        if (end < buf.length) {
            this.mChunkEnd = end;
        } else {
            this.flushNoAck(pipe, end);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Pipe pipe = this.checkClosed();
        byte[] buf = this.mChunkBuffer;
        if (len > 0) {
            int end = this.mChunkEnd;
            while (true) {
                int avail;
                if (len <= (avail = buf.length - end)) {
                    System.arraycopy(b, off, buf, end, len);
                    end += len;
                    if (len < avail) {
                        this.mChunkEnd = end;
                    } else {
                        this.flushNoAck(pipe, end);
                    }
                    return;
                }
                System.arraycopy(b, off, buf, end, avail);
                off += avail;
                len -= avail;
                this.flushNoAck(pipe, buf.length);
                end = 2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void flush() throws IOException {
        pipe = this.checkClosed();
        buf = this.mChunkBuffer;
        end = this.mChunkEnd;
        try {
            if (end <= 2) ** GOTO lbl14
            Utils.encodeShortBE(buf, 0, end - 2);
            if (end <= buf.length - 2) {
                Utils.encodeShortBE(buf, end, 0);
                pipe.write(buf, 0, end + 2);
                this.mChunkEnd = 2;
            } else {
                pipe.write(buf, 0, end);
                this.mChunkEnd = 2;
lbl14:
                // 2 sources

                pipe.writeShort(0);
            }
            pipe.flush();
            pipe.read();
        }
        catch (Throwable e) {
            this.failed();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Pipe pipe = this.mPipe;
        if (pipe == null) {
            return;
        }
        try {
            int ack;
            try {
                byte[] buf = this.mChunkBuffer;
                int end = this.mChunkEnd;
                Utils.encodeShortBE(buf, 0, end - 2 | 0x8000);
                pipe.write(buf, 0, end);
                pipe.flush();
                this.mChunkEnd = 2;
            }
            catch (Throwable e) {
                this.failed();
                throw e;
            }
            finally {
                this.mPipe = null;
            }
            Throwable ex = this.mException;
            if (ex != null) {
                Utils.closeQuietly((Closeable)pipe);
                this.mException = null;
                throw Utils.rethrow(ex);
            }
            try {
                ack = pipe.read();
            }
            catch (Throwable e) {
                Utils.closeQuietly((Closeable)pipe);
                throw e;
            }
            if (ack < 0) {
                pipe.close();
            } else {
                pipe.recycle();
            }
        }
        finally {
            this.mCursor.reset();
        }
    }

    @Override
    public void exception(Throwable e) {
        this.mException = e;
    }

    @Override
    public void dispose() {
    }

    private void flushNoAck(Pipe pipe, int end) throws IOException {
        if (end <= 2) {
            throw new AssertionError();
        }
        try {
            byte[] buf = this.mChunkBuffer;
            Utils.encodeShortBE(buf, 0, end - 2);
            pipe.write(buf, 0, end);
            this.mChunkEnd = 2;
            pipe.flush();
        }
        catch (Throwable e) {
            this.failed();
            throw e;
        }
    }

    private Pipe checkClosed() {
        Pipe pipe = this.mPipe;
        if (pipe == null) {
            throw new IllegalStateException("Stream closed");
        }
        return pipe;
    }

    private void failed() {
        Utils.closeQuietly((Closeable)this.mPipe);
        this.mChunkEnd = this.mChunkBuffer.length;
        Throwable ex = this.mException;
        if (ex != null) {
            throw Utils.rethrow(ex);
        }
    }
}

