/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.remote;

import java.io.IOException;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.RemoteException;
import org.cojen.tupl.Index;
import org.cojen.tupl.diag.VerificationObserver;
import org.cojen.tupl.remote.ObserverCallback;
import org.cojen.tupl.remote.RemoteVerificationObserver;

final class VerificationObserverRelay
extends VerificationObserver {
    private final boolean mPassMessages;
    private final RemoteVerificationObserver mRemote;
    private Pipe mPipe;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verify(int flags, RemoteVerificationObserver remote, ObserverCallback<VerificationObserver, IOException> upon) throws IOException {
        if (remote == null) {
            return upon.run(new VerificationObserver(){

                @Override
                public boolean indexNodeFailed(long id, int level, String message) {
                    return false;
                }
            });
        }
        VerificationObserverRelay relay = new VerificationObserverRelay(flags, remote);
        try {
            boolean bl = upon.run(relay);
            return bl;
        }
        finally {
            relay.finished();
        }
    }

    private VerificationObserverRelay(int flags, RemoteVerificationObserver remote) {
        this.mPassMessages = (flags & 1) != 0;
        this.mRemote = remote;
    }

    private void finished() {
        try {
            try {
                if (this.mPipe != null) {
                    this.mPipe.flush();
                    this.mPipe.close();
                    this.mPipe = null;
                }
            }
            finally {
                this.mRemote.finished();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean indexBegin(Index index, int height) {
        try {
            return this.mRemote.indexBegin(index.id(), height);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean indexComplete(Index index, boolean passed, String message) {
        if (this.mPipe != null) {
            try {
                this.mPipe.writeLong(0L);
                this.mPipe.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            return this.mRemote.indexComplete(index.id(), passed, message);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean indexNodePassed(long id, int level, int entryCount, int freeBytes, int largeValueCount) {
        if (!this.mPassMessages) {
            return true;
        }
        try {
            Pipe pipe = this.mPipe;
            if (pipe == null) {
                this.mPipe = pipe = this.mRemote.indexNodePassed(null);
                pipe.write(1);
                pipe.flush();
                if (pipe.read() < 0) {
                    return false;
                }
            }
            pipe.writeLong(id);
            pipe.writeInt(level);
            pipe.writeInt(entryCount);
            pipe.writeInt(freeBytes);
            pipe.writeInt(largeValueCount);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean indexNodeFailed(long id, int level, String message) {
        try {
            return this.mRemote.indexNodeFailed(id, level, message);
        }
        catch (RemoteException e) {
            return false;
        }
    }
}

