/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32C;
import org.cojen.tupl.io.Utils;

final class ChannelInputStream
extends InputStream {
    private final InputStream mSource;
    private final CRC32C mCRC;
    byte[] mBuffer;
    int mPos;
    private int mEnd;
    private int mChecksumLength;
    private int mChecksumValue;

    ChannelInputStream(InputStream source, int size, boolean checkCRCs) {
        this.mSource = source;
        this.mBuffer = new byte[size];
        this.mCRC = checkCRCs ? new CRC32C() : null;
    }

    void prepareChecksum(int length, int value) throws IOException {
        CRC32C crc = this.mCRC;
        if (crc != null) {
            crc.reset();
            int avail = Math.min(length, this.mEnd - this.mPos);
            crc.update(this.mBuffer, this.mPos, avail);
            this.mChecksumLength = length -= avail;
            this.mChecksumValue = value;
            if (length <= 0 && value != (int)crc.getValue()) {
                throw this.checksumMismatch();
            }
        }
    }

    byte readByte() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (byte)b;
    }

    int readIntLE() throws IOException {
        this.fillBuffer(4);
        int pos = this.mPos;
        int value = Utils.decodeIntLE(this.mBuffer, pos);
        this.mPos = pos + 4;
        return value;
    }

    long readLongLE() throws IOException {
        this.fillBuffer(8);
        int pos = this.mPos;
        long value = Utils.decodeLongLE(this.mBuffer, pos);
        this.mPos = pos + 8;
        return value;
    }

    String readStr(int len) throws IOException {
        if (len <= this.mBuffer.length) {
            this.fillBuffer(len);
            String str = new String(this.mBuffer, this.mPos, len, StandardCharsets.UTF_8);
            this.mPos += len;
            return str;
        }
        byte[] b = new byte[len];
        this.readFully(b, 0, b.length);
        return new String(b, StandardCharsets.UTF_8);
    }

    void readFully(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int amt = this.read(b, off, len);
            if (amt <= 0) {
                throw new EOFException();
            }
            off += amt;
            len -= amt;
        }
    }

    void readFully(int length) throws IOException {
        if (this.mBuffer.length < length) {
            byte[] newBuffer = new byte[Math.max(length, (int)((double)this.mBuffer.length * 1.5))];
            int avail = this.mEnd - this.mPos;
            System.arraycopy(this.mBuffer, this.mPos, newBuffer, 0, avail);
            this.mBuffer = newBuffer;
            this.mPos = 0;
            this.mEnd = avail;
        }
        this.fillBuffer(length);
    }

    void skipFully(long n) throws IOException {
        while (n > 0L) {
            long amt = this.skip(n);
            if (amt <= 0L) {
                throw new EOFException();
            }
            n -= amt;
        }
    }

    @Override
    public int read() throws IOException {
        int pos = this.mPos;
        int avail = this.mEnd - pos;
        byte[] buf = this.mBuffer;
        if (avail <= 0) {
            avail = this.doRead(buf, 0, buf.length);
            if (avail <= 0) {
                return -1;
            }
            pos = 0;
            this.mEnd = avail;
        }
        int b = buf[pos++] & 0xFF;
        this.mPos = pos;
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int avail = this.mEnd - this.mPos;
        byte[] buf = this.mBuffer;
        if (avail <= 0) {
            if (len >= buf.length) {
                return this.doRead(b, off, len);
            }
            avail = this.doRead(buf, 0, buf.length);
            if (avail <= 0) {
                return -1;
            }
            this.mPos = 0;
            this.mEnd = avail;
        }
        len = Math.min(avail, len);
        System.arraycopy(buf, this.mPos, b, off, len);
        this.mPos += len;
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        this.mChecksumLength = 0;
        int avail = this.mEnd - this.mPos;
        if (avail > 0) {
            if (n >= (long)avail) {
                this.mPos = 0;
                this.mEnd = 0;
                return avail;
            }
            this.mPos = (int)((long)this.mPos + n);
            return n;
        }
        return this.mSource.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.mEnd - this.mPos + this.mSource.available();
    }

    @Override
    public void close() throws IOException {
        this.mPos = 0;
        this.mEnd = 0;
        this.mSource.close();
    }

    public void drainTo(OutputStream out) throws IOException {
        int amt;
        byte[] buf = this.mBuffer;
        int avail = this.mEnd - this.mPos;
        if (avail > 0) {
            out.write(buf, this.mPos, avail);
            this.mPos = 0;
            this.mEnd = 0;
        }
        while ((amt = this.doRead(buf, 0, buf.length)) > 0) {
            out.write(buf, 0, amt);
        }
    }

    private void fillBuffer(int required) throws IOException {
        int avail = this.mEnd - this.mPos;
        if ((required -= avail) > 0) {
            this.fillBuffer(required, avail);
        }
    }

    private void fillBuffer(int required, int avail) throws IOException {
        byte[] buf = this.mBuffer;
        int end = this.mEnd;
        int tail = buf.length - end;
        if (tail < required) {
            System.arraycopy(buf, this.mPos, buf, 0, avail);
            this.mPos = 0;
            this.mEnd = end = avail;
            tail = buf.length - end;
        }
        while (true) {
            if ((avail = this.doRead(buf, end, tail)) <= 0) {
                throw new EOFException();
            }
            this.mEnd = end += avail;
            if ((required -= avail) <= 0) break;
            tail -= avail;
        }
    }

    private int doRead(byte[] buf, int offset, int length) throws IOException {
        int amt = this.mSource.read(buf, offset, length);
        if (amt > 0 && this.mChecksumLength > 0) {
            int avail = Math.min(this.mChecksumLength, amt);
            CRC32C crc = this.mCRC;
            crc.update(buf, offset, avail);
            if ((this.mChecksumLength -= avail) <= 0 && this.mChecksumValue != (int)crc.getValue()) {
                throw this.checksumMismatch();
            }
        }
        return amt;
    }

    private IOException checksumMismatch() {
        Utils.closeQuietly(this);
        return new IOException("Checksum mismatch");
    }
}

