/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import javax.net.SocketFactory;
import org.cojen.tupl.core.Delayed;
import org.cojen.tupl.core.Scheduler;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.repl.Channel;
import org.cojen.tupl.repl.ChannelInputStream;
import org.cojen.tupl.repl.ChannelManager;
import org.cojen.tupl.repl.CommitConflictException;
import org.cojen.tupl.repl.EncodingOutputStream;
import org.cojen.tupl.repl.ErrorCodes;
import org.cojen.tupl.repl.GroupFile;
import org.cojen.tupl.repl.GroupJoiner;
import org.cojen.tupl.repl.InvalidReadException;
import org.cojen.tupl.repl.JoinException;
import org.cojen.tupl.repl.LogInfo;
import org.cojen.tupl.repl.LogReader;
import org.cojen.tupl.repl.LogWriter;
import org.cojen.tupl.repl.Peer;
import org.cojen.tupl.repl.PositionRange;
import org.cojen.tupl.repl.RangeSet;
import org.cojen.tupl.repl.Role;
import org.cojen.tupl.repl.SnapshotReceiver;
import org.cojen.tupl.repl.SnapshotScore;
import org.cojen.tupl.repl.SnapshotSender;
import org.cojen.tupl.repl.SocketSnapshotReceiver;
import org.cojen.tupl.repl.SocketSnapshotSender;
import org.cojen.tupl.repl.StateLog;
import org.cojen.tupl.repl.StreamReplicator;
import org.cojen.tupl.repl.TermLog;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.LatchCondition;

final class Controller
extends Latch
implements StreamReplicator,
Channel {
    private static final int MODE_FOLLOWER = 0;
    private static final int MODE_CANDIDATE = 1;
    private static final int MODE_LEADER = 2;
    private static final int ELECTION_DELAY_LOW_MILLIS = 200;
    private static final int ELECTION_DELAY_HIGH_MILLIS = 300;
    private static final int QUERY_TERMS_RATE_MILLIS = 1;
    private static final int MISSING_DELAY_LOW_MILLIS = 400;
    private static final int MISSING_DELAY_HIGH_MILLIS = 600;
    private static final int SYNC_COMMIT_RETRY_MILLIS = 100;
    private static final int CONNECT_TIMEOUT_MILLIS = 500;
    private static final int SNAPSHOT_REPLY_TIMEOUT_MILLIS = 5000;
    private static final int JOIN_TIMEOUT_MILLIS = 5000;
    private static final int SYNC_RATE_LOW_MILLIS = 2000;
    private static final int SYNC_RATE_HIGH_MILLIS = 3000;
    private static final int COMMIT_CONFLICT_REPORT_MILLIS = 60000;
    private static final int CONNECTING_THRESHOLD_MILLIS = 10000;
    private static final int LAG_TIMEOUT_MILLIS = 1000;
    private static final int LOCAL_LEADER_VALIDATED = 40;
    private static final int FAILOVER_STALL = 10;
    private static final byte CONTROL_OP_JOIN = 1;
    private static final byte CONTROL_OP_UPDATE_ROLE = 2;
    private static final byte CONTROL_OP_UNJOIN = 3;
    private static final byte[] EMPTY_DATA = new byte[0];
    private final EventListener mEventListener;
    private final Scheduler mScheduler;
    private final ChannelManager mChanMan;
    private final StateLog mStateLog;
    private final LatchCondition mSyncCommitCondition;
    private final boolean mProxyWrites;
    private GroupFile mGroupFile;
    private Role mDesiredRole;
    private Peer[] mConsensusPeers;
    private Channel[] mCandidateChannels;
    private Channel[] mProxyChannels;
    private Channel[] mAllChannels;
    private Channel mLeaderReplyChannel;
    private Channel mLeaderRequestChannel;
    private volatile int mLocalMode;
    private long mCurrentTerm;
    private int mGrantsRemaining;
    private int mElectionValidated;
    private long mValidatedTerm;
    private long mLeaderCommitPosition;
    private LogWriter mLeaderLogWriter;
    private ReplWriter mLeaderReplWriter;
    private long mMissingContigPosition = Long.MAX_VALUE;
    private boolean mSkipMissingDataTask;
    private volatile boolean mReceivingMissingData;
    private volatile long mNextQueryTermTime = Long.MIN_VALUE;
    private volatile Consumer<byte[]> mControlMessageAcceptor;
    private volatile Set<byte[]> mRegisteredControlMessages;
    private int mSnapshotSessionCount;
    private volatile long mLastConflictReport = Long.MIN_VALUE;
    private boolean mRemovingStaleMembers;
    private int mCandidateStall;

    static Controller open(EventListener eventListener, StateLog log, long groupToken1, long groupToken2, File groupFile, SocketFactory factory, SocketAddress localAddress, SocketAddress listenAddress, Role localRole, Set<SocketAddress> seeds, ServerSocket localSocket, boolean proxyWrites, boolean writeCRCs) throws IOException {
        boolean canCreate = seeds.isEmpty() && localRole == Role.NORMAL;
        GroupFile gf = GroupFile.open(eventListener, groupFile, localAddress, canCreate);
        if (gf == null && seeds.isEmpty()) {
            throw new JoinException("Not a member of the group and no seeds are provided. Local role must be " + Role.NORMAL + " to create the group, but configured role is: " + localRole);
        }
        Controller con = new Controller(eventListener, log, groupToken1, groupToken2, gf, factory, proxyWrites, writeCRCs);
        try {
            con.init(groupFile, localAddress, listenAddress, localRole, seeds, localSocket);
        }
        catch (Throwable e) {
            Utils.closeQuietly(localSocket);
            Utils.closeQuietly(con);
            throw e;
        }
        return con;
    }

    private Controller(EventListener eventListener, StateLog log, long groupToken1, long groupToken2, GroupFile gf, SocketFactory factory, boolean proxyWrites, boolean writeCRCs) {
        this.mEventListener = eventListener;
        this.mStateLog = log;
        this.mScheduler = new Scheduler();
        this.mChanMan = new ChannelManager(factory, this.mScheduler, groupToken1, groupToken2, gf == null ? 0L : gf.groupId(), writeCRCs, this::uncaught);
        this.mGroupFile = gf;
        this.mSyncCommitCondition = new LatchCondition();
        this.mProxyWrites = proxyWrites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(File groupFile, SocketAddress localAddress, SocketAddress listenAddress, Role localRole, Set<SocketAddress> seeds, ServerSocket localSocket) throws IOException {
        this.acquireExclusive();
        try {
            long localMemberId;
            this.mDesiredRole = localRole;
            if (this.mGroupFile == null) {
                int trials = 2;
                while (--trials >= 0) {
                    try {
                        GroupJoiner joiner = new GroupJoiner(this.mEventListener, groupFile, this.mChanMan.groupToken1(), this.mChanMan.groupToken2(), localAddress, listenAddress);
                        joiner.join(seeds, 5000);
                        this.mGroupFile = joiner.mGroupFile;
                        this.mChanMan.setGroupId(this.mGroupFile.groupId());
                        break;
                    }
                    catch (JoinException e) {
                        if (trials > 0) continue;
                        throw e;
                    }
                }
            }
            if ((localMemberId = this.mGroupFile.localMemberId()) == 0L) {
                throw new JoinException("Not in the replication group. Local address \"" + this.mGroupFile.localMemberAddress() + "\" wasn't found in " + groupFile.getPath());
            }
            this.mChanMan.setLocalMemberId(localMemberId, localSocket);
            this.refreshPeerSet();
        }
        finally {
            this.releaseExclusive();
        }
    }

    private void refreshPeerSet() {
        HashMap<Long, Channel> oldPeerChannels = new HashMap<Long, Channel>();
        if (this.mAllChannels != null) {
            for (Channel channel : this.mAllChannels) {
                oldPeerChannels.put(channel.peer().mMemberId, channel);
            }
        }
        HashMap<Long, Channel> newPeerChannels = new HashMap<Long, Channel>();
        for (Peer peer : this.mGroupFile.allPeers()) {
            Long memberId = peer.mMemberId;
            newPeerChannels.put(memberId, (Channel)oldPeerChannels.remove(memberId));
        }
        Iterator<Peer> iterator = oldPeerChannels.keySet().iterator();
        while (iterator.hasNext()) {
            long toRemove = (Long)((Object)iterator.next());
            this.mChanMan.disconnect(toRemove);
        }
        ArrayList<Peer> consensusPeers = new ArrayList<Peer>();
        ArrayList<Channel> candidateChannels = new ArrayList<Channel>();
        ArrayList<Channel> proxyChannels = new ArrayList<Channel>();
        ArrayList<Channel> allChannels = new ArrayList<Channel>();
        for (Peer peer : this.mGroupFile.allPeers()) {
            Role role;
            Channel channel = (Channel)newPeerChannels.get(peer.mMemberId);
            if (channel == null) {
                channel = this.mChanMan.connect(peer, this);
            }
            if ((role = peer.role()).providesConsensus()) {
                consensusPeers.add(peer);
            }
            if (role.isCandidate()) {
                candidateChannels.add(channel);
            }
            if (role.canProxy()) {
                proxyChannels.add(channel);
            }
            allChannels.add(channel);
        }
        this.mConsensusPeers = consensusPeers.toArray(new Peer[consensusPeers.size()]);
        Channel[][] arrays = Controller.toArrays(candidateChannels, proxyChannels, allChannels);
        this.mCandidateChannels = arrays[0];
        this.mProxyChannels = arrays[1];
        this.mAllChannels = arrays[2];
        if (this.mLeaderReplWriter != null) {
            this.mLeaderReplWriter.update(this.mLeaderLogWriter, this.mAllChannels, candidateChannels.isEmpty(), this.mProxyWrites ? this.mProxyChannels : null);
        }
        if (this.mLocalMode != 0 && this.localMemberRole() != Role.NORMAL) {
            this.toFollower("local role changed");
        }
        this.mSyncCommitCondition.signalAll(this);
    }

    private static Channel[][] toArrays(List<Channel> ... lists) {
        Channel[][] arrays = new Channel[lists.length][];
        block0: for (int i = 0; i < lists.length; ++i) {
            List<Channel> list = lists[i];
            for (int j = 0; j < i; ++j) {
                if (!list.equals(lists[j])) continue;
                arrays[i] = arrays[j];
                continue block0;
            }
            arrays[i] = list.toArray(new Channel[list.size()]);
        }
        return arrays;
    }

    void keepServerSocket() {
        this.mChanMan.keepServerSocket();
    }

    @Override
    public long encoding() {
        return 7944834171105125288L;
    }

    @Override
    public void start() throws IOException {
        this.start(null);
    }

    @Override
    public SnapshotReceiver restore(Map<String, String> options) throws IOException {
        if (this.mChanMan.isStarted()) {
            throw new IllegalStateException("Already started");
        }
        SnapshotReceiver receiver = this.requestSnapshot((Map)options);
        if (receiver != null) {
            try {
                this.start((SocketSnapshotReceiver)receiver);
            }
            catch (Throwable e) {
                Utils.closeQuietly(receiver);
                throw e;
            }
        }
        return receiver;
    }

    private void start(SocketSnapshotReceiver receiver) throws IOException {
        if (!this.mChanMan.isStarted()) {
            if (receiver != null) {
                this.mStateLog.truncateAll(receiver.prevTerm(), receiver.term(), receiver.position());
            }
            this.mChanMan.start(this);
            this.scheduleElectionTask();
            this.scheduleMissingDataTask();
            this.scheduleSyncTask();
            this.mChanMan.joinAcceptor(this::requestJoin);
            this.acquireExclusive();
            if (this.mCandidateChannels.length == 0) {
                this.forceElection();
            } else {
                this.mElectionValidated = 1;
                this.releaseExclusive();
            }
        }
        if (receiver == null) {
            this.acquireShared();
            Role desiredRole = this.desiredRole();
            this.releaseShared();
            if (desiredRole != null) {
                this.mScheduler.execute(this::roleChangeTask);
            }
        }
    }

    private Role desiredRole() {
        if (this.mDesiredRole != null) {
            if (this.localMemberRole() != this.mDesiredRole) {
                return this.mDesiredRole;
            }
            this.mDesiredRole = null;
        }
        return null;
    }

    private void roleChangeTask() {
        this.acquireShared();
        Role desiredRole = this.desiredRole();
        if (desiredRole == null) {
            this.releaseShared();
            return;
        }
        long groupVersion = this.mGroupFile.version();
        long localMemberId = this.mGroupFile.localMemberId();
        this.releaseShared();
        Channel requestChannel = this.leaderRequestChannel();
        if (requestChannel != null) {
            requestChannel.updateRole(this, groupVersion, localMemberId, desiredRole);
        }
        this.mScheduler.scheduleMillis(this::roleChangeTask, 200L);
    }

    @Override
    public boolean isReadable(long position) {
        return this.mStateLog.isReadable(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamReplicator.Reader newReader(long position, boolean follow) {
        if (follow) {
            return this.doNewReader(position);
        }
        this.acquireShared();
        try {
            StreamReplicator.Reader reader = this.mLeaderLogWriter != null && position >= this.mLeaderLogWriter.termStartPosition() && position < this.mLeaderLogWriter.termEndPosition() && this.localMemberRole() != Role.STANDBY ? null : this.doNewReader(position);
            StreamReplicator.Reader reader2 = reader;
            return reader2;
        }
        finally {
            this.releaseShared();
        }
    }

    private StreamReplicator.Reader doNewReader(long position) {
        LogReader reader = this.mStateLog.openReader(position);
        long commitPosition = reader.commitPosition();
        if (position <= commitPosition) {
            return reader;
        }
        reader.close();
        throw new InvalidReadException("Position is higher than commit position: " + position + " > " + commitPosition);
    }

    @Override
    public StreamReplicator.Writer newWriter() {
        return this.createWriter(-1L);
    }

    @Override
    public StreamReplicator.Writer newWriter(long position) {
        if (position < 0L) {
            throw new IllegalArgumentException();
        }
        return this.createWriter(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamReplicator.Writer createWriter(long position) {
        this.acquireExclusive();
        try {
            ReplWriter writer;
            if (this.mLeaderReplWriter != null) {
                throw new IllegalStateException("Writer already exists: term=" + this.mLeaderReplWriter.term());
            }
            if (this.mLeaderLogWriter == null || position >= 0L && position < this.mLeaderLogWriter.position() || this.localMemberRole() == Role.STANDBY) {
                StreamReplicator.Writer writer2 = null;
                return writer2;
            }
            this.mLeaderReplWriter = writer = new ReplWriter(this.mLeaderLogWriter, this.mAllChannels, this.mConsensusPeers.length == 0, this.mProxyWrites ? this.mProxyChannels : null);
            ReplWriter replWriter = writer;
            return replWriter;
        }
        finally {
            this.releaseExclusive();
        }
    }

    void writerClosed(ReplWriter writer) {
        this.acquireExclusive();
        if (this.mLeaderReplWriter == writer) {
            this.mLeaderReplWriter = null;
            this.checkException(writer);
        }
        this.releaseExclusive();
    }

    private boolean checkException(ReplWriter writer) {
        Throwable e;
        if (writer != null && (e = writer.mException) != null) {
            this.toFollower(e.toString());
            writer.mException = null;
            return true;
        }
        return false;
    }

    @Override
    public void sync() throws IOException {
        this.mStateLog.sync();
    }

    @Override
    public boolean syncCommit(long position, long nanosTimeout) throws IOException {
        long nanosEnd;
        long l = nanosEnd = nanosTimeout <= 0L ? 0L : System.nanoTime() + nanosTimeout;
        while (!this.mStateLog.isDurable(position)) {
            long term;
            if (nanosTimeout == 0L) {
                return false;
            }
            TermLog termLog = this.mStateLog.termLogAt(position);
            if (termLog == null) {
                long commitPosition = this.mStateLog.captureHighest().mCommitPosition;
                if (position > commitPosition) {
                    throw Controller.invalidCommit(position, commitPosition);
                }
                if (this.mStateLog.isDurable(position)) {
                    return true;
                }
                throw new IllegalStateException("No term at position: " + position);
            }
            long prevTerm = termLog.prevTermAt(position);
            long commitPosition = this.mStateLog.syncCommit(prevTerm, term = termLog.term(), position);
            if (position > commitPosition) {
                if (commitPosition >= 0L) {
                    throw Controller.invalidCommit(position, commitPosition);
                }
            } else {
                this.acquireShared();
                Channel[] channels = this.mCandidateChannels;
                this.releaseShared();
                if (channels.length == 0) {
                    this.mStateLog.commitDurable(position);
                    break;
                }
                for (Channel channel : channels) {
                    channel.syncCommit(this, prevTerm, term, position);
                }
                long actualTimeout = 100000000L;
                if (nanosTimeout >= 0L) {
                    actualTimeout = Math.min(nanosTimeout, actualTimeout);
                }
                this.acquireExclusive();
                if (this.mStateLog.isDurable(position)) {
                    this.releaseExclusive();
                    break;
                }
                int result = this.mSyncCommitCondition.await((Latch)this, actualTimeout, nanosEnd);
                this.releaseExclusive();
                if (result < 0) {
                    throw new InterruptedIOException();
                }
            }
            if (nanosTimeout <= 0L || (nanosTimeout = nanosEnd - System.nanoTime()) >= 0L) continue;
            nanosTimeout = 0L;
        }
        this.acquireShared();
        Channel[] channels = this.mAllChannels;
        this.releaseShared();
        for (Channel channel : channels) {
            channel.compact(this, position);
        }
        return true;
    }

    private static IllegalStateException invalidCommit(long position, long commitPosition) {
        throw new IllegalStateException("Invalid commit position: " + position + " > " + commitPosition);
    }

    @Override
    public boolean failover() {
        return this.doFailover(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFailover(ReplWriter from, boolean lagCheck) {
        Channel peerChan;
        this.acquireExclusive();
        try {
            if (from != this.mLeaderReplWriter) {
                if (lagCheck) {
                    boolean bl = false;
                    return bl;
                }
                if (from != null) {
                    boolean bl = false;
                    return bl;
                }
            }
            if (this.mLocalMode == 0 || this.localMemberRole() == Role.STANDBY) {
                boolean bl = true;
                return bl;
            }
            int len = this.mCandidateChannels.length;
            Channel foundOne = null;
            if (len > 0) {
                int offset = ThreadLocalRandom.current().nextInt(len);
                for (int i = 0; i < len; ++i) {
                    peerChan = this.mCandidateChannels[(i + offset) % len];
                    if (peerChan.peer().role() != Role.NORMAL) continue;
                    if (foundOne == null) {
                        foundOne = peerChan;
                    }
                    if (!peerChan.isConnected()) {
                        continue;
                    }
                    break;
                }
            } else {
                if (foundOne == null) {
                    boolean bl = false;
                    return bl;
                }
                peerChan = foundOne;
            }
            if (!lagCheck && from == null && this.mLeaderReplWriter != null && this.mLeaderReplWriter.deactivateExplicit()) {
                boolean bl = true;
                return bl;
            }
            if (lagCheck) {
                this.toFollower("lagging behind");
            } else {
                this.toFollower("explicit failover");
            }
            this.mCandidateStall = 10;
        }
        finally {
            this.releaseExclusive();
        }
        peerChan.forceElection(null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compact(long position) throws IOException {
        long lowestPosition = position;
        this.acquireShared();
        try {
            for (Channel channel : this.mAllChannels) {
                lowestPosition = Math.min(lowestPosition, channel.peer().mCompactPosition);
            }
        }
        finally {
            this.releaseShared();
        }
        this.mStateLog.compact(lowestPosition);
    }

    @Override
    public long commitPosition() {
        return this.mStateLog.potentialCommitPosition();
    }

    @Override
    public long localMemberId() {
        return this.mChanMan.localMemberId();
    }

    @Override
    public SocketAddress localAddress() {
        this.acquireShared();
        SocketAddress addr = this.mGroupFile.localMemberAddress();
        this.releaseShared();
        return addr;
    }

    @Override
    public Role localRole() {
        this.acquireShared();
        Role role = this.localMemberRole();
        this.releaseShared();
        return role;
    }

    private Role localMemberRole() {
        return this.mGroupFile.localMemberRole();
    }

    @Override
    public Socket connect(SocketAddress addr) throws IOException {
        return this.mChanMan.connectPlain(addr);
    }

    @Override
    public void socketAcceptor(Consumer<Socket> acceptor) {
        this.mChanMan.socketAcceptor(acceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void controlMessageReceived(long position, byte[] message) throws IOException {
        boolean quickCommit = false;
        this.acquireExclusive();
        try {
            boolean refresh;
            switch (message[0]) {
                default: {
                    return;
                }
                case 1: {
                    refresh = this.mGroupFile.applyJoin(position, message) != null;
                    break;
                }
                case 2: {
                    refresh = this.mGroupFile.applyUpdateRole(message);
                    break;
                }
                case 3: {
                    refresh = this.mGroupFile.applyRemovePeer(message);
                }
            }
            if (refresh) {
                this.refreshPeerSet();
                if (this.mLocalMode == 2) {
                    quickCommit = true;
                }
            }
        }
        finally {
            this.releaseExclusive();
        }
        if (quickCommit) {
            this.mScheduler.execute(this::affirmLeadership);
        }
    }

    @Override
    public void controlMessageAcceptor(Consumer<byte[]> acceptor) {
        this.mControlMessageAcceptor = acceptor;
    }

    @Override
    public SocketSnapshotReceiver requestSnapshot(Map<String, String> options) throws IOException {
        try {
            return this.requestSnapshot(options, 5000L);
        }
        catch (IOException e) {
            return this.requestSnapshot(options, 10000L);
        }
    }

    private SocketSnapshotReceiver requestSnapshot(Map<String, String> options, long timeoutMillis) throws IOException {
        this.acquireShared();
        Channel[] channels = this.mProxyChannels;
        this.releaseShared();
        if (channels.length == 0) {
            return null;
        }
        Controller.waitForConnections(channels);
        Thread requestedBy = Thread.currentThread();
        for (Channel channel : channels) {
            channel.peer().prepareSnapshotScore(requestedBy);
            channel.snapshotScore(this);
        }
        long end = System.currentTimeMillis() + timeoutMillis;
        ArrayList<SnapshotScore> results = new ArrayList<SnapshotScore>(channels.length);
        int i = 0;
        while (i < channels.length) {
            Channel channel = channels[i];
            SnapshotScore score = channel.peer().awaitSnapshotScore(requestedBy, timeoutMillis);
            if (score != null) {
                results.add(score);
            }
            if (++i < channels.length && (timeoutMillis = end - System.currentTimeMillis()) > 0L) continue;
            break;
        }
        if (results.isEmpty()) {
            throw new ConnectException("Unable to obtain a snapshot from a peer (timed out)");
        }
        Collections.shuffle(results);
        Collections.sort(results);
        Socket sock = this.mChanMan.connectSnapshot(((SnapshotScore)results.get((int)0)).mPeer.mAddress);
        try {
            return new SocketSnapshotReceiver(this.mGroupFile, sock, options);
        }
        catch (IOException e) {
            Utils.closeQuietly(sock);
            throw e;
        }
    }

    @Override
    public void snapshotRequestAcceptor(Consumer<SnapshotSender> acceptor) {
        this.mChanMan.snapshotRequestAcceptor((Socket sock) -> {
            Sender sender;
            try {
                sender = new Sender((Socket)sock);
            }
            catch (IOException e) {
                Utils.closeQuietly(sock);
                return;
            }
            catch (Throwable e) {
                Utils.closeQuietly(sock);
                throw e;
            }
            this.mScheduler.execute(() -> acceptor.accept(sender));
        });
    }

    private void adjustSnapshotSessionCount(Sender sender, int amt) {
        this.acquireExclusive();
        if (!sender.mClosed) {
            this.mSnapshotSessionCount += amt;
            if (amt < 0) {
                sender.mClosed = true;
            }
        }
        this.releaseExclusive();
    }

    @Override
    public void close() throws IOException {
        this.mChanMan.stop();
        this.mScheduler.shutdown();
        this.mStateLog.close();
        this.acquireExclusive();
        try {
            this.mSyncCommitCondition.signalAll(this);
        }
        finally {
            this.releaseExclusive();
        }
    }

    void uncaught(Throwable e) {
        if (!this.mChanMan.isStopped()) {
            if (e instanceof JoinException && this.mEventListener != null) {
                try {
                    this.mEventListener.notify(EventType.REPLICATION_WARNING, e.getMessage(), new Object[0]);
                }
                catch (Throwable throwable) {}
            } else {
                Utils.uncaught(e);
            }
        }
    }

    void partitioned(boolean enable) {
        this.mChanMan.partitioned(enable);
    }

    private static void waitForConnections(Channel[] channels) throws InterruptedIOException {
        int timeoutMillis = 500;
        for (Channel channel : channels) {
            timeoutMillis = channel.waitForConnection(timeoutMillis);
        }
    }

    private void scheduleSyncTask() {
        new Delayed(0L){
            private long mTargetDurablePosition;
            {
                this.schedule();
            }

            @Override
            protected void doRun() {
                StateLog log = Controller.this.mStateLog;
                long commitPosition = log.captureHighest().mCommitPosition;
                if (!log.isDurable(this.mTargetDurablePosition)) {
                    try {
                        Controller.this.syncCommit(this.mTargetDurablePosition, -1L);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.mTargetDurablePosition = commitPosition;
                this.schedule();
            }

            private void schedule() {
                int delayMillis = ThreadLocalRandom.current().nextInt(2000, 3000);
                this.mCounter = System.nanoTime() + (long)delayMillis * 1000000L;
                Controller.this.mScheduler.scheduleNanos(this);
            }
        };
    }

    private void scheduleMissingDataTask() {
        int delayMillis = ThreadLocalRandom.current().nextInt(400, 600);
        this.mScheduler.scheduleMillis(this::missingDataTask, delayMillis);
    }

    private void missingDataTask() {
        if (this.tryAcquireShared()) {
            if (this.mLocalMode == 2) {
                this.mMissingContigPosition = Long.MAX_VALUE;
                this.mSkipMissingDataTask = true;
                this.releaseShared();
                return;
            }
            this.releaseShared();
        }
        if (this.mReceivingMissingData) {
            this.mReceivingMissingData = false;
        } else {
            var collector = new PositionRange(){
                long[] mRanges;
                int mSize;

                @Override
                public void range(long startPosition, long endPosition) {
                    if (this.mRanges == null) {
                        this.mRanges = new long[16];
                    } else if (this.mSize >= this.mRanges.length) {
                        this.mRanges = Arrays.copyOf(this.mRanges, this.mRanges.length << 1);
                    }
                    this.mRanges[this.mSize++] = startPosition;
                    this.mRanges[this.mSize++] = endPosition;
                }
            };
            this.mMissingContigPosition = this.mStateLog.checkForMissingData(this.mMissingContigPosition, collector);
            if (collector.mSize <= 0) {
                this.acquireShared();
                Role local = this.localMemberRole();
                Channel leader = this.mLeaderReplyChannel;
                this.releaseShared();
                if (local == Role.NORMAL && leader != null && leader.peer().role() == Role.STANDBY) {
                    this.acquireExclusive();
                    this.forceElection();
                }
            } else if (this.mChanMan.checkControlVersion(1)) {
                int i = 0;
                while (i < collector.mSize) {
                    long startPosition = collector.mRanges[i++];
                    long endPosition = collector.mRanges[i++];
                    this.requestMissingData(startPosition, endPosition);
                }
            }
        }
        this.scheduleMissingDataTask();
    }

    private void requestMissingData(long startPosition, long endPosition) {
        long requestSize;
        this.event(EventType.REPLICATION_DEBUG, () -> String.format("Requesting missing data: %1$,d bytes @[%2$d, %3$d)", endPosition - startPosition, startPosition, endPosition));
        long remaining = endPosition - startPosition;
        long position = startPosition;
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        this.acquireShared();
        Channel[] channels = this.mProxyChannels;
        this.releaseShared();
        if (channels.length <= 1) {
            if (channels.length == 0) {
                this.event(EventType.REPLICATION_PANIC, "No peers to request data from");
                return;
            }
            requestSize = remaining;
        } else {
            long requestCount = (long)channels.length * 10L;
            requestSize = Math.max(100000L, (remaining + requestCount - 1L) / requestCount);
        }
        block0: while (remaining > 0L) {
            Channel channel;
            long amt = Math.min(remaining, requestSize);
            int selected = rnd.nextInt(channels.length);
            int attempts = 0;
            while (!(channel = channels[selected]).queryData(this, position, position + amt)) {
                if (++attempts >= channels.length) break block0;
                if (++selected < channels.length) continue;
                selected = 0;
            }
            position += amt;
            remaining -= amt;
        }
    }

    private void scheduleElectionTask() {
        int delayMillis = ThreadLocalRandom.current().nextInt(200, 300);
        this.mScheduler.scheduleMillis(this::electionTask, delayMillis);
    }

    private void electionTask() {
        try {
            this.acquireExclusive();
            this.doElectionTask();
        }
        finally {
            this.scheduleElectionTask();
        }
    }

    private void forceElection() {
        this.mElectionValidated = Integer.MIN_VALUE;
        this.mCandidateStall = 0;
        this.doElectionTask();
    }

    private void doElectionTask() {
        long term;
        long candidateId;
        LogInfo info;
        Channel[] peerChannels;
        block21: {
            Channel[] peerChannels2;
            block23: {
                block22: {
                    if (this.mLocalMode == 2) {
                        this.doAffirmLeadership();
                        return;
                    }
                    if (this.mElectionValidated < 0) break block21;
                    --this.mElectionValidated;
                    if (this.mElectionValidated >= 0 || !Controller.isCandidate(this.localMemberRole())) break block22;
                    peerChannels2 = this.mCandidateChannels;
                    if (this.mCandidateChannels.length > 0) break block23;
                }
                this.releaseExclusive();
                return;
            }
            long term2 = this.mStateLog.captureHighest().mTerm;
            for (Channel peerChan : peerChannels2) {
                peerChan.peer().mLeaderCheck = term2;
            }
            this.releaseExclusive();
            for (Channel peerChan : peerChannels2) {
                peerChan.leaderCheck(null);
            }
            return;
        }
        try {
            if (this.mLocalMode == 1) {
                this.toFollower("election timed out");
            }
            if (!Controller.isCandidate(this.localMemberRole())) {
                this.releaseExclusive();
                return;
            }
            if (this.mCandidateStall > 0) {
                --this.mCandidateStall;
                this.releaseExclusive();
                return;
            }
            peerChannels = this.mCandidateChannels;
            info = this.mStateLog.captureHighest();
            if (this.mElectionValidated > Integer.MIN_VALUE) {
                int noLeaderCount = 1;
                for (Channel peerChan : peerChannels) {
                    if (peerChan.peer().mLeaderCheck != -1L) continue;
                    ++noLeaderCount;
                }
                if (noLeaderCount <= (peerChannels.length + 1) / 2) {
                    this.mElectionValidated = 0;
                    this.releaseExclusive();
                    return;
                }
            }
            this.mLocalMode = 1;
            candidateId = this.mChanMan.localMemberId();
            try {
                this.mCurrentTerm = term = this.mStateLog.incrementCurrentTerm(1, candidateId);
            }
            catch (IOException e) {
                this.releaseExclusive();
                this.uncaught(e);
                return;
            }
            this.mGrantsRemaining = (peerChannels.length + 1) / 2;
            this.mElectionValidated = 1;
        }
        catch (Throwable e) {
            this.releaseExclusive();
            throw e;
        }
        if (this.mGrantsRemaining == 0) {
            this.toLeader(term, info.mHighestPosition);
        } else {
            this.releaseExclusive();
            StringBuilder b = new StringBuilder().append("Local member is ");
            if (this.localMemberRole() == Role.STANDBY) {
                b.append("an interim ");
            } else {
                b.append("a ");
            }
            b.append("candidate: term=").append(term).append(", highestTerm=").append(info.mTerm).append(", highestPosition=").append(info.mHighestPosition);
            this.event(EventType.REPLICATION_INFO, b.toString());
            for (Channel peerChan : peerChannels) {
                peerChan.requestVote(null, term, candidateId, info.mTerm, info.mHighestPosition);
            }
        }
    }

    private static boolean isCandidate(Role role) {
        return role != null && role.isCandidate();
    }

    private void affirmLeadership() {
        this.acquireExclusive();
        this.doAffirmLeadership();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAffirmLeadership() {
        long commitPosition;
        long highestPosition;
        LogWriter writer;
        try {
            writer = this.mLeaderLogWriter;
            if (writer == null) {
                return;
            }
            if (this.checkException(this.mLeaderReplWriter)) {
                return;
            }
            this.mStateLog.captureHighest(writer);
            highestPosition = writer.mHighestPosition;
            commitPosition = writer.mCommitPosition;
            if (commitPosition >= highestPosition || commitPosition > this.mLeaderCommitPosition) {
                this.mElectionValidated = 40;
                this.mLeaderCommitPosition = commitPosition;
            } else if (this.mElectionValidated >= 0) {
                --this.mElectionValidated;
            } else {
                String reason = "commit position is stalled: " + commitPosition + " < " + highestPosition;
                if (this.mLeaderReplWriter == null) {
                    this.toFollower(reason);
                    return;
                }
                this.mLeaderReplWriter.deactivateStalled(reason);
            }
        }
        finally {
            this.releaseExclusive();
        }
        Channel[] peerChannels = this.mAllChannels;
        long prevTerm = writer.prevTerm();
        long term = writer.term();
        long position = writer.position();
        for (Channel peerChan : peerChannels) {
            peerChan.writeData(null, prevTerm, term, position, highestPosition, commitPosition, null, EMPTY_DATA, 0, 0);
        }
    }

    private void toFollower(ReplWriter from, String reason) {
        this.acquireExclusive();
        try {
            if (this.mLeaderReplWriter == from) {
                this.toFollower(reason);
            }
        }
        finally {
            this.releaseExclusive();
        }
    }

    private void toFollower(String reason) {
        int originalMode = this.mLocalMode;
        if (originalMode != 0) {
            this.mLocalMode = 0;
            this.mElectionValidated = 0;
            if (this.mLeaderReplWriter != null) {
                this.mLeaderReplWriter.fullyDeactivate();
            }
            if (this.mLeaderLogWriter != null) {
                this.mLeaderLogWriter.release();
                this.mLeaderLogWriter = null;
            }
            StringBuilder b = new StringBuilder("Local member ");
            if (this.localMemberRole() == Role.STANDBY) {
                b.append("interim ");
            }
            if (originalMode == 2) {
                if (this.mSkipMissingDataTask) {
                    this.mSkipMissingDataTask = false;
                    this.scheduleMissingDataTask();
                }
                b.append("leadership");
            } else {
                b.append("candidacy");
            }
            b.append(" lost: ");
            if (reason == null) {
                b.append("term=").append(this.mCurrentTerm);
            } else {
                b.append(reason);
            }
            this.event(EventType.REPLICATION_INFO, b.toString());
        }
    }

    private void scheduleRemoveStaleMembersTask() {
        this.mScheduler.scheduleMillis(this::removeStaleMembers, 5000L);
    }

    private void removeStaleMembers() {
        try {
            this.doRemoveStaleMembers();
        }
        catch (Throwable e) {
            this.uncaught(e);
        }
        if (this.tryAcquireShared()) {
            if (this.mLocalMode != 2 && this.tryUpgrade()) {
                this.mRemovingStaleMembers = false;
                this.releaseExclusive();
                return;
            }
            this.releaseShared();
        }
        this.scheduleRemoveStaleMembersTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveStaleMembers() {
        Set<? extends Channel> channels = this.mChanMan.allChannels();
        if (channels.isEmpty()) {
            return;
        }
        long now = Long.MIN_VALUE;
        for (Channel channel : channels) {
            Peer peer;
            Role role;
            long duration;
            long startedAt = channel.connectAttemptStartedAt();
            if (startedAt == Long.MAX_VALUE) continue;
            if (now == Long.MIN_VALUE) {
                now = System.currentTimeMillis();
            }
            if ((duration = now - startedAt) <= 10000L || (role = (peer = channel.peer()).role()) != Role.RESTORING) continue;
            Consumer<byte[]> acceptor = this.mControlMessageAcceptor;
            if (acceptor == null) {
                return;
            }
            byte[] message = this.mGroupFile.proposeRemovePeer((byte)3, peer.mMemberId, null);
            if (!this.registerControlMessage(message)) continue;
            try {
                acceptor.accept(message);
            }
            finally {
                this.unregisterControlMessage(message);
            }
        }
    }

    private void requestJoin(Socket s) {
        try {
            try {
                if (this.doRequestJoin(s)) {
                    return;
                }
            }
            catch (IllegalStateException e) {
                OutputStream out = s.getOutputStream();
                out.write(new byte[]{1, 5});
            }
        }
        catch (Throwable e) {
            Utils.closeQuietly(s);
            Utils.rethrow(e);
        }
        Utils.closeQuietly(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean doRequestJoin(Socket s) throws IOException {
        in = new ChannelInputStream(s.getInputStream(), 100, false);
        op = in.read();
        switch (op) {
            default: {
                return Controller.joinFailure(s, (byte)1);
            }
            case 2: 
            case 4: {
                addr = GroupFile.parseSocketAddress(in.readStr(in.readIntLE()));
                memberId = 0L;
                break;
            }
            case 5: {
                addr = null;
                memberId = in.readLongLE();
            }
        }
        out = s.getOutputStream();
        this.acquireShared();
        isLeader = this.mLocalMode == 2;
        leaderReplyChannel = this.mLeaderReplyChannel;
        this.releaseShared();
        if (!isLeader) {
            if (leaderReplyChannel == null || (leaderPeer = leaderReplyChannel.peer()) == null) {
                return Controller.joinFailure(s, (byte)8);
            }
            eout = new EncodingOutputStream();
            eout.write(2);
            eout.encodeStr(leaderPeer.mAddress.toString());
            out.write(eout.toByteArray());
            return false;
        }
        acceptor = this.mControlMessageAcceptor;
        if (acceptor == null) {
            return Controller.joinFailure(s, (byte)2);
        }
        switch (op) {
            case 2: {
                message = this.mGroupFile.proposeJoin((byte)1, addr, (ObjLongConsumer<InputStream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;J)V, lambda$doRequestJoin$3(java.io.OutputStream java.io.InputStream long ), (Ljava/io/InputStream;J)V)((Controller)this, (OutputStream)out));
                break;
            }
            case 4: {
                if (!this.mGroupFile.localMemberAddress().equals(addr)) ** GOTO lbl37
                memberId = this.mGroupFile.localMemberId();
                ** GOTO lbl41
lbl37:
                // 2 sources

                for (Peer peer : this.mGroupFile.allPeers()) {
                    if (!peer.mAddress.equals(addr)) continue;
                    memberId = peer.mMemberId;
                    break;
                }
            }
lbl41:
            // 4 sources

            case 5: {
                message = this.mGroupFile.proposeRemovePeer((byte)3, memberId, (Consumer<Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doRequestJoin$4(java.io.OutputStream java.lang.Boolean ), (Ljava/lang/Boolean;)V)((OutputStream)out));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.mScheduler.scheduleMillis((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$doRequestJoin$5(byte[] java.net.Socket ), ()V)((Controller)this, (byte[])message, (Socket)s), 5000L);
        if (this.registerControlMessage(message)) {
            try {
                acceptor.accept(message);
            }
            finally {
                this.unregisterControlMessage(message);
            }
        }
        return true;
    }

    private static boolean joinFailure(Socket s, byte errorCode) throws IOException {
        s.getOutputStream().write(new byte[]{1, errorCode});
        return false;
    }

    private Channel leaderRequestChannel() {
        Channel replyChannel;
        Channel requestChannel;
        this.acquireShared();
        boolean exclusive = false;
        while (true) {
            if (this.mLocalMode == 2) {
                this.release(exclusive);
                return this;
            }
            requestChannel = this.mLeaderRequestChannel;
            if (requestChannel != null || (replyChannel = this.mLeaderReplyChannel) == null) {
                this.release(exclusive);
                return requestChannel;
            }
            if (exclusive || this.tryUpgrade()) break;
            this.releaseShared();
            this.acquireExclusive();
            exclusive = true;
        }
        Peer leader = replyChannel.peer();
        for (Channel channel : this.mAllChannels) {
            if (!leader.equals(channel.peer())) continue;
            this.mLeaderRequestChannel = requestChannel = channel;
            break;
        }
        this.releaseExclusive();
        return requestChannel;
    }

    private void event(EventType type, String message) {
        if (this.mEventListener != null) {
            try {
                this.mEventListener.notify(type, message, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void event(EventType type, Supplier<String> message) {
        if (this.mEventListener != null) {
            try {
                this.mEventListener.notify(type, message.get(), new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void commitConflict(Channel from, CommitConflictException e) {
        Peer peer;
        if (from != null && (peer = from.peer()) != null && !peer.role().providesConsensus()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now >= this.mLastConflictReport + 60000L) {
            if (this.mEventListener == null) {
                this.uncaught(e);
            } else {
                StringBuilder b = new StringBuilder().append(e.isFatal() ? "Fatal commit" : "Commit").append(" conflict detected: position=").append(e.mPosition).append(", conflicting term=").append(e.mTermInfo.mTerm).append(", commit position=").append(e.mTermInfo.mCommitPosition);
                if (!e.isFatal()) {
                    b.append(". Restarting might rollback the conflict and resolve the issue.");
                }
                this.mEventListener.notify(EventType.REPLICATION_PANIC, b.toString(), new Object[0]);
            }
            this.mLastConflictReport = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerControlMessage(byte[] message) {
        if (message == null) {
            return false;
        }
        Set<byte[]> registered = this.mRegisteredControlMessages;
        if (registered == null) {
            this.acquireExclusive();
            try {
                registered = this.mRegisteredControlMessages;
                if (registered == null) {
                    this.mRegisteredControlMessages = registered = new ConcurrentSkipListSet<byte[]>(Arrays::compareUnsigned);
                    registered.add(message);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.releaseExclusive();
            }
        }
        return registered.add(message);
    }

    private void unregisterControlMessage(byte[] message) {
        Set<byte[]> registered = this.mRegisteredControlMessages;
        if (registered != null) {
            registered.remove(message);
            if (registered.isEmpty()) {
                this.acquireShared();
                if (registered == this.mRegisteredControlMessages && registered.isEmpty()) {
                    this.mRegisteredControlMessages = null;
                }
                this.releaseShared();
            }
        }
    }

    @Override
    public void unknown(Channel from, int op) {
        this.event(EventType.REPLICATION_WARNING, "Unknown operation received from: " + from.peer().mAddress + ", op=" + op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestVote(Channel from, long term, long candidateId, long highestTerm, long highestPosition) {
        long currentTerm;
        this.acquireExclusive();
        try {
            long originalTerm = this.mCurrentTerm;
            this.mCurrentTerm = currentTerm = this.mStateLog.checkCurrentTerm(term);
            if (currentTerm > originalTerm) {
                this.toFollower(null);
            }
            if (currentTerm >= originalTerm && !this.isBehind(from, highestTerm, highestPosition) && this.mStateLog.checkCandidate(candidateId)) {
                currentTerm |= Long.MIN_VALUE;
                this.mElectionValidated = 1;
            }
        }
        catch (IOException e) {
            this.uncaught(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseExclusive();
        }
        from.requestVoteReply(null, currentTerm);
        return true;
    }

    private boolean isBehind(Channel from, long term, long position) {
        LogInfo info = this.mStateLog.captureHighest();
        return term < info.mTerm || term == info.mTerm && position < info.mHighestPosition || this.localMemberRole() == Role.NORMAL && from.peer().role() == Role.STANDBY && position <= info.mHighestPosition;
    }

    @Override
    public boolean requestVoteReply(Channel from, long term) {
        this.acquireExclusive();
        long originalTerm = this.mCurrentTerm;
        if (term < 0L && (term &= Long.MAX_VALUE) == originalTerm) {
            if (--this.mGrantsRemaining > 0 || this.mLocalMode != 1) {
                this.releaseExclusive();
                return true;
            }
            LogInfo info = this.mStateLog.captureHighest();
            this.toLeader(term, info.mHighestPosition);
            return true;
        }
        try {
            this.mCurrentTerm = this.mStateLog.checkCurrentTerm(term);
        }
        catch (IOException e) {
            this.releaseExclusive();
            this.uncaught(e);
            return false;
        }
        if (this.mCurrentTerm <= originalTerm) {
            this.releaseExclusive();
            return true;
        }
        this.toFollower("vote denied");
        this.releaseExclusive();
        return true;
    }

    private void toLeader(long term, long position) {
        try {
            StringBuilder b = new StringBuilder().append("Local member is ");
            if (this.localMemberRole() == Role.STANDBY) {
                b.append("an interim ");
            } else {
                b.append("the ");
            }
            b.append("leader: term=").append(term).append(", position=").append(position);
            this.event(EventType.REPLICATION_INFO, b.toString());
            this.mElectionValidated = 40;
            this.mLeaderReplyChannel = null;
            this.mLeaderRequestChannel = null;
            long prevTerm = this.mStateLog.termLogAt(position).prevTermAt(position);
            this.mLeaderLogWriter = this.mStateLog.openWriter(prevTerm, term, position);
            this.mLocalMode = 2;
            for (Channel channel : this.mAllChannels) {
                channel.peer().mMatchPosition = 0L;
            }
            if (this.mConsensusPeers.length == 0) {
                this.mStateLog.captureHighest(this.mLeaderLogWriter);
                this.mStateLog.commit(this.mLeaderLogWriter.mHighestPosition);
            }
        }
        catch (Throwable e) {
            this.releaseExclusive();
            this.uncaught(e);
            return;
        }
        if (position > 0L) {
            ReplWriter old = this.mLeaderReplWriter;
            this.mScheduler.scheduleMillis(() -> this.doFailover(old, true), 1000L);
        }
        if (!this.mRemovingStaleMembers) {
            this.mRemovingStaleMembers = true;
            this.scheduleRemoveStaleMembersTask();
        }
        this.doAffirmLeadership();
    }

    @Override
    public boolean forceElection(Channel from) {
        this.event(EventType.REPLICATION_INFO, "Forcing an election, as requested by: " + from.peer().mAddress);
        this.acquireExclusive();
        this.forceElection();
        return true;
    }

    @Override
    public boolean queryTerms(Channel from, long startPosition, long endPosition) {
        this.mStateLog.queryTerms(startPosition, endPosition, (prevTerm, term, position) -> from.queryTermsReply(null, prevTerm, term, position));
        return true;
    }

    @Override
    public boolean queryTermsReply(Channel from, long prevTerm, long term, long startPosition) {
        try {
            this.queryReplyTermCheck(term);
            this.mStateLog.defineTerm(prevTerm, term, startPosition);
        }
        catch (CommitConflictException e) {
            this.commitConflict(from, e);
        }
        catch (IOException e) {
            this.uncaught(e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryReplyTermCheck(long term) throws IOException {
        this.acquireShared();
        long originalTerm = this.mCurrentTerm;
        if (term < originalTerm) {
            this.releaseShared();
            return;
        }
        if (!this.tryUpgrade()) {
            this.releaseShared();
            this.acquireExclusive();
            originalTerm = this.mCurrentTerm;
        }
        try {
            if (term > originalTerm) {
                this.mCurrentTerm = this.mStateLog.checkCurrentTerm(term);
                if (this.mCurrentTerm > originalTerm) {
                    this.toFollower(null);
                }
            }
        }
        finally {
            this.releaseExclusive();
        }
    }

    @Override
    public boolean queryData(Channel from, long startPosition, long endPosition) {
        if (endPosition <= startPosition) {
            return true;
        }
        Peer peer = from.peer();
        if (peer == null) {
            return true;
        }
        RangeSet rangeSet = peer.queryData(startPosition, endPosition);
        if (rangeSet == null) {
            return true;
        }
        return this.mScheduler.execute(() -> {
            RangeSet set = rangeSet;
            while (true) {
                RangeSet.Range range;
                if ((range = set.removeLowest()) == null) {
                    if ((set = peer.finishedQueries(set)) != null) continue;
                    return;
                }
                try {
                    this.doQueryData(from, range.start, range.end);
                }
                catch (Throwable e) {
                    if (!(e instanceof InvalidReadException)) {
                        this.uncaught(e);
                    }
                    peer.discardQueries(set);
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueryData(Channel from, long startPosition, long endPosition) throws IOException {
        LogReader reader = this.mStateLog.openReader(startPosition);
        try {
            long remaining = endPosition - startPosition;
            byte[] buf = new byte[(int)Math.min(9000L, remaining)];
            while (true) {
                long currentTerm = 0L;
                long prevTerm = reader.prevTerm();
                long position = reader.position();
                long term = reader.term();
                int require = (int)Math.min((long)buf.length, remaining);
                int amt = reader.tryRead(buf, 0, require);
                if (amt == 0) {
                    this.acquireShared();
                    try {
                        int any;
                        if (this.mLocalMode == 2 && (any = reader.tryReadAny(buf, amt, require)) > 0) {
                            currentTerm = this.mCurrentTerm;
                            amt += any;
                        }
                    }
                    finally {
                        this.releaseShared();
                    }
                }
                if (amt <= 0) {
                    if (amt < 0) {
                        reader.release();
                        reader = this.mStateLog.openReader(startPosition);
                        continue;
                    }
                    from.queryDataReplyMissing(null, currentTerm, prevTerm, term, position, position + remaining);
                    break;
                }
                if (!from.queryDataReply(null, currentTerm, prevTerm, term, position, buf, 0, amt)) {
                    break;
                }
                startPosition += (long)amt;
                if ((remaining -= (long)amt) <= 0L) break;
            }
        }
        finally {
            reader.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean queryDataReply(Channel from, long currentTerm, long prevTerm, long term, long position, byte[] data, int off, int len) {
        block7: {
            if (currentTerm != 0L && this.validateLeaderTerm(from, currentTerm) == this) {
                return false;
            }
            this.mReceivingMissingData = true;
            try {
                this.queryReplyTermCheck(term);
                LogWriter writer = this.mStateLog.openWriter(prevTerm, term, position);
                if (writer == null) break block7;
                try {
                    writer.write(data, off, len, 0L);
                }
                finally {
                    writer.release();
                }
            }
            catch (CommitConflictException e) {
                this.commitConflict(from, e);
            }
            catch (IOException e) {
                this.uncaught(e);
            }
        }
        return true;
    }

    @Override
    public boolean queryDataReplyMissing(Channel from, long currentTerm, long prevTerm, long term, long startPosition, long endPosition) {
        if (currentTerm != 0L && this.validateLeaderTerm(from, currentTerm) == this) {
            return false;
        }
        this.mReceivingMissingData = true;
        try {
            this.queryReplyTermCheck(term);
        }
        catch (IOException e) {
            this.uncaught(e);
        }
        Channel requestChannel = this.leaderRequestChannel();
        if (requestChannel == null || requestChannel == this) {
            return false;
        }
        TermLog termLog = this.mStateLog.termLogAt(startPosition);
        if (termLog != null && (startPosition = Math.max(startPosition, termLog.contigPosition())) >= endPosition) {
            return true;
        }
        return requestChannel.queryData(this, startPosition, endPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean writeData(Channel from, long prevTerm, long term, long position, long highestPosition, long commitPosition, byte[] prefix, byte[] data, int off, int len) {
        if ((from = this.validateLeaderTerm(from, term)) == this) {
            return false;
        }
        try {
            LogWriter writer = this.mStateLog.openWriter(prevTerm, term, position);
            if (writer == null) {
                Channel requestChannel;
                long now = System.currentTimeMillis();
                if (now < this.mNextQueryTermTime) return true;
                LogInfo info = this.mStateLog.captureHighest();
                if (highestPosition > info.mCommitPosition && position > info.mCommitPosition && (requestChannel = this.leaderRequestChannel()) != null && requestChannel != this) {
                    requestChannel.queryTerms(this, info.mCommitPosition, position);
                }
                this.mNextQueryTermTime = now + 1L;
                return true;
            }
            try {
                writer.write(prefix, data, off, len, highestPosition);
                this.mStateLog.commit(commitPosition);
                this.mStateLog.captureHighest(writer);
                long highestTerm = writer.mTerm;
                if (highestTerm < term) {
                    boolean bl = true;
                    return bl;
                }
                term = highestTerm;
                highestPosition = writer.mHighestPosition;
            }
            finally {
                writer.release();
            }
        }
        catch (CommitConflictException e) {
            this.commitConflict(from, e);
        }
        catch (IOException e) {
            this.uncaught(e);
        }
        if (from == null) return true;
        if (!this.mGroupFile.localMemberRoleOpaque().providesConsensus()) return true;
        from.writeDataReply(null, term, highestPosition);
        return true;
    }

    private Channel validateLeaderTerm(Channel from, long term) {
        this.acquireShared();
        boolean exclusive = false;
        while (true) {
            long originalTerm;
            if (term == (originalTerm = this.mCurrentTerm)) {
                if (this.mElectionValidated > 0) {
                    if (from == null && term == this.mValidatedTerm) {
                        from = this.mLeaderReplyChannel;
                    }
                    this.release(exclusive);
                    return from;
                }
                if (exclusive || this.tryUpgrade()) break;
                this.releaseShared();
                this.acquireExclusive();
                exclusive = true;
                continue;
            }
            if (term < originalTerm) {
                this.release(exclusive);
                return this;
            }
            if (!exclusive) {
                if (this.tryUpgrade()) {
                    exclusive = true;
                } else {
                    this.releaseShared();
                    this.acquireExclusive();
                    exclusive = true;
                    continue;
                }
            }
            try {
                try {
                    this.mCurrentTerm = this.mStateLog.checkCurrentTerm(term);
                }
                catch (IOException e) {
                    this.uncaught(e);
                    this.releaseExclusive();
                    return this;
                }
                if (this.mCurrentTerm <= originalTerm) continue;
                this.toFollower(null);
            }
            catch (Throwable e) {
                this.releaseExclusive();
                throw e;
            }
        }
        if (from == null) {
            if (term == this.mValidatedTerm) {
                from = this.mLeaderReplyChannel;
            }
            if (from == null) {
                this.releaseExclusive();
                return from;
            }
        }
        this.mElectionValidated = 1;
        this.mLeaderReplyChannel = from;
        boolean first = false;
        if (term != this.mValidatedTerm) {
            this.mValidatedTerm = term;
            this.mLeaderRequestChannel = null;
            first = true;
            this.mCandidateStall = 0;
        }
        this.releaseExclusive();
        if (first) {
            StringBuilder b = new StringBuilder().append("Remote member is ");
            if (from.peer().role() == Role.STANDBY) {
                b.append("an interim ");
            } else {
                b.append("the ");
            }
            b.append("leader: ").append(from.peer().mAddress).append(", term=").append(term);
            this.event(EventType.REPLICATION_INFO, b.toString());
        }
        return from;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeDataReply(Channel from, long term, long highestPosition) {
        long commitPosition;
        this.acquireExclusive();
        try {
            if (this.mLocalMode != 2) {
                boolean bl = true;
                return bl;
            }
            long originalTerm = this.mCurrentTerm;
            if (term != originalTerm) {
                try {
                    this.mCurrentTerm = this.mStateLog.checkCurrentTerm(term);
                }
                catch (IOException e) {
                    this.uncaught(e);
                    boolean bl = false;
                    this.releaseExclusive();
                    return bl;
                }
                if (this.mCurrentTerm > originalTerm) {
                    this.toFollower(null);
                }
                boolean e = true;
                return e;
            }
            Peer peer = from.peer();
            long matchPosition = peer.mMatchPosition;
            if (highestPosition <= matchPosition || this.mConsensusPeers.length == 0) {
                boolean bl = true;
                return bl;
            }
            peer.mMatchPosition = highestPosition;
            Arrays.sort(this.mConsensusPeers);
            commitPosition = this.mConsensusPeers[this.mConsensusPeers.length >> 1].mMatchPosition;
        }
        finally {
            this.releaseExclusive();
        }
        this.mStateLog.commit(commitPosition);
        return true;
    }

    @Override
    public boolean writeDataAndProxy(Channel from, long prevTerm, long term, long position, long highestPosition, long commitPosition, byte[] prefix, byte[] data, int off, int len) {
        this.writeData(from, prevTerm, term, position, highestPosition, commitPosition, prefix, data, off, len);
        Peer fromPeer = from.peer();
        this.acquireShared();
        Channel[] peerChannels = this.mAllChannels;
        this.releaseShared();
        if (peerChannels != null) {
            for (Channel peerChan : peerChannels) {
                Peer peer = peerChan.peer();
                if (fromPeer.equals(peer)) continue;
                peerChan.writeDataViaProxy(null, prevTerm, term, position, highestPosition, commitPosition, prefix, data, off, len);
            }
        }
        return true;
    }

    @Override
    public boolean writeDataViaProxy(Channel from, long prevTerm, long term, long position, long highestPosition, long commitPosition, byte[] prefix, byte[] data, int off, int len) {
        return this.writeData(null, prevTerm, term, position, highestPosition, commitPosition, prefix, data, off, len);
    }

    @Override
    public boolean syncCommit(Channel from, long prevTerm, long term, long position) {
        try {
            if (this.mStateLog.syncCommit(prevTerm, term, position) >= position) {
                from.syncCommitReply(null, this.mGroupFile.version(), term, position);
            }
            return true;
        }
        catch (IOException e) {
            this.uncaught(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean syncCommitReply(Channel from, long groupVersion, long term, long position) {
        block12: {
            long durablePosition;
            this.checkGroupVersion(groupVersion);
            this.acquireExclusive();
            try {
                TermLog termLog;
                if (this.mConsensusPeers.length == 0 || (termLog = this.mStateLog.termLogAt(position)) == null || term != termLog.term()) {
                    boolean bl = true;
                    return bl;
                }
                Peer peer = from.peer();
                long syncMatchPosition = peer.mSyncMatchPosition;
                if (position > syncMatchPosition) {
                    peer.mSyncMatchPosition = position;
                }
                Arrays.sort(this.mConsensusPeers, (a, b) -> Long.compare(a.mSyncMatchPosition, b.mSyncMatchPosition));
                durablePosition = this.mConsensusPeers[this.mConsensusPeers.length >> 1].mSyncMatchPosition;
            }
            finally {
                this.releaseExclusive();
            }
            try {
                if (!this.mStateLog.commitDurable(durablePosition)) break block12;
                this.acquireExclusive();
                try {
                    this.mSyncCommitCondition.signalAll(this);
                }
                finally {
                    this.releaseExclusive();
                }
            }
            catch (IOException e) {
                this.uncaught(e);
            }
        }
        return true;
    }

    @Override
    public boolean compact(Channel from, long position) {
        from.peer().updateCompactPosition(position);
        return true;
    }

    @Override
    public boolean snapshotScore(Channel from) {
        if (!this.mChanMan.hasSnapshotRequestAcceptor()) {
            from.snapshotScoreReply(null, Integer.MAX_VALUE, Float.POSITIVE_INFINITY);
            return true;
        }
        this.acquireShared();
        int sessionCount = this.mSnapshotSessionCount;
        int mode = this.mLocalMode;
        this.releaseShared();
        from.snapshotScoreReply(null, sessionCount, mode == 2 ? 1.0f : -1.0f);
        return true;
    }

    @Override
    public boolean snapshotScoreReply(Channel from, int activeSessions, float weight) {
        from.peer().snapshotScoreReply(activeSessions, weight);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean updateRole(Channel from, long groupVersion, long memberId, Role role) {
        block19: {
            message = null;
            this.acquireShared();
            try {
                givenVersion = groupVersion;
                groupVersion = this.mGroupFile.version();
                acceptor = this.mControlMessageAcceptor;
                if (acceptor == null) {
                    result = 2;
                    break block19;
                }
                if (this.mLocalMode != 2) {
                    result = 9;
                    break block19;
                }
                if (givenVersion != groupVersion) {
                    result = 6;
                    break block19;
                }
                key = new Peer(memberId);
                peer = this.mGroupFile.allPeers().ceiling(key);
                if (peer == null || peer.mMemberId != memberId) {
                    result = 3;
                    break block19;
                }
                currentRole = peer.role();
                if (currentRole == role) {
                    result = 0;
                    break block19;
                }
                message = this.mGroupFile.proposeUpdateRole((byte)2, memberId, role);
                if (currentRole.providesConsensus() == role.providesConsensus()) ** GOTO lbl-1000
                count = 0;
                for (Peer cp : this.mConsensusPeers) {
                    if (cp.mGroupVersion != groupVersion) continue;
                    ++count;
                }
                if (count < this.mConsensusPeers.length + 1 >> 1) {
                    message = null;
                    result = 7;
                    for (Channel channel : this.mCandidateChannels) {
                        channel.groupVersion(this, groupVersion);
                    }
                } else lbl-1000:
                // 2 sources

                {
                    result = 0;
                }
            }
            finally {
                this.releaseShared();
            }
        }
        if (this.registerControlMessage(message)) {
            fmessage = message;
            this.mScheduler.execute((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$updateRole$10(java.util.function.Consumer byte[] ), ()V)((Controller)this, acceptor, fmessage));
        }
        from.updateRoleReply(null, groupVersion, memberId, (byte)result);
        return true;
    }

    @Override
    public boolean updateRoleReply(Channel from, long groupVersion, long memberId, byte result) {
        boolean versionOk = this.checkGroupVersion(groupVersion);
        if (result != 0) {
            this.acquireShared();
            Role desiredRole = this.desiredRole();
            this.releaseShared();
            if (!(desiredRole == null || result == 6 && versionOk)) {
                this.event(ErrorCodes.typeFor(result), "Unable to update role: " + ErrorCodes.toString(result));
            }
        }
        return true;
    }

    @Override
    public boolean groupVersion(Channel from, long groupVersion) {
        from.peer().updateGroupVersion(groupVersion);
        from.groupVersionReply(null, this.mGroupFile.version());
        return true;
    }

    @Override
    public boolean groupVersionReply(Channel from, long groupVersion) {
        from.peer().updateGroupVersion(groupVersion);
        return true;
    }

    @Override
    public boolean groupFile(Channel from, long groupVersion) throws IOException {
        if (groupVersion < this.mGroupFile.version()) {
            from.groupFileReply(null, null, out -> {
                try {
                    this.mGroupFile.writeTo((OutputStream)out);
                }
                catch (IOException e) {
                    Utils.rethrow(e);
                }
            });
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean groupFileReply(Channel from, InputStream in, Consumer<OutputStream> unused) throws IOException {
        Channel requestChannel;
        boolean refresh;
        if (in == null || unused != null) {
            throw new IllegalArgumentException();
        }
        this.acquireExclusive();
        try {
            refresh = this.mGroupFile.readFrom(in);
            if (refresh) {
                this.refreshPeerSet();
            }
        }
        finally {
            this.releaseExclusive();
        }
        if (refresh && (requestChannel = this.leaderRequestChannel()) != null && requestChannel != this) {
            requestChannel.groupVersion(this, this.mGroupFile.version());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean leaderCheck(Channel from) {
        long term;
        this.acquireShared();
        try {
            term = this.mElectionValidated <= 0 ? -1L : this.mStateLog.captureHighest().mTerm;
        }
        finally {
            this.releaseShared();
        }
        from.leaderCheckReply(null, term);
        return true;
    }

    @Override
    public boolean leaderCheckReply(Channel from, long term) {
        from.peer().mLeaderCheck = term;
        return true;
    }

    private boolean checkGroupVersion(long groupVersion) {
        if (groupVersion > this.mGroupFile.version()) {
            Channel requestChannel = this.leaderRequestChannel();
            if (requestChannel != null && requestChannel != this) {
                try {
                    requestChannel.groupFile(this, this.mGroupFile.version());
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
        return true;
    }

    private /* synthetic */ void lambda$updateRole$10(Consumer acceptor, byte[] fmessage) {
        try {
            acceptor.accept(fmessage);
        }
        finally {
            this.unregisterControlMessage(fmessage);
        }
    }

    private /* synthetic */ void lambda$doRequestJoin$5(byte[] message, Socket s) {
        if (this.mGroupFile.discardProposeConsumer(message)) {
            Utils.closeQuietly(s);
        }
    }

    private static /* synthetic */ void lambda$doRequestJoin$4(OutputStream out, Boolean success) {
        try {
            byte[] reply = success != false ? new byte[]{6} : new byte[]{1, 6};
            out.write(reply);
        }
        catch (IOException iOException) {
        }
        finally {
            Utils.closeQuietly(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$doRequestJoin$3(OutputStream out, InputStream gfIn, long position) {
        try {
            if (gfIn == null) {
                out.write(new byte[]{1, 6});
                return;
            }
            TermLog termLog = this.mStateLog.termLogAt(position);
            byte[] buf = new byte[1000];
            int off = 0;
            buf[off++] = 3;
            Utils.encodeLongLE(buf, off, termLog.prevTermAt(position));
            Utils.encodeLongLE(buf, off += 8, termLog.term());
            Utils.encodeLongLE(buf, off += 8, position);
            off += 8;
            while (true) {
                int amt;
                try {
                    amt = gfIn.read(buf, off, buf.length - off);
                }
                catch (IOException e) {
                    this.uncaught(e);
                    Utils.closeQuietly(out);
                    return;
                }
                if (amt < 0) {
                    break;
                }
                out.write(buf, 0, off + amt);
                off = 0;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            Utils.closeQuietly(out);
        }
    }

    final class ReplWriter
    implements StreamReplicator.Writer {
        private static final long PROXY_LIMIT = 10000000L;
        private final LogWriter mWriter;
        private Channel[] mPeerChannels;
        private boolean mSelfCommit;
        private Channel[] mProxyChannels;
        private int mProxy;
        private long mWriteAmount;
        private static final int DEACTIVATED = 1;
        private static final int DEACTIVATE_EXPLICIT = 2;
        private static final int DEACTIVATE_STALLED = 3;
        private int mDeactivated;
        private String mDeactivateReason;
        volatile Throwable mException;

        ReplWriter(LogWriter writer, Channel[] peerChannels, boolean selfCommit, Channel[] proxyChannels) {
            this.mWriter = writer;
            this.init(peerChannels, selfCommit, proxyChannels);
        }

        @Override
        public long term() {
            return this.mWriter.term();
        }

        @Override
        public long termStartPosition() {
            return this.mWriter.termStartPosition();
        }

        @Override
        public long termEndPosition() {
            return this.mWriter.termEndPosition();
        }

        @Override
        public long position() {
            return this.mWriter.position();
        }

        @Override
        public long commitPosition() {
            return this.mWriter.commitPosition();
        }

        @Override
        public void addCommitListener(LongConsumer listener) {
            this.mWriter.addCommitListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public int write(byte[] prefix, byte[] data, int offset, int length, long highestPosition) throws IOException {
            Channel[] proxyChannels;
            Channel[] peerChannels;
            Channel[] channelArray = this;
            // MONITORENTER : this
            int result = 0;
            if (this.mDeactivated != 0) {
                if (this.mDeactivated == 1) {
                    // MONITOREXIT : channelArray
                    return -1;
                }
                result = -1;
            }
            LogWriter writer = this.mWriter;
            long prevTerm = writer.prevTerm();
            long term = writer.term();
            long position = writer.position();
            try {
            }
            catch (Throwable e) {
                this.mException = e;
                this.fullyDeactivate();
                throw e;
            }
            if ((result += writer.write(prefix, data, offset, length, highestPosition)) < 0) {
                this.fullyDeactivate();
                // MONITOREXIT : channelArray
                return -1;
            }
            Controller.this.mStateLog.captureHighest(writer);
            highestPosition = writer.mHighestPosition;
            if (this.mSelfCommit) {
                Controller.this.mStateLog.commit(highestPosition);
            }
            if ((peerChannels = this.mPeerChannels).length == 0) {
                // MONITOREXIT : channelArray
                return result;
            }
            long commitPosition = writer.mCommitPosition;
            int proxy = this.mProxy;
            if (proxy >= 0) {
                proxyChannels = this.mProxyChannels;
                long writeAmount = this.mWriteAmount + (long)length;
                if (writeAmount < 10000000L) {
                    this.mWriteAmount = writeAmount;
                } else {
                    this.mProxy = proxy = (proxy + 1) % proxyChannels.length;
                    this.mWriteAmount = 0L;
                }
            } else {
                // MONITOREXIT : channelArray
                channelArray = peerChannels;
                int n = channelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Channel peerChan = channelArray[n2];
                    peerChan.writeData(null, prevTerm, term, position, highestPosition, commitPosition, prefix, data, offset, length);
                    ++n2;
                }
                return result;
            }
            // MONITOREXIT : channelArray
            int i = proxyChannels.length;
            while (--i >= 0) {
                Channel peerChan = proxyChannels[proxy];
                if (peerChan.writeDataAndProxy(null, prevTerm, term, position, highestPosition, commitPosition, prefix, data, offset, length)) {
                    return result;
                }
                Channel[] channelArray2 = this;
                // MONITORENTER : this
                proxyChannels = this.mProxyChannels;
                if (proxyChannels == null) {
                    // MONITOREXIT : channelArray2
                    return result;
                }
                this.mProxy = proxy = (proxy + 1) % proxyChannels.length;
                // MONITOREXIT : channelArray2
            }
            return result;
        }

        @Override
        public void uponCommit(long position, LongConsumer task) {
            this.mWriter.uponCommit(position, task);
        }

        @Override
        public long waitForCommit(long position, long nanosTimeout) throws InterruptedIOException {
            return this.mWriter.waitForCommit(position, nanosTimeout);
        }

        @Override
        public long waitForEndCommit(long nanosTimeout) throws InterruptedIOException {
            return this.mWriter.waitForEndCommit(nanosTimeout);
        }

        @Override
        public void close() {
            this.fullyDeactivate();
            Controller.this.writerClosed(this);
        }

        synchronized void update(LogWriter writer, Channel[] peerChannels, boolean selfCommit, Channel[] proxyChannels) {
            if (this.mWriter == writer && this.mDeactivated != 1) {
                this.init(peerChannels, selfCommit, proxyChannels);
            }
        }

        private void init(Channel[] peerChannels, boolean selfCommit, Channel[] proxyChannels) {
            this.mPeerChannels = peerChannels;
            this.mSelfCommit = selfCommit;
            if (proxyChannels == null || proxyChannels.length == 0) {
                this.mProxyChannels = null;
                this.mProxy = -1;
            } else {
                this.mProxyChannels = proxyChannels;
                this.mProxy = 0;
            }
        }

        boolean deactivateExplicit() {
            return this.deactivate(2, null);
        }

        boolean deactivateStalled(String message) {
            return this.deactivate(3, message);
        }

        private synchronized boolean deactivate(int mode, String reason) {
            if (this.mDeactivated == 1) {
                return false;
            }
            this.mDeactivated = mode;
            this.mDeactivateReason = reason;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fullyDeactivate() {
            int deactivated;
            ReplWriter replWriter = this;
            synchronized (replWriter) {
                deactivated = this.mDeactivated;
                this.mDeactivated = 1;
                this.mSelfCommit = false;
            }
            if (deactivated == 2) {
                Controller.this.doFailover(this, false);
            } else if (deactivated == 3) {
                Controller.this.toFollower(this, this.mDeactivateReason);
            }
        }
    }

    final class Sender
    extends SocketSnapshotSender {
        boolean mClosed;

        Sender(Socket socket) throws IOException {
            super(Controller.this.mGroupFile, socket);
            Controller.this.adjustSnapshotSessionCount(this, 1);
        }

        @Override
        public void close() throws IOException {
            Controller.this.adjustSnapshotSessionCount(this, -1);
            super.close();
        }

        @Override
        TermLog termLogAt(long position) {
            return Controller.this.mStateLog.termLogAt(position);
        }
    }
}

