/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.cojen.tupl.io.Utils;

class DecodingInputStream
extends ByteArrayInputStream {
    DecodingInputStream(byte[] data) {
        super(data);
    }

    public int decodeIntLE() {
        int value = Utils.decodeIntLE(this.buf, this.pos);
        this.pos += 4;
        return value;
    }

    public long decodeLongLE() {
        long value = Utils.decodeLongLE(this.buf, this.pos);
        this.pos += 8;
        return value;
    }

    public String decodeStr() {
        int len = this.decodeIntLE();
        byte[] bytes = Arrays.copyOfRange(this.buf, this.pos, this.pos += len);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public Map<String, String> decodeMap() {
        int size = this.decodeIntLE();
        if (size == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        while (--size >= 0) {
            map.put(this.decodeStr(), this.decodeStr());
        }
        return map;
    }
}

