/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import org.cojen.tupl.io.Utils;

class EncodingOutputStream
extends ByteArrayOutputStream {
    protected Writer mWriter;

    EncodingOutputStream() {
    }

    EncodingOutputStream(int size) {
        super(size);
    }

    public void encodeIntLE(int value) {
        int pos = this.count;
        if (pos + 4 > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, this.buf.length << 1);
        }
        Utils.encodeIntLE(this.buf, pos, value);
        this.count = pos + 4;
    }

    public void encodeLongLE(long value) {
        int pos = this.count;
        if (pos + 8 > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, this.buf.length << 1);
        }
        Utils.encodeLongLE(this.buf, pos, value);
        this.count = pos + 8;
    }

    public void encodeStr(String str) {
        try {
            Writer writer = this.mWriter;
            if (writer == null) {
                this.mWriter = writer = new OutputStreamWriter((OutputStream)this, StandardCharsets.UTF_8);
            }
            this.encodeIntLE(str.length());
            writer.write(str);
            writer.flush();
        }
        catch (IOException e) {
            throw Utils.rethrow(e);
        }
    }

    public void encodeMap(Map<String, String> map) {
        this.encodeIntLE(map.size());
        for (Map.Entry<String, String> e : map.entrySet()) {
            this.encodeStr(e.getKey());
            this.encodeStr(e.getValue());
        }
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (this.mWriter != null) {
            this.mWriter.flush();
        }
        super.writeTo(out);
    }

    protected final void defaultWriteTo(OutputStream out) throws IOException {
        super.writeTo(out);
    }
}

