/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

import org.cojen.tupl.diag.EventType;

final class ErrorCodes {
    static final byte SUCCESS = 0;
    static final byte UNKNOWN_OPERATION = 1;
    static final byte NO_ACCEPTOR = 2;
    static final byte UNKNOWN_MEMBER = 3;
    static final byte UNCONNECTED_MEMBER = 4;
    static final byte INVALID_ADDRESS = 5;
    static final byte VERSION_MISMATCH = 6;
    static final byte NO_CONSENSUS = 7;
    static final byte NO_LEADER = 8;
    static final byte NOT_LEADER = 9;

    ErrorCodes() {
    }

    static String toString(byte errorCode) {
        return switch (errorCode) {
            default -> "unknown error: " + errorCode;
            case 0 -> "success";
            case 1 -> "unknown operation";
            case 2 -> "no acceptor";
            case 3 -> "unknown member";
            case 5 -> "invalid address";
            case 4 -> "unconnected member";
            case 6 -> "group version mismatch";
            case 7 -> "no consensus";
            case 8 -> "no leader";
            case 9 -> "not leader";
        };
    }

    static EventType typeFor(byte errorCode) {
        return switch (errorCode) {
            default -> EventType.REPLICATION_PANIC;
            case 6, 7, 8, 9 -> EventType.REPLICATION_WARNING;
            case 0 -> EventType.REPLICATION_INFO;
        };
    }
}

