/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.zip.CRC32C;
import java.util.zip.Checksum;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.repl.CommitConflictException;
import org.cojen.tupl.repl.FileTermLog;
import org.cojen.tupl.repl.InvalidReadException;
import org.cojen.tupl.repl.LKey;
import org.cojen.tupl.repl.LogInfo;
import org.cojen.tupl.repl.LogReader;
import org.cojen.tupl.repl.LogWriter;
import org.cojen.tupl.repl.PositionRange;
import org.cojen.tupl.repl.StateLog;
import org.cojen.tupl.repl.TermLog;
import org.cojen.tupl.repl.TermQuery;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.Worker;

final class FileStateLog
extends Latch
implements StateLog {
    private static final long MAGIC_NUMBER = 5267718596810043313L;
    private static final int ENCODING_VERSION = 20171004;
    private static final int SECTION_POW = 12;
    private static final int SECTION_SIZE = 4096;
    private static final int METADATA_SIZE = 68;
    private static final int METADATA_FILE_SIZE = 4164;
    private static final int COUNTER_OFFSET = 12;
    private static final int CURRENT_TERM_OFFSET = 16;
    private static final int HIGHEST_PREV_TERM_OFFSET = 32;
    private static final int CRC_OFFSET = 64;
    private final File mBase;
    private final Worker mWorker;
    private final FileTermLog.Caches mCaches;
    private final ConcurrentSkipListSet<LKey<TermLog>> mTermLogs;
    private final FileChannel mMetadataFile;
    private final FileLock mMetadataLock;
    private final MappedByteBuffer mMetadataBuffer;
    private final Checksum mMetadataCrc;
    private final LogInfo mMetadataInfo;
    private final Latch mMetadataLatch;
    private int mMetadataCounter;
    private long mMetadataHighestPosition;
    private volatile long mMetadataDurablePosition;
    private long mCurrentTerm;
    private long mVotedForId;
    private TermLog mHighestTermLog;
    private TermLog mCommitTermLog;
    private TermLog mContigTermLog;
    private boolean mClosed;

    static FileStateLog open(File base) throws IOException {
        return new FileStateLog(FileTermLog.checkBase(base));
    }

    /*
     * Unable to fully structure code
     */
    private FileStateLog(File base) throws IOException {
        block24: {
            super();
            this.mBase = base;
            this.mWorker = Worker.make(10, 15L, TimeUnit.SECONDS, null);
            this.mCaches = new FileTermLog.Caches();
            this.mTermLogs = new ConcurrentSkipListSet<E>();
            this.mMetadataInfo = new LogInfo();
            this.mMetadataLatch = new Latch();
            this.mMetadataFile = FileChannel.open(base.toPath(), new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.DSYNC});
            try {
                this.mMetadataLock = this.mMetadataFile.tryLock();
            }
            catch (OverlappingFileLockException e) {
                Utils.closeQuietly(this.mMetadataFile);
                throw new IOException("Replicator is already open by current process");
            }
            if (this.mMetadataLock == null) {
                Utils.closeQuietly(this.mMetadataFile);
                throw new IOException("Replicator is open and locked by another process");
            }
            mdFileExists = this.mMetadataFile.size() != 0L;
            this.mMetadataBuffer = this.mMetadataFile.map(FileChannel.MapMode.READ_WRITE, 0L, 4164L);
            this.mMetadataBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.mMetadataCrc = new CRC32C();
            if (!mdFileExists) {
                this.cleanMetadata(0, 0);
                this.cleanMetadata(4096, 1);
            }
            try {
                this.mMetadataBuffer.force();
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
            counter0 = this.verifyMetadata(0);
            counter1 = this.verifyMetadata(4096);
            if (counter0 >= 0L) break block24;
            if (counter1 < 0L) {
                if (counter0 == -1L || counter1 == -1L) {
                    throw new IOException("Metadata magic number is wrong");
                }
                throw new IOException("Metadata CRC mismatch");
            }
            ** GOTO lbl-1000
        }
        if (counter1 < 0L || (int)counter0 - (int)counter1 > 0) {
            counter = (int)counter0;
            offset = 0;
        } else lbl-1000:
        // 2 sources

        {
            counter = (int)counter1;
            offset = 4096;
        }
        if ((counter & 1) << 12 != offset) {
            throw new IOException("Metadata sections are swapped");
        }
        this.mMetadataCounter = counter;
        this.mMetadataBuffer.clear();
        this.mMetadataBuffer.position(offset + 16);
        currentTerm = this.mMetadataBuffer.getLong();
        votedForId = this.mMetadataBuffer.getLong();
        highestPrevTerm = this.mMetadataBuffer.getLong();
        highestTerm = this.mMetadataBuffer.getLong();
        highestPosition = this.mMetadataBuffer.getLong();
        durablePosition = this.mMetadataBuffer.getLong();
        if (currentTerm < highestTerm) {
            throw new IOException("Current term is lower than highest term: " + currentTerm + " < " + highestTerm);
        }
        if (highestPosition < durablePosition) {
            throw new IOException("Highest position is lower than durable position: " + highestPosition + " < " + durablePosition);
        }
        this.mMetadataInfo.mTerm = highestTerm;
        this.mMetadataInfo.mHighestPosition = highestPosition;
        this.mMetadataInfo.mCommitPosition = durablePosition;
        this.mMetadataHighestPosition = highestPosition;
        this.mMetadataDurablePosition = durablePosition;
        this.mCurrentTerm = currentTerm;
        this.mVotedForId = votedForId;
        termFileNames = new TreeMap<Long, ArrayList<String>>();
        parentFile = this.mBase.getParentFile();
        fileNames = parentFile.list();
        if (fileNames != null && fileNames.length != 0) {
            p = Pattern.compile(base.getName() + "\\.(\\d+)\\.\\d+(?:\\.\\d+)?");
            for (String name : fileNames) {
                m = p.matcher(name);
                if (!m.matches()) continue;
                term = Long.parseLong(m.group(1));
                if (term <= 0L) {
                    throw new IOException("Illegal term: " + term);
                }
                if (term > highestTerm) {
                    new File(parentFile, name).delete();
                    continue;
                }
                termNames = (ArrayList<String>)termFileNames.get(term);
                if (termNames == null) {
                    termNames = new ArrayList<String>();
                    termFileNames.put(term, termNames);
                }
                termNames.add(name);
            }
        }
        prevTerm = -1L;
        for (Map.Entry<K, V> e : termFileNames.entrySet()) {
            term = (Long)e.getKey();
            termLog = FileTermLog.openTerm(this.mCaches, this.mWorker, this.mBase, prevTerm, term, -1L, 0L, highestPosition, (List)e.getValue());
            this.mTermLogs.add(termLog);
            prevTerm = term;
        }
        if (!this.mTermLogs.isEmpty()) {
            it = this.mTermLogs.iterator();
            termLog = (TermLog)it.next();
            while ((next = it.hasNext() != false ? (TermLog)it.next() : null) != null) {
                if (next.term() <= highestTerm) {
                    termLog.finishTerm(next.startPosition());
                }
                termLog = next;
            }
        }
        if (this.mTermLogs.isEmpty()) {
            this.mTermLogs.add(FileTermLog.newTerm(this.mCaches, this.mWorker, this.mBase, highestPrevTerm, highestTerm, highestPosition, durablePosition));
        }
        if (durablePosition > 0L) {
            this.commit(durablePosition);
        }
    }

    private void cleanMetadata(int offset, int counter) {
        MappedByteBuffer bb = this.mMetadataBuffer;
        bb.clear();
        bb.position(offset);
        bb.limit(offset + 68);
        bb.putLong(5267718596810043313L);
        bb.putInt(20171004);
        bb.putInt(counter);
        if (bb.position() != offset + 16) {
            throw new AssertionError();
        }
        for (int i = 0; i < 6; ++i) {
            bb.putLong(0L);
        }
        if (bb.position() != offset + 64) {
            throw new AssertionError();
        }
        bb.limit(bb.position());
        bb.position(offset);
        this.mMetadataCrc.reset();
        this.mMetadataCrc.update(bb);
        bb.limit(offset + 68);
        bb.putInt((int)this.mMetadataCrc.getValue());
    }

    private long verifyMetadata(int offset) throws IOException {
        MappedByteBuffer bb = this.mMetadataBuffer;
        bb.clear();
        bb.position(offset);
        bb.limit(offset + 64);
        if (bb.getLong() != 5267718596810043313L) {
            return -1L;
        }
        bb.position(offset);
        this.mMetadataCrc.reset();
        this.mMetadataCrc.update(bb);
        bb.limit(offset + 68);
        int actual = bb.getInt();
        if (actual != (int)this.mMetadataCrc.getValue()) {
            return -2L;
        }
        bb.clear();
        bb.position(offset + 8);
        bb.limit(offset + 64);
        int encoding = bb.getInt();
        if (encoding != 20171004) {
            throw new IOException("Metadata encoding version is unknown: " + encoding);
        }
        return (long)bb.getInt() & 0xFFFFFFFFL;
    }

    @Override
    public TermLog captureHighest(LogInfo info) {
        this.acquireShared();
        return this.doCaptureHighest(info, true);
    }

    private TermLog doCaptureHighest(LogInfo info, boolean releaseLatch) {
        TermLog highestLog = this.mHighestTermLog;
        if (highestLog == null) {
            if (this.mTermLogs.isEmpty()) {
                info.mTerm = 0L;
                info.mHighestPosition = 0L;
                info.mCommitPosition = 0L;
                if (releaseLatch) {
                    this.releaseShared();
                }
                return null;
            }
            highestLog = (TermLog)this.mTermLogs.first();
        }
        while (true) {
            TermLog nextLog = (TermLog)this.mTermLogs.higher(highestLog);
            highestLog.captureHighest(info);
            if (nextLog == null || info.mHighestPosition < nextLog.startPosition()) {
                if (highestLog != this.mHighestTermLog && this.tryUpgrade()) {
                    this.mHighestTermLog = highestLog;
                    if (releaseLatch) {
                        this.releaseExclusive();
                    } else {
                        this.downgrade();
                    }
                } else if (releaseLatch) {
                    this.releaseShared();
                }
                return highestLog;
            }
            highestLog = nextLog;
        }
    }

    @Override
    public void commit(long commitPosition) {
        TermLog highestLog;
        this.acquireShared();
        if (this.mCommitTermLog != null) {
            this.mCommitTermLog.commit(commitPosition);
            this.releaseShared();
            return;
        }
        if (this.mTermLogs.isEmpty()) {
            this.releaseShared();
            return;
        }
        Iterator<LKey<TermLog>> it = this.mTermLogs.descendingIterator();
        TermLog termLog = highestLog = (TermLog)it.next();
        while (true) {
            termLog.commit(commitPosition);
            if (!it.hasNext()) {
                if (termLog == highestLog) break;
                this.releaseShared();
                return;
            }
            TermLog lowerLog = (TermLog)it.next();
            if (termLog == highestLog && lowerLog.isFinished()) break;
            termLog = lowerLog;
        }
        if (this.tryUpgrade()) {
            this.mCommitTermLog = highestLog;
            this.releaseExclusive();
        } else {
            this.releaseShared();
        }
    }

    @Override
    public long potentialCommitPosition() {
        this.acquireShared();
        try {
            long l = this.mTermLogs.isEmpty() ? 0L : ((TermLog)this.mTermLogs.last()).potentialCommitPosition();
            return l;
        }
        finally {
            this.releaseShared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long incrementCurrentTerm(int termIncrement, long candidateId) throws IOException {
        if (termIncrement <= 0) {
            throw new IllegalArgumentException();
        }
        this.mMetadataLatch.acquireExclusive();
        try {
            this.mCurrentTerm += (long)termIncrement;
            this.mVotedForId = candidateId;
            this.doSync();
            long l = this.mCurrentTerm;
            return l;
        }
        finally {
            this.mMetadataLatch.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long checkCurrentTerm(long term) throws IOException {
        this.mMetadataLatch.acquireExclusive();
        try {
            if (term > this.mCurrentTerm) {
                this.mCurrentTerm = term;
                this.mVotedForId = 0L;
                this.doSync();
            }
            long l = this.mCurrentTerm;
            return l;
        }
        finally {
            this.mMetadataLatch.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCandidate(long candidateId) throws IOException {
        this.mMetadataLatch.acquireExclusive();
        try {
            if (this.mVotedForId == candidateId) {
                boolean bl = true;
                return bl;
            }
            if (this.mVotedForId == 0L) {
                this.mVotedForId = candidateId;
                this.doSync();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.mMetadataLatch.releaseExclusive();
        }
    }

    @Override
    public void compact(long position) throws IOException {
        TermLog termLog;
        Iterator<LKey<TermLog>> it = this.mTermLogs.iterator();
        while (it.hasNext() && (termLog = (TermLog)it.next()).compact(position)) {
            termLog.close();
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateAll(long prevTerm, long term, long position) throws IOException {
        this.mMetadataLatch.acquireExclusive();
        try {
            TermLog highestLog;
            if (this.mClosed) {
                throw new IOException("Closed");
            }
            this.acquireExclusive();
            try {
                this.compact(Long.MAX_VALUE);
                highestLog = FileTermLog.newTerm(this.mCaches, this.mWorker, this.mBase, prevTerm, term, position, position);
                this.mTermLogs.add(highestLog);
            }
            finally {
                this.releaseExclusive();
            }
            this.mMetadataInfo.mTerm = term;
            this.mMetadataInfo.mHighestPosition = position;
            this.mMetadataInfo.mCommitPosition = position;
            this.mMetadataHighestPosition = position;
            this.mMetadataDurablePosition = position;
            this.syncMetadata(highestLog);
        }
        finally {
            this.mMetadataLatch.releaseExclusive();
        }
    }

    @Override
    public boolean defineTerm(long prevTerm, long term, long position) throws IOException {
        return this.defineTermLog(prevTerm, term, position) != null;
    }

    @Override
    public TermLog termLogAt(long position) {
        TermLog term = this.tryTermLogAt(position);
        if (term == null) {
            this.acquireShared();
            term = this.tryTermLogAt(position);
            this.releaseShared();
        }
        return term;
    }

    private TermLog tryTermLogAt(long position) {
        return (TermLog)((Object)this.mTermLogs.floor(new LKey.Finder(position)));
    }

    @Override
    public void queryTerms(long startPosition, long endPosition, TermQuery results) {
        if (startPosition >= endPosition) {
            return;
        }
        LKey startKey = new LKey.Finder(startPosition);
        LKey.Finder endKey = new LKey.Finder(endPosition);
        LKey prev = this.mTermLogs.floor(startKey);
        if (prev != null && ((TermLog)prev).endPosition() > startPosition) {
            startKey = prev;
        }
        for (Object key : this.mTermLogs.subSet((Object)startKey, (Object)endKey)) {
            TermLog termLog = (TermLog)key;
            results.term(termLog.prevTerm(), termLog.term(), termLog.startPosition());
        }
    }

    @Override
    public long checkForMissingData(long contigPosition, PositionRange results) {
        TermLog nextLog;
        this.acquireShared();
        TermLog termLog = this.mContigTermLog;
        if (termLog == null) {
            if (this.mTermLogs.isEmpty()) {
                this.releaseShared();
                return 0L;
            }
            termLog = (TermLog)this.mTermLogs.first();
        }
        long originalContigPosition = contigPosition;
        while (true) {
            nextLog = (TermLog)this.mTermLogs.higher(termLog);
            if ((contigPosition = termLog.checkForMissingData(contigPosition, results)) < termLog.endPosition() || nextLog == null) break;
            termLog = nextLog;
        }
        if (termLog != this.mContigTermLog && this.tryUpgrade()) {
            this.mContigTermLog = termLog;
            if (nextLog == null) {
                this.releaseExclusive();
                return contigPosition;
            }
            this.downgrade();
        }
        if (contigPosition == originalContigPosition) {
            while (nextLog != null) {
                nextLog.checkForMissingData(0L, results);
                nextLog = (TermLog)this.mTermLogs.higher(nextLog);
            }
        }
        this.releaseShared();
        return contigPosition;
    }

    @Override
    public LogWriter openWriter(long prevTerm, long term, long position) throws IOException {
        TermLog termLog = this.defineTermLog(prevTerm, term, position);
        return termLog == null ? null : termLog.openWriter(position);
    }

    /*
     * Exception decompiling
     */
    TermLog defineTermLog(long prevTerm, long term, long position) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TermLog fixTermRef(TermLog termLog) {
        return termLog == null ? null : (TermLog)this.mTermLogs.floor(termLog);
    }

    private boolean checkCommitConflict(TermLog termLog, long position) throws CommitConflictException {
        if (termLog.hasPotentialCommit(position)) {
            if (this.mClosed) {
                return true;
            }
            if (!termLog.tryRollbackCommit(position)) {
                LogInfo termInfo = new LogInfo();
                termLog.captureHighest(termInfo);
                long durablePosition = this.mMetadataDurablePosition;
                throw new CommitConflictException(position, termInfo, durablePosition);
            }
        }
        return false;
    }

    private int acquireFullLatch(int state) {
        if (state == 0) {
            if (this.tryUpgrade()) {
                if (this.mMetadataLatch.tryAcquireExclusive()) {
                    return 1;
                }
                this.releaseExclusive();
            } else {
                this.releaseShared();
            }
            this.mMetadataLatch.acquireExclusive();
            try {
                this.acquireExclusive();
            }
            catch (Throwable e) {
                this.mMetadataLatch.releaseExclusive();
                throw e;
            }
            return -1;
        }
        return 1;
    }

    private void releaseFullLatch(int state) {
        if (state == 0) {
            this.releaseShared();
        } else {
            this.mMetadataLatch.releaseExclusive();
            this.releaseExclusive();
        }
    }

    @Override
    public LogReader openReader(long position) {
        LKey.Finder key = new LKey.Finder(position);
        this.acquireShared();
        try {
            if (this.mClosed) {
                throw new IllegalStateException("Closed");
            }
            TermLog termLog = (TermLog)((Object)this.mTermLogs.floor(key));
            if (termLog != null) {
                LogReader logReader = termLog.openReader(position);
                return logReader;
            }
            termLog = (TermLog)this.mTermLogs.first();
            throw new InvalidReadException("Position is lower than start position: " + position + " < " + termLog.startPosition());
        }
        finally {
            this.releaseShared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadable(long position) {
        LKey.Finder key = new LKey.Finder(position);
        this.acquireShared();
        try {
            if (this.mClosed) {
                throw new IllegalStateException("Closed");
            }
            TermLog termLog = (TermLog)((Object)this.mTermLogs.floor(key));
            boolean bl = termLog != null && termLog.isReadable(position);
            return bl;
        }
        finally {
            this.releaseShared();
        }
    }

    @Override
    public void sync() throws IOException {
        this.mMetadataLatch.acquireExclusive();
        try {
            this.doSync();
        }
        finally {
            this.mMetadataLatch.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long syncCommit(long prevTerm, long term, long position) throws IOException {
        this.mMetadataLatch.acquireExclusive();
        try {
            TermLog highestLog;
            if (this.mClosed) {
                throw new IOException("Closed");
            }
            this.acquireShared();
            try {
                TermLog termLog = this.tryTermLogAt(position);
                if (termLog == null || term != termLog.term() || prevTerm != termLog.prevTermAt(position)) {
                    long l = -1L;
                    return l;
                }
                highestLog = this.doCaptureHighest(this.mMetadataInfo, false);
                if (position > this.mMetadataInfo.mHighestPosition) {
                    long l = -1L;
                    return l;
                }
                if (position <= this.mMetadataHighestPosition) {
                    long l = this.mMetadataInfo.mCommitPosition;
                    return l;
                }
                highestLog.sync();
            }
            finally {
                this.releaseShared();
            }
            this.syncMetadata(highestLog);
            long l = this.mMetadataInfo.mCommitPosition;
            return l;
        }
        finally {
            this.mMetadataLatch.releaseExclusive();
        }
    }

    @Override
    public boolean isDurable(long position) {
        this.mMetadataLatch.acquireShared();
        boolean result = position <= this.mMetadataDurablePosition;
        this.mMetadataLatch.releaseShared();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitDurable(long position) throws IOException {
        this.mMetadataLatch.acquireExclusive();
        try {
            if (this.mClosed) {
                throw new IOException("Closed");
            }
            if (position <= this.mMetadataDurablePosition) {
                boolean bl = false;
                return bl;
            }
            FileStateLog.checkDurable(position, this.mMetadataHighestPosition);
            FileStateLog.checkDurable(position, this.mMetadataInfo.mCommitPosition);
            this.syncMetadata(null, position);
            boolean bl = true;
            return bl;
        }
        finally {
            this.mMetadataLatch.releaseExclusive();
        }
    }

    private static void checkDurable(long position, long highestPosition) {
        if (position > highestPosition) {
            throw new IllegalStateException("Commit position is too high: " + position + " > " + highestPosition);
        }
    }

    private void doSync() throws IOException {
        TermLog highestLog;
        if (this.mClosed) {
            return;
        }
        this.acquireShared();
        try {
            highestLog = this.doCaptureHighest(this.mMetadataInfo, false);
            if (highestLog != null) {
                highestLog.sync();
            }
        }
        finally {
            this.releaseShared();
        }
        this.syncMetadata(highestLog);
    }

    private void syncMetadata(TermLog highestLog) throws IOException {
        this.syncMetadata(highestLog, -1L);
    }

    private void syncMetadata(TermLog highestLog, long durablePosition) throws IOException {
        long highestPosition;
        long highestTerm;
        long highestPrevTerm;
        boolean durableOnly;
        if (this.mClosed) {
            return;
        }
        if (durablePosition >= 0L) {
            durableOnly = true;
        } else {
            durablePosition = this.mMetadataDurablePosition;
            durableOnly = false;
        }
        if (this.mMetadataInfo.mHighestPosition < durablePosition) {
            throw new IllegalStateException("Highest position is lower than durable position: " + this.mMetadataInfo.mHighestPosition + " < " + durablePosition);
        }
        MappedByteBuffer bb = this.mMetadataBuffer;
        int counter = this.mMetadataCounter;
        if (durableOnly) {
            bb.position(((counter & 1) << 12) + 32);
            highestPrevTerm = bb.getLong();
            highestTerm = bb.getLong();
            highestPosition = bb.getLong();
        } else {
            highestTerm = this.mMetadataInfo.mTerm;
            highestPosition = this.mMetadataInfo.mHighestPosition;
            highestPrevTerm = highestLog == null ? highestTerm : highestLog.prevTermAt(highestPosition);
        }
        int offset = (++counter & 1) << 12;
        bb.clear();
        bb.position(offset + 12);
        bb.limit(offset + 64);
        bb.putInt(counter);
        bb.putLong(this.mCurrentTerm);
        bb.putLong(this.mVotedForId);
        bb.putLong(highestPrevTerm);
        bb.putLong(highestTerm);
        bb.putLong(highestPosition);
        bb.putLong(durablePosition);
        bb.position(offset);
        this.mMetadataCrc.reset();
        this.mMetadataCrc.update(bb);
        bb.limit(offset + 68);
        bb.putInt((int)this.mMetadataCrc.getValue());
        try {
            bb.force();
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        this.mMetadataCounter = counter;
        if (durableOnly) {
            this.mMetadataDurablePosition = durablePosition;
        } else {
            this.mMetadataHighestPosition = this.mMetadataInfo.mHighestPosition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.mMetadataLatch.acquireExclusive();
        try {
            this.acquireExclusive();
            try {
                if (this.mClosed) {
                    return;
                }
                this.mClosed = true;
                this.mMetadataLock.close();
                this.mMetadataFile.close();
                Utils.delete(this.mMetadataBuffer);
                for (LKey<TermLog> key : this.mTermLogs) {
                    ((TermLog)key).close();
                }
            }
            finally {
                this.releaseExclusive();
            }
        }
        finally {
            this.mMetadataLatch.releaseExclusive();
        }
        Worker worker = this.mWorker;
        synchronized (worker) {
            this.mWorker.join(true);
        }
    }
}

