/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.BiFunction;
import java.util.function.LongConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cojen.tupl.io.FileIO;
import org.cojen.tupl.io.LengthOption;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.repl.CommitCallback;
import org.cojen.tupl.repl.InvalidReadException;
import org.cojen.tupl.repl.LCache;
import org.cojen.tupl.repl.LKey;
import org.cojen.tupl.repl.LogInfo;
import org.cojen.tupl.repl.LogReader;
import org.cojen.tupl.repl.LogWriter;
import org.cojen.tupl.repl.PositionRange;
import org.cojen.tupl.repl.TermLog;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.Parker;
import org.cojen.tupl.util.Worker;

final class FileTermLog
extends Latch
implements TermLog {
    private static final int EOF = -1;
    private static final int WAIT_TERM_END = -1;
    private static final int WAIT_TIMEOUT = -2;
    private static final int MIN_CACHE_SIZE = 10;
    private static final ThreadLocal<CommitWaiter> cLocalWaiter = new ThreadLocal();
    private final Worker mWorker;
    private final File mBase;
    private final long mLogPrevTerm;
    private final long mLogTerm;
    private final long mLogStartPosition;
    private volatile long mLogVersion;
    private long mLogCommitPosition;
    private long mLogHighestPosition;
    private long mLogContigPosition;
    private long mLogEndPosition;
    private final NavigableSet<LKey<Segment>> mSegments;
    private final PriorityQueue<SegmentWriter> mNonContigWriters;
    private final Caches mCaches;
    private LongConsumer[] mCommitListeners;
    private long mLastCommitListenerPos;
    private final PriorityQueue<CommitCallback> mCommitTasks;
    private final Latch mSyncLatch;
    private final Latch mDirtyLatch;
    private Segment mFirstDirty;
    private Segment mLastDirty;
    private boolean mLogClosed;
    static final VarHandle cLogClosedHandle;
    static final VarHandle cWriterPositionHandle;
    static final VarHandle cReaderPositionHandle;
    static final VarHandle cRefCountHandle;
    static final VarHandle cDirtyHandle;

    static TermLog newTerm(Caches caches, Worker worker, File base, long prevTerm, long term, long startPosition, long commitPosition) {
        if (base != null) {
            base = FileTermLog.checkBase(base);
        }
        FileTermLog termLog = new FileTermLog(caches, worker, base, prevTerm, term, startPosition, commitPosition, startPosition, null);
        return termLog;
    }

    static TermLog openTerm(Caches caches, Worker worker, File base, long prevTerm, long term, long startPosition, long commitPosition, long highestPosition, List<String> segmentFileNames) {
        String[] namesArray;
        base = FileTermLog.checkBase(base);
        if (segmentFileNames == null && (namesArray = base.getParentFile().list()) != null && namesArray.length != 0) {
            Pattern p = Pattern.compile(base.getName() + "\\." + term + "\\.\\d+(?:\\.\\d+)?");
            segmentFileNames = new ArrayList<String>();
            for (String name : namesArray) {
                if (!p.matcher(name).matches()) continue;
                segmentFileNames.add(name);
            }
        }
        FileTermLog termLog = new FileTermLog(caches, worker, base, prevTerm, term, startPosition, commitPosition, highestPosition, segmentFileNames);
        return termLog;
    }

    static File checkBase(File base) {
        if ((base = base.getAbsoluteFile()).isDirectory()) {
            throw new IllegalArgumentException("Base file is a directory: " + base);
        }
        if (!base.getParentFile().exists()) {
            throw new IllegalArgumentException("Parent file doesn't exist: " + base);
        }
        return base;
    }

    private FileTermLog(Caches caches, Worker worker, File base, long prevTerm, long term, long startPosition, long commitPosition, long highestPosition, List<String> segmentFileNames) {
        if (term < 0L) {
            throw new IllegalArgumentException("Illegal term: " + term);
        }
        if (commitPosition > highestPosition) {
            throw new IllegalArgumentException("Commit position is higher than highest position: " + commitPosition + " > " + highestPosition);
        }
        this.mWorker = worker;
        this.mBase = base;
        this.mLogTerm = term;
        this.mSegments = new ConcurrentSkipListSet<LKey<Segment>>();
        if (segmentFileNames != null && segmentFileNames.size() != 0) {
            File parent = base.getParentFile();
            Pattern p = Pattern.compile(base.getName() + "\\." + term + "\\.(\\d+)(?:\\.(\\d+))?");
            boolean anyMatches = false;
            for (String name : segmentFileNames) {
                Matcher m = p.matcher(name);
                if (!m.matches()) continue;
                anyMatches = true;
                long start = Long.parseLong(m.group(1));
                String prevTermStr = m.group(2);
                if (prevTermStr != null) {
                    long parsedPrevTerm = Long.parseLong(prevTermStr);
                    if (prevTerm < 0L) {
                        prevTerm = parsedPrevTerm;
                    } else if (prevTerm != parsedPrevTerm) {
                        throw new IllegalStateException("Mismatched previous term: " + prevTerm + " != " + prevTermStr);
                    }
                }
                long maxLength = Math.max(this.maxSegmentLength(), new File(parent, name).length());
                this.mSegments.add(new Segment(start, maxLength));
            }
            if (prevTerm < 0L && anyMatches) {
                prevTerm = term;
            }
        }
        if (prevTerm < 0L) {
            throw new IllegalStateException("Unable to determine previous term");
        }
        if (startPosition == -1L) {
            if (this.mSegments.isEmpty()) {
                throw new IllegalStateException("No segment files exist for term: " + term);
            }
            startPosition = ((Segment)this.mSegments.first()).mStartPosition;
        } else if (startPosition < highestPosition && (this.mSegments.isEmpty() || ((Segment)this.mSegments.first()).mStartPosition > startPosition)) {
            throw new IllegalStateException("Missing start segment: " + startPosition + ", term=" + term);
        }
        this.mLogPrevTerm = prevTerm;
        this.mLogStartPosition = startPosition;
        this.mLogCommitPosition = commitPosition;
        this.mLogHighestPosition = highestPosition;
        this.mLogContigPosition = highestPosition;
        this.mLogEndPosition = Long.MAX_VALUE;
        FileTermLog.forEachSegment(this.mSegments.tailSet(new LKey.Finder(startPosition)), (seg, next) -> {
            File file;
            long segHighest;
            if (seg.mStartPosition >= highestPosition) {
                return false;
            }
            if (next != null && (segHighest = seg.mStartPosition + (file = seg.file()).length()) < highestPosition && segHighest < next.mStartPosition) {
                throw new IllegalStateException("Incomplete segment: " + file);
            }
            return true;
        });
        FileTermLog.forEachSegment(this.mSegments, (seg, next) -> {
            if (next != null && seg.endPosition() > next.mStartPosition && seg.setEndPosition(next.mStartPosition) && seg.file().length() > seg.mMaxLength) {
                try {
                    seg.truncate();
                }
                catch (IOException e) {
                    throw Utils.rethrow(e);
                }
            }
            return true;
        });
        FileTermLog.forEachSegment(this.mSegments, (seg, next) -> {
            if (seg.endPosition() <= this.mLogStartPosition || seg.mStartPosition >= this.mLogHighestPosition) {
                seg.file().delete();
                this.mSegments.remove(seg);
            }
            return true;
        });
        this.mCaches = caches;
        this.mSyncLatch = new Latch();
        this.mDirtyLatch = new Latch();
        this.mNonContigWriters = new PriorityQueue();
        this.mCommitTasks = new PriorityQueue();
    }

    private static void forEachSegment(SortedSet<LKey<Segment>> segments, BiFunction<Segment, Segment, Boolean> pairConsumer) {
        Iterator it = segments.iterator();
        if (it.hasNext()) {
            Segment seg = (Segment)it.next();
            while (true) {
                Segment next;
                if (!pairConsumer.apply(seg, next = it.hasNext() ? (Segment)it.next() : null).booleanValue()) {
                    return;
                }
                if (next == null) break;
                seg = next;
            }
        }
    }

    @Override
    public long prevTerm() {
        return this.mLogPrevTerm;
    }

    @Override
    public long term() {
        return this.mLogTerm;
    }

    @Override
    public long startPosition() {
        return this.mLogStartPosition;
    }

    @Override
    public long prevTermAt(long position) {
        return position <= this.mLogStartPosition ? this.mLogPrevTerm : this.mLogTerm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compact(long startPosition) throws IOException {
        Segment seg;
        long endPosition;
        this.acquireShared();
        boolean full = startPosition >= this.mLogEndPosition;
        this.releaseShared();
        Iterator<LKey<Segment>> it = this.mSegments.iterator();
        while (it.hasNext() && (endPosition = (seg = (Segment)it.next()).endPosition()) <= startPosition) {
            seg.acquireExclusive();
            try {
                seg.close(true);
            }
            finally {
                seg.releaseExclusive();
            }
            File segFile = seg.file();
            if (segFile != null && !segFile.delete() && segFile.exists()) break;
            it.remove();
            this.mCaches.mSegments.remove(seg.cacheKey(), this);
        }
        return full && this.mSegments.isEmpty();
    }

    @Override
    public long potentialCommitPosition() {
        this.acquireShared();
        long position = this.mLogCommitPosition;
        this.releaseShared();
        return position;
    }

    @Override
    public long endPosition() {
        this.acquireShared();
        long position = this.mLogEndPosition;
        this.releaseShared();
        return position;
    }

    @Override
    public void captureHighest(LogInfo info) {
        info.mTerm = this.mLogTerm;
        this.acquireShared();
        this.doCaptureHighest(info);
        this.releaseShared();
    }

    @Override
    public boolean isFinished() {
        this.acquireShared();
        boolean result = this.doAppliableCommitPosition() >= this.mLogEndPosition;
        this.releaseShared();
        return result;
    }

    private void doCaptureHighest(LogInfo info) {
        info.mHighestPosition = this.mLogHighestPosition;
        info.mCommitPosition = this.doAppliableCommitPosition();
    }

    long appliableCommitPosition() {
        this.acquireShared();
        long commitPosition = this.doAppliableCommitPosition();
        this.releaseShared();
        return commitPosition;
    }

    private long doAppliableCommitPosition() {
        return Math.min(this.mLogCommitPosition, this.mLogHighestPosition);
    }

    @Override
    public void commit(long commitPosition) {
        this.acquireExclusive();
        if (commitPosition > this.mLogCommitPosition) {
            long endPosition = this.mLogEndPosition;
            if (commitPosition > endPosition) {
                commitPosition = endPosition;
            }
            this.mLogCommitPosition = commitPosition;
            if (this.mLogHighestPosition < commitPosition) {
                this.mLogHighestPosition = Math.min(commitPosition, this.mLogContigPosition);
            }
            this.notifyCommitTasks(this.doAppliableCommitPosition());
            return;
        }
        this.releaseExclusive();
    }

    void addCommitListener(LongConsumer listener) {
        Objects.requireNonNull(listener);
        this.acquireExclusive();
        if (this.doAppliableCommitPosition() >= this.mLogEndPosition) {
            this.downgrade();
            try {
                listener.accept(this.mLogEndPosition);
                listener.accept(-1L);
            }
            finally {
                this.releaseShared();
            }
            return;
        }
        try {
            this.mCommitListeners = this.mCommitListeners == null ? new LongConsumer[1] : Arrays.copyOf(this.mCommitListeners, this.mCommitListeners.length + 1);
            this.mCommitListeners[this.mCommitListeners.length - 1] = listener;
        }
        finally {
            this.releaseExclusive();
        }
    }

    @Override
    public long waitForCommit(long position, long nanosTimeout) throws InterruptedIOException {
        return this.waitForCommit(position, nanosTimeout, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long waitForCommit(long position, long nanosTimeout, Object waiter) throws InterruptedIOException {
        long endNanos;
        CommitWaiter cwaiter;
        boolean exclusive = false;
        this.acquireShared();
        while (true) {
            long commitPosition;
            if ((commitPosition = this.doAppliableCommitPosition()) >= position) {
                this.release(exclusive);
                return commitPosition;
            }
            if (position > this.mLogEndPosition || this.mLogClosed) {
                this.release(exclusive);
                return -1L;
            }
            if (exclusive || this.tryUpgrade()) break;
            this.releaseShared();
            this.acquireExclusive();
            exclusive = true;
        }
        try {
            cwaiter = cLocalWaiter.get();
            if (cwaiter == null) {
                cwaiter = new CommitWaiter(position, Thread.currentThread(), waiter);
                cLocalWaiter.set(cwaiter);
            } else {
                cwaiter.mPosition = position;
                cwaiter.mWaiter = waiter;
                cwaiter.mAppliablePosition = 0L;
            }
            this.mCommitTasks.add(cwaiter);
        }
        finally {
            this.releaseExclusive();
        }
        long l = endNanos = nanosTimeout > 0L ? System.nanoTime() + nanosTimeout : 0L;
        do {
            if (nanosTimeout < 0L) {
                Parker.park(waiter);
            } else {
                Parker.parkNanos(waiter, nanosTimeout);
            }
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            long commitPosition = cwaiter.mAppliablePosition;
            if (commitPosition < 0L) {
                return commitPosition;
            }
            if (commitPosition < position) continue;
            return commitPosition;
        } while (nanosTimeout != 0L && (nanosTimeout <= 0L || (nanosTimeout = endNanos - System.nanoTime()) > 0L));
        return -2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalClosed(Object waiter) {
        this.acquireShared();
        try {
            for (CommitCallback task : this.mCommitTasks) {
                if (!(task instanceof CommitWaiter)) continue;
                CommitWaiter cwaiter = (CommitWaiter)task;
                if (cwaiter.mWaiter != waiter) continue;
                FileTermLog.reached(cwaiter, -1L);
            }
        }
        finally {
            this.releaseShared();
        }
    }

    @Override
    public void uponCommit(CommitCallback task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.uponExclusive(() -> {
            long waitFor;
            long commitPosition = this.doAppliableCommitPosition();
            if (commitPosition < (waitFor = task.mPosition)) {
                if (this.mLogClosed || waitFor > this.mLogEndPosition) {
                    commitPosition = -1L;
                } else {
                    this.mCommitTasks.add(task);
                    return;
                }
            }
            this.downgrade();
            FileTermLog.reached(task, commitPosition);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryRollbackCommit(long position) {
        this.acquireExclusive();
        try {
            if (position < this.mLogStartPosition || position < this.doAppliableCommitPosition()) {
                boolean bl = false;
                return bl;
            }
            this.mLogCommitPosition = position;
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishTerm(long endPosition) {
        ArrayList removedTasks;
        LongConsumer[] commitListeners = null;
        this.acquireExclusive();
        try {
            long commitPosition = this.mLogCommitPosition;
            if (endPosition < commitPosition && commitPosition > this.mLogStartPosition) {
                throw new IllegalStateException("Cannot finish term below commit position: " + endPosition + " < " + commitPosition);
            }
            if (endPosition == this.mLogEndPosition) {
                this.releaseExclusive();
                return;
            }
            ++this.mLogVersion;
            if (endPosition >= this.mLogEndPosition) {
                this.mLogEndPosition = endPosition;
                this.releaseExclusive();
                return;
            }
            for (LKey<Segment> key : this.mSegments) {
                Segment segment = (Segment)key;
                segment.acquireExclusive();
                boolean shouldTruncate = segment.setEndPosition(endPosition);
                segment.releaseExclusive();
                if (!shouldTruncate || this.mLogClosed) continue;
                this.truncate(segment);
            }
            this.mLogEndPosition = endPosition;
            if (endPosition < this.mLogContigPosition) {
                this.mLogContigPosition = endPosition;
            }
            if (endPosition < this.mLogHighestPosition) {
                this.mLogHighestPosition = endPosition;
            }
            if (!this.mNonContigWriters.isEmpty()) {
                Iterator<SegmentWriter> it = this.mNonContigWriters.iterator();
                while (it.hasNext()) {
                    SegmentWriter writer = it.next();
                    if (writer.mWriterStartPosition >= endPosition) {
                        it.remove();
                        continue;
                    }
                    if (endPosition >= writer.mWriterHighestPosition) continue;
                    writer.mWriterHighestPosition = endPosition;
                }
            }
            removedTasks = new ArrayList();
            if (endPosition <= this.mLastCommitListenerPos) {
                commitListeners = this.mCommitListeners;
                this.mCommitListeners = null;
            }
            this.mCommitTasks.removeIf(task -> {
                if (task.mPosition > endPosition) {
                    removedTasks.add(task);
                    return true;
                }
                return false;
            });
        }
        catch (Throwable e) {
            this.releaseExclusive();
            throw e;
        }
        this.downgrade();
        try {
            if (commitListeners != null) {
                FileTermLog.notifyCommitListeners(commitListeners, -1L);
            }
            for (CommitCallback task2 : removedTasks) {
                FileTermLog.reached(task2, -1L);
            }
        }
        finally {
            this.releaseShared();
        }
    }

    @Override
    public long contigPosition() {
        this.acquireShared();
        long position = this.mLogContigPosition;
        this.releaseShared();
        return position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long checkForMissingData(long contigPosition, PositionRange results) {
        this.acquireShared();
        try {
            if (contigPosition < this.mLogStartPosition || this.mLogContigPosition == contigPosition) {
                long expectedPosition = this.mLogEndPosition;
                if (expectedPosition == Long.MAX_VALUE) {
                    expectedPosition = this.mLogCommitPosition;
                }
                long missingStartPosition = this.mLogContigPosition;
                if (!this.mNonContigWriters.isEmpty()) {
                    Object[] writers = this.mNonContigWriters.toArray(new SegmentWriter[this.mNonContigWriters.size()]);
                    Arrays.sort(writers);
                    for (Object writer : writers) {
                        long missingEndPosition = ((SegmentWriter)writer).mWriterStartPosition;
                        if (missingStartPosition < missingEndPosition) {
                            results.range(missingStartPosition, missingEndPosition);
                        }
                        missingStartPosition = ((SegmentWriter)writer).mWriterPosition;
                    }
                }
                if (missingStartPosition < expectedPosition) {
                    results.range(missingStartPosition, expectedPosition);
                }
            }
            long l = this.mLogContigPosition;
            return l;
        }
        finally {
            this.releaseShared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogWriter openWriter(long startPosition) {
        SegmentWriter writer = this.mCaches.mWriters.remove(startPosition, this);
        if (writer == null) {
            writer = new SegmentWriter();
            this.acquireExclusive();
            try {
                this.init(writer, startPosition);
            }
            finally {
                this.releaseExclusive();
            }
        }
        return writer;
    }

    private void init(SegmentWriter writer, long startPosition) {
        writer.mWriterVersion = this.mLogVersion;
        writer.mWriterPrevTerm = startPosition == this.mLogStartPosition ? this.mLogPrevTerm : this.mLogTerm;
        writer.mWriterStartPosition = startPosition;
        writer.mWriterPosition = startPosition;
        writer.mWriterHighestPosition = 0L;
        if (startPosition > this.mLogContigPosition && startPosition < this.mLogEndPosition) {
            this.mNonContigWriters.add(writer);
            this.mCaches.mWriters.maxSize(Math.max(10, this.mNonContigWriters.size()));
        }
    }

    @Override
    public LogReader openReader(long startPosition) {
        SegmentReader reader = this.mCaches.mReaders.remove(startPosition, this);
        if (reader == null) {
            this.acquireShared();
            long prevTerm = startPosition <= this.mLogStartPosition ? this.mLogPrevTerm : this.mLogTerm;
            this.releaseShared();
            reader = new SegmentReader(prevTerm, startPosition);
        }
        return reader;
    }

    @Override
    public boolean isReadable(long position) {
        return position >= this.mLogStartPosition && position <= this.appliableCommitPosition();
    }

    @Override
    public void sync() throws IOException {
        IOException ex = null;
        this.mSyncLatch.acquireExclusive();
        this.mDirtyLatch.acquireExclusive();
        Segment segment = this.mFirstDirty;
        if (segment == null) {
            this.mDirtyLatch.releaseExclusive();
        } else {
            Segment next;
            Segment last = this.mLastDirty;
            this.mFirstDirty = next = segment.mNextDirty;
            if (next == null) {
                this.mLastDirty = null;
            } else {
                segment.mNextDirty = null;
            }
            this.mDirtyLatch.releaseExclusive();
            while (true) {
                block10: {
                    try {
                        segment.sync();
                    }
                    catch (IOException e) {
                        if (ex != null) break block10;
                        ex = e;
                    }
                }
                if (segment == last) break;
                segment = next;
                this.mDirtyLatch.acquireExclusive();
                this.mFirstDirty = next = segment.mNextDirty;
                if (next == null) {
                    this.mLastDirty = null;
                } else {
                    segment.mNextDirty = null;
                }
                this.mDirtyLatch.releaseExclusive();
            }
        }
        this.mSyncLatch.releaseExclusive();
        if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.mSyncLatch.acquireShared();
        try {
            ArrayList waiterTasks;
            this.acquireExclusive();
            try {
                Iterator iterator = this.mWorker;
                synchronized (iterator) {
                    this.mWorker.join(false);
                }
                cLogClosedHandle.setVolatile(this, true);
                for (LKey lKey : this.mSegments) {
                    Segment segment = (Segment)lKey;
                    segment.acquireExclusive();
                    try {
                        segment.close(true);
                    }
                    finally {
                        segment.releaseExclusive();
                    }
                }
                waiterTasks = new ArrayList();
                this.mCommitTasks.removeIf(task -> {
                    if (task instanceof CommitWaiter) {
                        waiterTasks.add(task);
                    }
                    return true;
                });
            }
            catch (Throwable e) {
                this.releaseExclusive();
                throw e;
            }
            this.downgrade();
            try {
                for (CommitCallback commitCallback : waiterTasks) {
                    FileTermLog.reached(commitCallback, -1L);
                }
            }
            finally {
                this.releaseShared();
            }
        }
        finally {
            this.mSyncLatch.releaseShared();
        }
    }

    @Override
    public String toString() {
        return "TermLog{prevTerm=" + this.mLogPrevTerm + ", term=" + this.mLogTerm + ", startPosition=" + this.mLogStartPosition + ", commitPosition=" + this.mLogCommitPosition + ", highestPosition=" + this.mLogHighestPosition + ", contigPosition=" + this.mLogContigPosition + ", endPosition=" + this.mLogEndPosition + "}";
    }

    void addToDirtyList(Segment segment) {
        this.mDirtyLatch.acquireExclusive();
        Segment last = this.mLastDirty;
        if (last == null) {
            this.mFirstDirty = segment;
        } else {
            last.mNextDirty = segment;
        }
        this.mLastDirty = segment;
        this.mDirtyLatch.releaseExclusive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Segment segmentForWriting(SegmentWriter writer, long position) throws IOException {
        LKey.Finder key = new LKey.Finder(position);
        this.acquireExclusive();
        try {
            Segment nextSegment;
            long endPosition;
            Segment segment;
            if (writer.mWriterVersion != this.mLogVersion) {
                this.mNonContigWriters.remove(writer);
                this.init(writer, writer.mWriterPosition);
            }
            if (position >= this.mLogEndPosition) {
                Segment segment2 = null;
                return segment2;
            }
            Segment startSegment = (Segment)((Object)this.mSegments.floor(key));
            if (startSegment != null && position < startSegment.endPosition()) {
                this.mCaches.mSegments.remove(startSegment.cacheKey(), this);
                cRefCountHandle.getAndAdd(startSegment, 1);
                Segment segment3 = startSegment;
                return segment3;
            }
            if (position < Math.max(this.mLogStartPosition, this.doAppliableCommitPosition())) {
                Segment segment4 = null;
                return segment4;
            }
            if (this.mLogClosed) {
                throw new IOException("Closed");
            }
            long maxLength = this.mBase != null ? this.maxSegmentLength() : 0x100000000L;
            long startPosition = position;
            if (startSegment != null) {
                long segMaxLength = startSegment.mMaxLength;
                long segEndPosition = startSegment.mStartPosition + segMaxLength;
                startPosition = segEndPosition + (position - segEndPosition) / maxLength * maxLength;
            }
            if (!this.mSegments.add(segment = new Segment(startPosition, maxLength = Math.min(maxLength, (endPosition = (nextSegment = (Segment)((Object)this.mSegments.higher(key))) == null ? this.mLogEndPosition : nextSegment.mStartPosition) - startPosition)))) {
                if (startPosition != startSegment.mStartPosition || startSegment.mMaxLength != 0L) {
                    throw new AssertionError(startSegment);
                }
                startSegment.untruncate(maxLength);
                segment = startSegment;
            }
            Segment segment5 = segment;
            return segment5;
        }
        finally {
            this.releaseExclusive();
        }
    }

    private long maxSegmentLength() {
        return 0x100000L << Math.min(6, this.mSegments.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Segment segmentForReading(long position) throws IOException {
        LKey.Finder key = new LKey.Finder(position);
        this.acquireExclusive();
        try {
            Segment segment = (Segment)((Object)this.mSegments.floor(key));
            if (segment != null && position < segment.endPosition()) {
                cRefCountHandle.getAndAdd(segment, 1);
                Segment segment2 = segment;
                return segment2;
            }
            long commitPosition = Math.max(this.mLogStartPosition, this.doAppliableCommitPosition());
            if (position < commitPosition) {
                throw new InvalidReadException("Position is too low: " + position + " < " + commitPosition);
            }
        }
        finally {
            this.releaseExclusive();
        }
        return null;
    }

    void writeFinished(SegmentWriter writer, long currentPosition, long highestPosition) {
        block13: {
            block15: {
                long contigPosition;
                block14: {
                    long endPosition;
                    long allowedHighestPosition;
                    this.acquireExclusive();
                    long commitPosition = this.mLogCommitPosition;
                    if (highestPosition < commitPosition && highestPosition < (allowedHighestPosition = Math.min(commitPosition, this.mLogContigPosition))) {
                        highestPosition = allowedHighestPosition;
                    }
                    if (currentPosition > (endPosition = this.mLogEndPosition)) {
                        currentPosition = endPosition;
                    }
                    if (highestPosition > endPosition) {
                        highestPosition = endPosition;
                    }
                    cWriterPositionHandle.setOpaque(writer, currentPosition);
                    if (currentPosition > writer.mWriterStartPosition) {
                        writer.mWriterPrevTerm = this.mLogTerm;
                    }
                    if (highestPosition > writer.mWriterHighestPosition) {
                        writer.mWriterHighestPosition = highestPosition;
                    }
                    if (writer.mWriterStartPosition > (contigPosition = this.mLogContigPosition)) break block13;
                    if (currentPosition > contigPosition) {
                        SegmentWriter next;
                        contigPosition = currentPosition;
                        while ((next = this.mNonContigWriters.peek()) != null && next.mWriterStartPosition <= contigPosition) {
                            long nextHighest;
                            SegmentWriter removed = (SegmentWriter)this.mNonContigWriters.remove();
                            assert (removed == next);
                            if (next.mWriterPosition > contigPosition) {
                                contigPosition = next.mWriterPosition;
                            }
                            if ((nextHighest = next.mWriterHighestPosition) <= highestPosition || highestPosition > contigPosition) continue;
                            highestPosition = nextHighest;
                        }
                        this.mLogContigPosition = contigPosition;
                    }
                    if (contigPosition != endPosition && contigPosition > commitPosition) break block14;
                    highestPosition = contigPosition;
                    break block15;
                }
                if (highestPosition > contigPosition) break block13;
            }
            if (highestPosition > this.mLogHighestPosition) {
                this.mLogHighestPosition = highestPosition;
                this.doCaptureHighest(writer);
                this.notifyCommitTasks(this.doAppliableCommitPosition());
                return;
            }
        }
        this.doCaptureHighest(writer);
        this.releaseExclusive();
    }

    private void notifyCommitTasks(long commitPosition) {
        CommitCallback task;
        if (commitPosition <= this.mLastCommitListenerPos) {
            this.releaseExclusive();
            return;
        }
        Object commitTasks = null;
        while ((task = this.mCommitTasks.peek()) != null && commitPosition >= task.mPosition) {
            ArrayList<CommitCallback> list;
            CommitCallback removed = (CommitCallback)this.mCommitTasks.remove();
            assert (removed == task);
            if (commitTasks == null) {
                commitTasks = task;
                continue;
            }
            if (commitTasks instanceof List) {
                list = (ArrayList<CommitCallback>)commitTasks;
            } else {
                list = new ArrayList<CommitCallback>();
                list.add((CommitCallback)commitTasks);
                commitTasks = list;
            }
            try {
                list.add(task);
            }
            catch (Throwable e) {
                this.mCommitTasks.add(task);
                for (Object e2 : list) {
                    this.mCommitTasks.add((CommitCallback)e2);
                }
                this.releaseExclusive();
                throw e;
            }
        }
        this.mLastCommitListenerPos = commitPosition;
        LongConsumer[] commitListeners = this.mCommitListeners;
        if (commitPosition >= this.mLogEndPosition) {
            this.mCommitListeners = null;
        }
        this.downgrade();
        if (commitListeners != null) {
            FileTermLog.notifyCommitListeners(commitListeners, commitPosition);
            if (this.mCommitListeners == null) {
                FileTermLog.notifyCommitListeners(commitListeners, -1L);
            }
        }
        if (commitTasks != null) {
            if (commitTasks instanceof List) {
                List tasks = (List)commitTasks;
                for (Object t : tasks) {
                    FileTermLog.reached((CommitCallback)t, commitPosition);
                }
            } else {
                FileTermLog.reached((CommitCallback)commitTasks, commitPosition);
            }
        }
        this.releaseShared();
    }

    private static void notifyCommitListeners(LongConsumer[] commitListeners, long position) {
        for (LongConsumer listener : commitListeners) {
            try {
                listener.accept(position);
            }
            catch (Throwable e) {
                Utils.uncaught(e);
            }
        }
    }

    private static void reached(CommitCallback task, long position) {
        try {
            task.reached(position);
        }
        catch (Throwable e) {
            Utils.uncaught(e);
        }
    }

    void release(SegmentWriter writer, boolean recycle) {
        Segment segment;
        if (recycle) {
            if (writer.mWriterVersion != this.mLogVersion) {
                writer.close();
                return;
            }
            writer = this.mCaches.mWriters.add(writer);
        }
        if (writer != null && (segment = writer.mWriterSegment) != null) {
            writer.mWriterSegment = null;
            this.unreferenced(segment);
        }
    }

    void release(SegmentReader reader, boolean recycle) {
        Segment segment;
        if (recycle) {
            reader = this.mCaches.mReaders.add(reader);
        }
        if (reader != null && (segment = reader.mReaderSegment) != null) {
            reader.mReaderSegment = null;
            this.unreferenced(segment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unreferenced(final Segment segment) {
        if (cRefCountHandle.getAndAdd(segment, -1) > 0) {
            return;
        }
        final Segment toClose = this.mCaches.mSegments.add(segment);
        Worker.Task task = new Worker.Task(){

            @Override
            public void run() {
                try {
                    FileTermLog.this.doUnreferenced(segment, toClose);
                }
                catch (IOException e) {
                    FileTermLog.this.uncaught(e);
                }
            }
        };
        Worker worker = this.mWorker;
        synchronized (worker) {
            this.mWorker.enqueue(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUnreferenced(Segment segment, Segment toClose) throws IOException {
        segment.acquireExclusive();
        try {
            if (segment.mRefCount < 0) {
                segment.unmap();
            }
        }
        finally {
            segment.releaseExclusive();
        }
        if (toClose != null) {
            toClose.acquireExclusive();
            try {
                if (toClose.mRefCount < 0) {
                    toClose.close(false);
                } else {
                    toClose.unmap();
                }
            }
            finally {
                toClose.releaseExclusive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void truncate(final Segment segment) {
        Worker.Task task = new Worker.Task(){

            @Override
            public void run() {
                cRefCountHandle.getAndAdd(segment, 1);
                try {
                    segment.truncate();
                }
                catch (IOException e) {
                    FileTermLog.this.uncaught(e);
                }
                if (cRefCountHandle.getAndAdd(segment, -1) <= 0) {
                    try {
                        FileTermLog.this.doUnreferenced(segment, FileTermLog.this.mCaches.mSegments.add(segment));
                    }
                    catch (IOException e) {
                        FileTermLog.this.uncaught(e);
                    }
                }
            }
        };
        Worker worker = this.mWorker;
        synchronized (worker) {
            this.mWorker.enqueue(task);
        }
    }

    void uncaught(IOException e) {
        boolean closed = cLogClosedHandle.getVolatile(this);
        if (!closed) {
            Utils.uncaught(e);
        }
    }

    static {
        try {
            cLogClosedHandle = MethodHandles.lookup().findVarHandle(FileTermLog.class, "mLogClosed", Boolean.TYPE);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
        try {
            cWriterPositionHandle = MethodHandles.lookup().findVarHandle(SegmentWriter.class, "mWriterPosition", Long.TYPE);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
        try {
            cReaderPositionHandle = MethodHandles.lookup().findVarHandle(SegmentReader.class, "mReaderPosition", Long.TYPE);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
        try {
            cRefCountHandle = MethodHandles.lookup().findVarHandle(Segment.class, "mRefCount", Integer.TYPE);
            cDirtyHandle = MethodHandles.lookup().findVarHandle(Segment.class, "mDirty", Integer.TYPE);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    static class Caches {
        final LCache<Segment, FileTermLog> mSegments = new LCache(10);
        final LCache<SegmentWriter, FileTermLog> mWriters = new LCache(10);
        final LCache<SegmentReader, FileTermLog> mReaders = new LCache(10);

        Caches() {
        }
    }

    final class Segment
    extends Latch
    implements LKey<Segment>,
    LCache.Entry<Segment, FileTermLog> {
        private static final int OPEN_HANDLE_COUNT = 8;
        final long mStartPosition;
        volatile long mMaxLength;
        volatile int mRefCount;
        private FileIO mFileIO;
        private boolean mSegmentClosed;
        volatile int mDirty;
        Segment mNextDirty;
        private Segment mCacheNext;
        private Segment mCacheMoreUsed;
        private Segment mCacheLessUsed;

        Segment(long startPosition, long maxLength) {
            this.mStartPosition = startPosition;
            this.mMaxLength = maxLength;
        }

        File file() {
            File base = FileTermLog.this.mBase;
            if (base == null) {
                return null;
            }
            long prevTerm = FileTermLog.this.prevTermAt(this.mStartPosition);
            long term = FileTermLog.this.term();
            StringBuilder b = new StringBuilder();
            b.append(base.getPath()).append('.');
            b.append(term).append('.').append(this.mStartPosition);
            if (prevTerm != term) {
                b.append('.').append(prevTerm);
            }
            return new File(b.toString());
        }

        @Override
        public long key() {
            return this.mStartPosition;
        }

        long endPosition() {
            return this.mStartPosition + this.mMaxLength;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int write(long position, byte[] data, int offset, int length) throws IOException {
            if ((position -= this.mStartPosition) < 0L) {
                return 0;
            }
            long amt = Math.min(this.mMaxLength - position, (long)length);
            if (amt <= 0L) {
                return 0;
            }
            length = (int)amt;
            FileIO io = this.mFileIO;
            while (true) {
                block15: {
                    if (io != null || (io = this.fileIO()) != null) {
                        try {
                            io.write(position, data, offset, length);
                        }
                        catch (IOException e) {
                            this.acquireExclusive();
                            if (this.mFileIO == io) {
                                this.releaseExclusive();
                                throw e;
                            }
                            break block15;
                        }
                        if (this.mDirty == 0 && cDirtyHandle.getAndSet(this, 1) == 0) {
                            FileTermLog.this.addToDirtyList(this);
                        }
                        if ((long)length > (amt = Math.min(this.mMaxLength - position, (long)length))) {
                            length = (int)Math.max(0L, amt);
                            this.truncate();
                        }
                        return length;
                    }
                }
                try {
                    amt = Math.min(this.mMaxLength - position, (long)length);
                    if (amt <= 0L) {
                        int n = 0;
                        return n;
                    }
                    io = this.openForWriting();
                }
                finally {
                    this.releaseExclusive();
                }
                if (io == null) {
                    return 0;
                }
                io.map();
                length = (int)amt;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int read(long position, byte[] buf, int offset, int length) throws IOException {
            if ((position -= this.mStartPosition) < 0L) {
                throw new IllegalArgumentException();
            }
            long amt = Math.min(this.mMaxLength - position, (long)length);
            if (amt <= 0L) {
                return 0;
            }
            length = (int)amt;
            FileIO io = this.mFileIO;
            while (true) {
                block11: {
                    if (io != null || (io = this.fileIO()) != null) {
                        try {
                            io.read(position, buf, offset, length);
                            return length;
                        }
                        catch (IOException e) {
                            this.acquireExclusive();
                            if (this.mFileIO != io) break block11;
                            this.releaseExclusive();
                            throw e;
                        }
                    }
                }
                try {
                    amt = Math.min(this.mMaxLength - position, (long)length);
                    if (amt <= 0L) {
                        int n = 0;
                        return n;
                    }
                    io = this.openForReading();
                }
                finally {
                    this.releaseExclusive();
                }
                length = (int)amt;
            }
        }

        private FileIO fileIO() {
            this.acquireShared();
            FileIO io = this.mFileIO;
            if (io != null) {
                this.releaseShared();
            } else if (!this.tryUpgrade()) {
                this.releaseShared();
                this.acquireExclusive();
                io = this.mFileIO;
                if (io != null) {
                    this.releaseExclusive();
                }
            }
            return io;
        }

        FileIO openForWriting() throws IOException {
            FileIO io = this.mFileIO;
            if (io == null) {
                if (this.mSegmentClosed) {
                    boolean closed = cLogClosedHandle.getVolatile(FileTermLog.this);
                    if (closed) {
                        throw new IOException("Closed");
                    }
                    return null;
                }
                EnumSet<OpenOption> options = EnumSet.noneOf(OpenOption.class);
                int handles = 1;
                if (this.mMaxLength > 0L) {
                    options.add(OpenOption.CREATE);
                    handles = 8;
                }
                io = FileIO.open(this.file(), options, handles);
                try {
                    io.expandLength(this.mMaxLength, LengthOption.PREALLOCATE_OPTIONAL);
                }
                catch (IOException e) {
                    Utils.closeQuietly(io);
                    throw e;
                }
                this.mFileIO = io;
            }
            return io;
        }

        FileIO openForReading() throws IOException {
            FileIO io = this.mFileIO;
            if (io == null) {
                if (this.mSegmentClosed) {
                    boolean closed = cLogClosedHandle.getVolatile(FileTermLog.this);
                    if (closed) {
                        throw new IOException("Closed");
                    }
                    throw new InvalidReadException("Log compacted");
                }
                EnumSet<OpenOption> options = EnumSet.noneOf(OpenOption.class);
                int handles = 1;
                if (this.mMaxLength > 0L) {
                    handles = 8;
                }
                this.mFileIO = io = FileIO.open(this.file(), options, handles);
            }
            return io;
        }

        boolean setEndPosition(long endPosition) {
            long start = this.mStartPosition;
            if (start + this.mMaxLength <= endPosition) {
                return false;
            }
            this.mMaxLength = Math.max(0L, endPosition - start);
            return true;
        }

        void sync() throws IOException {
            if (this.mDirty != 0 && cDirtyHandle.getAndSet(this, 0) != 0) {
                cRefCountHandle.getAndAdd(this, 1);
                try {
                    this.doSync();
                }
                catch (IOException e) {
                    if (this.mDirty == 0 && cDirtyHandle.getAndSet(this, 1) == 0) {
                        FileTermLog.this.addToDirtyList(this);
                    }
                    throw e;
                }
                finally {
                    FileTermLog.this.unreferenced(this);
                }
            }
        }

        private void doSync() throws IOException {
            FileIO io = this.mFileIO;
            while (true) {
                block7: {
                    if (io != null || (io = this.fileIO()) != null) {
                        try {
                            io.sync(false);
                            return;
                        }
                        catch (IOException e) {
                            this.acquireExclusive();
                            if (this.mFileIO != io) break block7;
                            this.releaseExclusive();
                            throw e;
                        }
                    }
                }
                try {
                    if (this.mMaxLength != 0L && (io = this.openForWriting()) != null) continue;
                    return;
                }
                finally {
                    this.releaseExclusive();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void truncate() throws IOException {
            this.acquireExclusive();
            while (true) {
                FileIO io;
                long maxLength;
                try {
                    maxLength = this.mMaxLength;
                    if (maxLength == 0L) {
                        this.close(false);
                        io = null;
                    } else {
                        io = this.openForWriting();
                        if (io == null) {
                            return;
                        }
                    }
                }
                finally {
                    this.releaseExclusive();
                }
                if (io == null) {
                    File file = this.file();
                    if (file != null) {
                        file.delete();
                    }
                    return;
                }
                try {
                    io.truncateLength(maxLength);
                    return;
                }
                catch (IOException e) {
                    this.acquireExclusive();
                    if (this.mFileIO != io) continue;
                    this.releaseExclusive();
                    throw e;
                }
                break;
            }
        }

        void untruncate(long maxLength) throws IOException {
            this.acquireExclusive();
            try {
                if (this.mSegmentClosed) {
                    throw new IOException("Closed");
                }
                this.mMaxLength = maxLength;
            }
            finally {
                this.releaseExclusive();
            }
        }

        void unmap() throws IOException {
            if (this.mFileIO != null) {
                this.mFileIO.unmap();
            }
        }

        void close(boolean permanent) throws IOException {
            if (this.mFileIO != null) {
                this.mFileIO.close();
                this.mFileIO = null;
            }
            if (permanent) {
                this.mSegmentClosed = true;
            }
        }

        @Override
        public long cacheKey() {
            return this.key();
        }

        @Override
        public boolean cacheCheck(FileTermLog check) {
            return check == FileTermLog.this;
        }

        @Override
        public Segment cacheNext() {
            return this.mCacheNext;
        }

        @Override
        public void cacheNext(Segment next) {
            this.mCacheNext = next;
        }

        @Override
        public Segment cacheMoreUsed() {
            return this.mCacheMoreUsed;
        }

        @Override
        public void cacheMoreUsed(Segment more) {
            this.mCacheMoreUsed = more;
        }

        @Override
        public Segment cacheLessUsed() {
            return this.mCacheLessUsed;
        }

        @Override
        public void cacheLessUsed(Segment less) {
            this.mCacheLessUsed = less;
        }

        @Override
        public String toString() {
            StringBuilder b = new StringBuilder().append("Segment: {");
            File file = this.file();
            if (file != null) {
                b.append("file=").append(file).append(", ");
            }
            return b.append("startPosition=").append(this.mStartPosition).append(", maxLength=").append(this.mMaxLength).append('}').toString();
        }
    }

    static class CommitWaiter
    extends CommitCallback {
        final Thread mThread;
        Object mWaiter;
        volatile long mAppliablePosition;

        CommitWaiter(long position, Thread thread, Object waiter) {
            super(position);
            this.mThread = thread;
            this.mWaiter = waiter;
        }

        @Override
        public void reached(long position) {
            this.mWaiter = null;
            this.mAppliablePosition = position;
            Parker.unpark(this.mThread);
        }
    }

    final class SegmentWriter
    extends LogWriter
    implements LKey<SegmentWriter>,
    LCache.Entry<SegmentWriter, FileTermLog> {
        long mWriterVersion;
        long mWriterPrevTerm;
        long mWriterStartPosition;
        long mWriterPosition;
        long mWriterHighestPosition;
        Segment mWriterSegment;
        private volatile boolean mWriterClosed;
        private SegmentWriter mCacheNext;
        private SegmentWriter mCacheMoreUsed;
        private SegmentWriter mCacheLessUsed;

        SegmentWriter() {
        }

        @Override
        public long key() {
            return this.mWriterStartPosition;
        }

        @Override
        public long prevTerm() {
            return this.mWriterPrevTerm;
        }

        @Override
        public long term() {
            return FileTermLog.this.mLogTerm;
        }

        @Override
        public long termStartPosition() {
            return FileTermLog.this.startPosition();
        }

        @Override
        public long termEndPosition() {
            return FileTermLog.this.endPosition();
        }

        @Override
        public long position() {
            return cWriterPositionHandle.getOpaque(this);
        }

        @Override
        public long commitPosition() {
            return FileTermLog.this.appliableCommitPosition();
        }

        @Override
        public void addCommitListener(LongConsumer listener) {
            FileTermLog.this.addCommitListener(listener);
        }

        @Override
        public int write(byte[] prefix, byte[] data, int offset, int length, long highestPosition) throws IOException {
            int result;
            long position;
            block7: {
                position = this.mWriterPosition;
                Segment segment = this.mWriterSegment;
                if (segment == null) {
                    segment = this.segmentForWriting(position);
                    if (segment == null) {
                        return -1;
                    }
                    this.mWriterSegment = segment;
                }
                result = 1;
                if (prefix != null) {
                    int prefixOffset = 0;
                    int prefixLength = prefix.length;
                    while (true) {
                        int amt = segment.write(position, prefix, prefixOffset, prefixLength);
                        position += (long)amt;
                        if ((prefixLength -= amt) <= 0) break;
                        prefixOffset += amt;
                        this.mWriterSegment = null;
                        FileTermLog.this.unreferenced(segment);
                        segment = this.segmentForWriting(position);
                        if (segment == null) {
                            result = -1;
                            break block7;
                        }
                        this.mWriterSegment = segment;
                    }
                }
                while (true) {
                    int amt = segment.write(position, data, offset, length);
                    position += (long)amt;
                    if ((length -= amt) <= 0) break;
                    offset += amt;
                    this.mWriterSegment = null;
                    FileTermLog.this.unreferenced(segment);
                    segment = this.segmentForWriting(position);
                    if (segment == null) {
                        result = -1;
                        break;
                    }
                    this.mWriterSegment = segment;
                }
            }
            FileTermLog.this.writeFinished(this, position, highestPosition);
            return result;
        }

        private Segment segmentForWriting(long position) throws IOException {
            if (this.mWriterClosed) {
                throw new IOException("Closed");
            }
            return FileTermLog.this.segmentForWriting(this, position);
        }

        @Override
        public long waitForCommit(long position, long nanosTimeout) throws InterruptedIOException {
            return FileTermLog.this.waitForCommit(position, nanosTimeout, this);
        }

        @Override
        public void uponCommit(CommitCallback task) {
            FileTermLog.this.uponCommit(task);
        }

        @Override
        public void release() {
            FileTermLog.this.release(this, true);
        }

        @Override
        public void close() {
            this.mWriterClosed = true;
            FileTermLog.this.release(this, false);
            FileTermLog.this.signalClosed(this);
        }

        @Override
        public long cacheKey() {
            return this.mWriterPosition;
        }

        @Override
        public boolean cacheCheck(FileTermLog check) {
            return check == FileTermLog.this;
        }

        @Override
        public SegmentWriter cacheNext() {
            return this.mCacheNext;
        }

        @Override
        public void cacheNext(SegmentWriter next) {
            this.mCacheNext = next;
        }

        @Override
        public SegmentWriter cacheMoreUsed() {
            return this.mCacheMoreUsed;
        }

        @Override
        public void cacheMoreUsed(SegmentWriter more) {
            this.mCacheMoreUsed = more;
        }

        @Override
        public SegmentWriter cacheLessUsed() {
            return this.mCacheLessUsed;
        }

        @Override
        public void cacheLessUsed(SegmentWriter less) {
            this.mCacheLessUsed = less;
        }

        @Override
        public String toString() {
            return "LogWriter: {prevTerm=" + this.mWriterPrevTerm + ", term=" + this.term() + ", startPosition=" + this.mWriterStartPosition + ", position=" + this.mWriterPosition + ", highestPosition=" + this.mWriterHighestPosition + ", segment=" + this.mWriterSegment + "}";
        }
    }

    final class SegmentReader
    implements LogReader,
    LCache.Entry<SegmentReader, FileTermLog> {
        private long mReaderPrevTerm;
        long mReaderPosition;
        private long mReaderCommitPosition;
        private long mReaderContigPosition;
        Segment mReaderSegment;
        private volatile boolean mReaderClosed;
        private SegmentReader mCacheNext;
        private SegmentReader mCacheMoreUsed;
        private SegmentReader mCacheLessUsed;

        SegmentReader(long prevTerm, long position) {
            this.mReaderPrevTerm = prevTerm;
            cReaderPositionHandle.setOpaque(this, position);
        }

        @Override
        public long prevTerm() {
            return this.mReaderPrevTerm;
        }

        @Override
        public long term() {
            return FileTermLog.this.mLogTerm;
        }

        @Override
        public long termStartPosition() {
            return FileTermLog.this.startPosition();
        }

        @Override
        public long termEndPosition() {
            return FileTermLog.this.endPosition();
        }

        @Override
        public long position() {
            return cReaderPositionHandle.getOpaque(this);
        }

        @Override
        public long commitPosition() {
            return FileTermLog.this.appliableCommitPosition();
        }

        @Override
        public void addCommitListener(LongConsumer listener) {
            FileTermLog.this.addCommitListener(listener);
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            long commitPosition = this.mReaderCommitPosition;
            long position = this.mReaderPosition;
            long avail = commitPosition - position;
            if (avail <= 0L) {
                if (length == 0) {
                    return 0;
                }
                commitPosition = this.waitForCommit(position + 1L, -1L);
                if (commitPosition < 0L) {
                    if (this.mReaderClosed) {
                        throw new IOException("Closed");
                    }
                    return -1;
                }
                this.mReaderCommitPosition = commitPosition;
                avail = commitPosition - position;
            }
            return this.doRead(position, buf, offset, (int)Math.min((long)length, avail));
        }

        @Override
        public int tryRead(byte[] buf, int offset, int length) throws IOException {
            long commitPosition = this.mReaderCommitPosition;
            long position = this.mReaderPosition;
            long avail = commitPosition - position;
            if (avail <= 0L) {
                FileTermLog.this.acquireShared();
                commitPosition = FileTermLog.this.doAppliableCommitPosition();
                long endPosition = FileTermLog.this.mLogEndPosition;
                FileTermLog.this.releaseShared();
                this.mReaderCommitPosition = commitPosition;
                avail = commitPosition - position;
                if (avail <= 0L) {
                    return commitPosition == endPosition ? -1 : 0;
                }
            }
            return this.doRead(position, buf, offset, (int)Math.min((long)length, avail));
        }

        @Override
        public int tryReadAny(byte[] buf, int offset, int length) throws IOException {
            long contigPosition = this.mReaderContigPosition;
            long position = this.mReaderPosition;
            long avail = contigPosition - position;
            if (avail <= 0L) {
                FileTermLog.this.acquireShared();
                contigPosition = FileTermLog.this.mLogContigPosition;
                long endPosition = FileTermLog.this.mLogEndPosition;
                FileTermLog.this.releaseShared();
                this.mReaderContigPosition = contigPosition;
                avail = contigPosition - position;
                if (avail <= 0L) {
                    return contigPosition == endPosition ? -1 : 0;
                }
            }
            return this.doRead(position, buf, offset, (int)Math.min((long)length, avail));
        }

        private int doRead(long position, byte[] buf, int offset, int length) throws IOException {
            int amt;
            Segment segment = this.mReaderSegment;
            if (segment == null) {
                if (length == 0) {
                    return 0;
                }
                segment = this.segmentForReading(position);
                if (segment == null) {
                    return -1;
                }
                this.mReaderSegment = segment;
                this.mReaderPrevTerm = this.term();
            }
            if ((amt = segment.read(position, buf, offset, length)) <= 0) {
                if (length == 0) {
                    return 0;
                }
                this.mReaderSegment = null;
                FileTermLog.this.unreferenced(segment);
                segment = this.segmentForReading(position);
                if (segment == null) {
                    return -1;
                }
                this.mReaderSegment = segment;
                amt = segment.read(position, buf, offset, length);
            }
            cReaderPositionHandle.setOpaque(this, position + (long)amt);
            return amt;
        }

        private Segment segmentForReading(long position) throws IOException {
            if (this.mReaderClosed) {
                throw new IOException("Closed");
            }
            return FileTermLog.this.segmentForReading(position);
        }

        @Override
        public long waitForCommit(long position, long nanosTimeout) throws InterruptedIOException {
            return FileTermLog.this.waitForCommit(position, nanosTimeout, this);
        }

        @Override
        public void uponCommit(CommitCallback task) {
            FileTermLog.this.uponCommit(task);
        }

        @Override
        public void release() {
            FileTermLog.this.release(this, true);
        }

        @Override
        public void close() {
            this.mReaderClosed = true;
            FileTermLog.this.release(this, false);
            FileTermLog.this.signalClosed(this);
        }

        @Override
        public long cacheKey() {
            return this.mReaderPosition;
        }

        @Override
        public boolean cacheCheck(FileTermLog check) {
            return check == FileTermLog.this;
        }

        @Override
        public SegmentReader cacheNext() {
            return this.mCacheNext;
        }

        @Override
        public void cacheNext(SegmentReader next) {
            this.mCacheNext = next;
        }

        @Override
        public SegmentReader cacheMoreUsed() {
            return this.mCacheMoreUsed;
        }

        @Override
        public void cacheMoreUsed(SegmentReader more) {
            this.mCacheMoreUsed = more;
        }

        @Override
        public SegmentReader cacheLessUsed() {
            return this.mCacheLessUsed;
        }

        @Override
        public void cacheLessUsed(SegmentReader less) {
            this.mCacheLessUsed = less;
        }

        public String toString() {
            return "LogReader: {term=" + FileTermLog.this.mLogTerm + ", position=" + this.mReaderPosition + ", segment=" + this.mReaderSegment + "}";
        }
    }
}

