/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.ObjLongConsumer;
import java.util.zip.CRC32C;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.repl.DecodingInputStream;
import org.cojen.tupl.repl.EncodingOutputStream;
import org.cojen.tupl.repl.Peer;
import org.cojen.tupl.repl.Role;
import org.cojen.tupl.util.Latch;

final class GroupFile
extends Latch {
    private static final VarHandle cLocalMemberRoleHandle;
    private final EventListener mEventListener;
    private final File mFile;
    private final SocketAddress mLocalMemberAddress;
    private final long mGroupId;
    private final NavigableSet<Peer> mPeerSet;
    private long mVersion;
    private long mLocalMemberId;
    private Role mLocalMemberRole;
    private Map<byte[], Object> mProposeConsumers;

    public static GroupFile open(EventListener eventListener, File file, SocketAddress localMemberAddress, boolean create) throws IOException {
        if (file == null || localMemberAddress == null) {
            throw new IllegalArgumentException();
        }
        RandomAccessFile raf = GroupFile.openFile(file);
        return raf == null && !create ? null : new GroupFile(eventListener, file, localMemberAddress, raf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupFile(EventListener eventListener, File file, SocketAddress localMemberAddress, RandomAccessFile raf) throws IOException {
        this.mEventListener = eventListener;
        this.mFile = file;
        this.mLocalMemberAddress = localMemberAddress;
        this.mPeerSet = new ConcurrentSkipListSet<Peer>((a, b) -> Long.compare(a.mMemberId, b.mMemberId));
        if (raf != null) {
            this.acquireExclusive();
            try {
                this.mGroupId = this.parseFile(raf);
            }
            finally {
                this.releaseExclusive();
            }
        } else {
            long groupId;
            SecureRandom rnd = new SecureRandom();
            while ((groupId = rnd.nextLong()) == 0L) {
            }
            this.mGroupId = groupId;
            this.mLocalMemberId = this.mVersion + 1L;
            this.mLocalMemberRole = Role.NORMAL;
            this.persist();
            this.localAddedEvent();
        }
    }

    private void infoEvent(String message) {
        this.event(EventType.REPLICATION_INFO, message);
    }

    private void event(EventType type, String message) {
        if (this.mEventListener != null) {
            try {
                this.mEventListener.notify(type, message, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void localAddedEvent() {
        this.infoEvent("Local member added: " + this.mLocalMemberRole);
    }

    private void peerAddedEvent(Peer peer) {
        this.infoEvent("Remote member added: " + peer.mAddress + ", " + peer.role());
    }

    private void localRoleChangeEvent(Role from) {
        if (from == null) {
            this.localAddedEvent();
        } else {
            this.infoEvent("Local member role changed: " + from + " to " + this.mLocalMemberRole);
        }
    }

    private void peerRoleChangeEvent(Role from, Peer to) {
        if (from == null) {
            this.peerAddedEvent(to);
        } else {
            this.infoEvent("Remote member role changed: " + to.mAddress + ", " + from + " to " + to.role());
        }
    }

    private void peerRemoveEvent(Peer peer) {
        this.infoEvent("Remote member removed: " + peer.mAddress + ", " + peer.role());
    }

    private long parseFile(RandomAccessFile raf) throws IOException {
        Properties props = new Properties();
        try (FileInputStream in = new FileInputStream(raf.getFD());){
            props.load(new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8)));
        }
        ConcurrentSkipListSet<Peer> peerSet = new ConcurrentSkipListSet<Peer>((a, b) -> Long.compare(a.mMemberId, b.mMemberId));
        long version = 0L;
        long groupId = 0L;
        long localMemberId = 0L;
        Role localMemberRole = null;
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            Role role;
            SocketAddress addr;
            int ix;
            long memberId;
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            if (key.equals("version")) {
                try {
                    version = Long.parseUnsignedLong(value);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalStateException("Unsupported version: " + value);
                }
            }
            if (key.equals("groupId")) {
                try {
                    groupId = Long.parseUnsignedLong(value);
                }
                catch (NumberFormatException ex) {}
                continue;
            }
            try {
                memberId = Long.parseUnsignedLong(key);
            }
            catch (NumberFormatException ex) {
                continue;
            }
            if (memberId == 0L || (ix = value.indexOf(124)) <= 0 || (addr = GroupFile.parseSocketAddress(value.substring(0, ix).trim())) == null) continue;
            try {
                role = Role.valueOf(Role.class, value.substring(ix + 1).trim());
            }
            catch (IllegalArgumentException ex) {
                continue;
            }
            if (addr.equals(this.mLocalMemberAddress)) {
                if (localMemberRole != null) {
                    throw new IllegalStateException("Duplicate address: " + addr);
                }
                localMemberId = memberId;
                localMemberRole = role;
                continue;
            }
            if (memberId == localMemberId) {
                throw new IllegalStateException("Duplicate member identifier: " + memberId);
            }
            Peer peer = new Peer(memberId, addr, role);
            if (peerSet.add(peer)) continue;
            throw new IllegalStateException("Duplicate member identifier: " + memberId);
        }
        if (version == 0L) {
            throw new IllegalStateException("Unsupported version: " + version);
        }
        if (groupId == 0L) {
            throw new IllegalStateException("Group identifier not found");
        }
        if (this.mGroupId != 0L && groupId != this.mGroupId) {
            throw new IllegalStateException("Group identifier changed: " + this.mGroupId + " -> " + groupId);
        }
        Iterator<Peer> oldIt = this.mPeerSet.iterator();
        Iterator newIt = peerSet.iterator();
        Peer oldPeer = null;
        Peer newPeer = null;
        while (true) {
            oldPeer = GroupFile.tryNext(oldIt, oldPeer);
            newPeer = GroupFile.tryNext(newIt, newPeer);
            if (oldPeer == null) {
                if (newPeer == null) {
                    break;
                }
            } else {
                if (newPeer == null || oldPeer.mMemberId < newPeer.mMemberId) {
                    this.peerRemoveEvent(oldPeer);
                    oldIt.remove();
                    oldPeer = null;
                    continue;
                }
                if (oldPeer.mMemberId == newPeer.mMemberId) {
                    Role newRole;
                    Role currentRole = oldPeer.role();
                    if (currentRole != (newRole = newPeer.role())) {
                        oldPeer.role(newRole);
                        this.peerRoleChangeEvent(currentRole, oldPeer);
                    }
                    oldPeer = null;
                    newPeer = null;
                    continue;
                }
            }
            this.mPeerSet.add(newPeer);
            this.peerAddedEvent(newPeer);
            newPeer = null;
        }
        this.mVersion = version;
        this.mLocalMemberId = localMemberId;
        Role currentRole = this.mLocalMemberRole;
        if (currentRole != localMemberRole) {
            this.mLocalMemberRole = localMemberRole;
            this.localRoleChangeEvent(currentRole);
        }
        return groupId;
    }

    private static <P> P tryNext(Iterator<P> it, P obj) {
        if (obj == null && it.hasNext()) {
            obj = it.next();
        }
        return obj;
    }

    public long groupId() {
        return this.mGroupId;
    }

    public SocketAddress localMemberAddress() {
        return this.mLocalMemberAddress;
    }

    public long localMemberId() {
        this.acquireShared();
        long id = this.mLocalMemberId;
        this.releaseShared();
        return id;
    }

    public Role localMemberRole() {
        this.acquireShared();
        Role role = this.mLocalMemberRole;
        this.releaseShared();
        return role;
    }

    public Role localMemberRoleOpaque() {
        return cLocalMemberRoleHandle.getOpaque(this);
    }

    public NavigableSet<Peer> allPeers() {
        return this.mPeerSet;
    }

    public long version() {
        this.acquireShared();
        long version = this.mVersion;
        this.releaseShared();
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        byte[] buf = new byte[1000];
        CRC32C checksum = new CRC32C();
        this.acquireShared();
        try {
            RandomAccessFile raf = GroupFile.openFile(this.mFile);
            if (raf == null) {
                throw new FileNotFoundException(this.mFile.toString());
            }
            try {
                long length = raf.length();
                Utils.encodeLongLE(buf, 0, this.mVersion);
                Utils.encodeLongLE(buf, 8, length);
                int offset = 16;
                while (true) {
                    int amt;
                    if ((amt = raf.read(buf, offset, buf.length - offset)) <= 0) {
                        throw new IOException("File length changed");
                    }
                    out.write(buf, 0, amt + offset);
                    checksum.update(buf, 0, amt + offset);
                    if ((length -= (long)amt) <= 0L) {
                        if (length < 0L) {
                            throw new IOException("File length changed");
                        }
                        break;
                    }
                    offset = 0;
                }
            }
            finally {
                Utils.closeQuietly(raf);
            }
            Utils.encodeIntLE(buf, 0, (int)checksum.getValue());
            out.write(buf, 0, 4);
        }
        finally {
            this.releaseShared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readFrom(InputStream in) throws IOException {
        File oldFile;
        long length;
        long version;
        byte[] buf = new byte[1000];
        CRC32C checksum = new CRC32C();
        this.acquireExclusive();
        try {
            in.readNBytes(buf, 0, 16);
            version = Utils.decodeLongLE(buf, 0);
            checksum.update(buf, 0, 16);
        }
        catch (Throwable e) {
            this.releaseExclusive();
            throw e;
        }
        if (version <= this.mVersion) {
            long amt;
            this.releaseExclusive();
            length += 4L;
            do {
                if ((amt = in.skip(length)) > 0L) continue;
                throw new EOFException();
            } while ((length -= amt) > 0L);
            return false;
        }
        try {
            String path = this.mFile.getPath();
            oldFile = new File(path + ".old");
            File newFile = new File(path + ".new");
            try (FileOutputStream out = new FileOutputStream(newFile);){
                int amt;
                for (length = Utils.decodeLongLE(buf, 8); length > 0L; length -= (long)amt) {
                    amt = in.read(buf, 0, length < (long)buf.length ? (int)length : buf.length);
                    if (amt <= 0) {
                        throw new EOFException();
                    }
                    out.write(buf, 0, amt);
                    checksum.update(buf, 0, amt);
                }
                int expect = (int)checksum.getValue();
                in.readNBytes(buf, 0, 4);
                int actual = Utils.decodeIntLE(buf, 0);
                if (expect != actual) {
                    throw new IOException("Checksum mismatch: " + expect + " != " + actual);
                }
                out.getFD().sync();
            }
            catch (Throwable e) {
                newFile.delete();
                throw e;
            }
            this.swapFiles(oldFile, newFile);
            try {
                this.parseFile(new RandomAccessFile(this.mFile, "r"));
            }
            catch (Throwable e) {
                this.mFile.delete();
                oldFile.renameTo(this.mFile);
                throw e;
            }
        }
        finally {
            this.releaseExclusive();
        }
        oldFile.delete();
        return true;
    }

    public byte[] proposeJoin(byte op, SocketAddress address, ObjLongConsumer<InputStream> dest) {
        EncodingOutputStream eout = new EncodingOutputStream();
        eout.write(op);
        eout.encodeLongLE(this.version());
        eout.encodeLongLE(ThreadLocalRandom.current().nextLong());
        eout.encodeStr(address == null ? "" : address.toString());
        byte[] message = eout.toByteArray();
        if (dest != null) {
            this.acquireExclusive();
            this.addProposeConsumer(message, dest);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProposeConsumer(byte[] message, Object consumer) {
        Map<byte[], Object> consumers = this.mProposeConsumers;
        try {
            if (consumers == null) {
                this.mProposeConsumers = consumers = new ConcurrentSkipListMap<byte[], Object>(Arrays::compareUnsigned);
            }
        }
        finally {
            this.releaseExclusive();
        }
        consumers.put(message, consumer);
    }

    public boolean discardProposeConsumer(byte[] message) {
        this.acquireExclusive();
        boolean removed = false;
        if (this.mProposeConsumers != null && this.mProposeConsumers.remove(message) != null) {
            removed = true;
            if (this.mProposeConsumers.isEmpty()) {
                this.mProposeConsumers = null;
            }
        }
        this.releaseExclusive();
        return removed;
    }

    private <C> C removeProposeConsumer(byte[] message) {
        Object consumer = null;
        if (this.mProposeConsumers != null) {
            consumer = this.mProposeConsumers.remove(message);
            if (this.mProposeConsumers.isEmpty()) {
                this.mProposeConsumers = null;
            }
        }
        return (C)consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Peer applyJoin(long position, byte[] message) throws IOException {
        ObjLongConsumer consumer;
        Peer peer = null;
        this.acquireExclusive();
        try {
            consumer = (ObjLongConsumer)this.removeProposeConsumer(message);
            DecodingInputStream din = new DecodingInputStream(message);
            din.read();
            long version = din.decodeLongLE();
            long requestId = din.decodeLongLE();
            String addressStr = din.decodeStr();
            if (addressStr.length() != 0) {
                SocketAddress address = GroupFile.parseSocketAddress(addressStr);
                if (address == null) {
                    throw new IllegalArgumentException("Illegal address: " + addressStr);
                }
                try {
                    peer = this.doAddPeer(version, address, Role.RESTORING);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        catch (Throwable e) {
            this.releaseExclusive();
            throw e;
        }
        if (consumer == null) {
            this.releaseExclusive();
        } else if (peer == null) {
            this.releaseExclusive();
            try {
                consumer.accept(null, 0L);
            }
            catch (Throwable e) {
                Utils.uncaught(e);
            }
        } else {
            this.downgrade();
            try {
                try (FileInputStream in = new FileInputStream(this.mFile);){
                    consumer.accept(in, position);
                }
                catch (Throwable e) {
                    Utils.uncaught(e);
                }
            }
            finally {
                this.releaseShared();
            }
        }
        return peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Peer addPeer(SocketAddress address, Role role) throws IOException {
        this.acquireExclusive();
        try {
            Peer peer = this.doAddPeer(this.mVersion, address, role);
            return peer;
        }
        finally {
            this.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Peer addPeer(long version, SocketAddress address, Role role) throws IOException {
        this.acquireExclusive();
        try {
            Peer peer = this.doAddPeer(version, address, role);
            return peer;
        }
        finally {
            this.releaseExclusive();
        }
    }

    private Peer doAddPeer(long version, SocketAddress address, Role role) throws IOException {
        if (version != this.mVersion) {
            return null;
        }
        if (address == null || role == null) {
            throw new IllegalArgumentException();
        }
        boolean isPeer = true;
        if (address.equals(this.mLocalMemberAddress)) {
            if (this.mLocalMemberId == 0L) {
                isPeer = false;
            } else {
                throw new IllegalStateException("Address used by local member");
            }
        }
        for (Peer peer : this.mPeerSet) {
            if (!address.equals(peer.mAddress)) continue;
            this.doUpdateRole(peer, role);
            return peer;
        }
        if (isPeer) {
            Peer peer = new Peer(this.mVersion + 1L, address, role);
            if (!this.mPeerSet.add(peer)) {
                throw new IllegalStateException("Identifier collision: " + peer);
            }
            try {
                this.persist();
            }
            catch (Throwable e) {
                this.mPeerSet.remove(peer);
                throw e;
            }
            this.peerAddedEvent(peer);
            return peer;
        }
        this.mLocalMemberId = this.mVersion + 1L;
        this.mLocalMemberRole = role;
        try {
            this.persist();
        }
        catch (Throwable e) {
            this.mLocalMemberId = 0L;
            this.mLocalMemberRole = null;
            throw e;
        }
        this.localAddedEvent();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] proposeUpdateRole(byte op, long memberId, Role role) {
        this.acquireShared();
        try {
            this.checkUpdateRole(memberId, role);
            byte[] message = new byte[18];
            message[0] = op;
            Utils.encodeLongLE(message, 1, this.mVersion);
            Utils.encodeLongLE(message, 9, memberId);
            message[17] = role.mCode;
            byte[] byArray = message;
            return byArray;
        }
        finally {
            this.releaseShared();
        }
    }

    public boolean applyUpdateRole(byte[] message) throws IOException {
        long version = Utils.decodeLongLE(message, 1);
        long memberId = Utils.decodeLongLE(message, 9);
        Role role = Role.decode(message[17]);
        return this.updateRole(version, memberId, role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRole(long memberId, Role role) throws IOException {
        this.acquireExclusive();
        try {
            this.doUpdateRole(this.mVersion, memberId, role);
        }
        finally {
            this.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRole(long version, long memberId, Role role) throws IOException {
        this.acquireExclusive();
        try {
            boolean bl = this.doUpdateRole(version, memberId, role);
            return bl;
        }
        finally {
            this.releaseExclusive();
        }
    }

    private boolean doUpdateRole(long version, long memberId, Role role) throws IOException {
        if (version != this.mVersion) {
            return false;
        }
        Peer existing = this.checkUpdateRole(memberId, role);
        if (memberId == this.mLocalMemberId) {
            Role existingRole = this.mLocalMemberRole;
            if (existingRole != role) {
                this.mLocalMemberRole = role;
                try {
                    this.persist();
                }
                catch (Throwable e) {
                    this.mLocalMemberRole = existingRole;
                    throw e;
                }
                this.localRoleChangeEvent(existingRole);
            }
            return true;
        }
        this.doUpdateRole(existing, role);
        return true;
    }

    private void doUpdateRole(Peer existing, Role role) throws IOException {
        Role existingRole = existing.role();
        if (existingRole != role) {
            existing.role(role);
            try {
                this.persist();
            }
            catch (Throwable e) {
                existing.role(existingRole);
                throw e;
            }
            this.peerRoleChangeEvent(existingRole, existing);
        }
    }

    private Peer checkUpdateRole(long memberId, Role role) {
        if (role == null) {
            throw new IllegalArgumentException();
        }
        if (memberId == 0L) {
            throw new IllegalStateException("Member doesn't exist: " + memberId);
        }
        if (memberId == this.mLocalMemberId) {
            return null;
        }
        Peer existing = this.mPeerSet.floor(new Peer(memberId));
        if (existing == null || existing.mMemberId != memberId) {
            throw new IllegalStateException("Member doesn't exist: " + memberId);
        }
        return existing;
    }

    public byte[] proposeRemovePeer(byte op, long memberId, Consumer<Boolean> result) {
        byte[] message;
        this.acquireShared();
        try {
            this.checkRemovePeer(memberId);
            message = new byte[17];
            message[0] = op;
            Utils.encodeLongLE(message, 1, this.mVersion);
            Utils.encodeLongLE(message, 9, memberId);
        }
        catch (Throwable e) {
            this.releaseShared();
            throw e;
        }
        if (result == null) {
            this.releaseShared();
        } else {
            if (!this.tryUpgrade()) {
                this.releaseShared();
                this.acquireExclusive();
            }
            this.addProposeConsumer(message, result);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyRemovePeer(byte[] message) throws IOException {
        boolean result;
        Consumer consumer;
        long version = Utils.decodeLongLE(message, 1);
        long memberId = Utils.decodeLongLE(message, 9);
        this.acquireExclusive();
        try {
            consumer = (Consumer)this.removeProposeConsumer(message);
            result = this.doRemovePeer(version, memberId);
        }
        finally {
            this.releaseExclusive();
        }
        if (consumer != null) {
            consumer.accept(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePeer(long memberId) throws IOException {
        this.acquireExclusive();
        try {
            boolean bl = this.doRemovePeer(this.mVersion, memberId);
            return bl;
        }
        finally {
            this.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePeer(long version, long memberId) throws IOException {
        this.acquireExclusive();
        try {
            boolean bl = this.doRemovePeer(version, memberId);
            return bl;
        }
        finally {
            this.releaseExclusive();
        }
    }

    private boolean doRemovePeer(long version, long memberId) throws IOException {
        if (version != this.mVersion) {
            return false;
        }
        this.checkRemovePeer(memberId);
        if (memberId == 0L) {
            return false;
        }
        NavigableSet<Peer> peers = this.mPeerSet;
        Peer existing = peers.floor(new Peer(memberId));
        if (existing == null || existing.mMemberId != memberId) {
            return false;
        }
        if (!peers.remove(existing)) {
            throw new AssertionError();
        }
        try {
            this.persist();
        }
        catch (Throwable e) {
            peers.add(existing);
            throw e;
        }
        this.peerRemoveEvent(existing);
        return true;
    }

    private void checkRemovePeer(long memberId) {
        if (memberId == this.mLocalMemberId) {
            throw new IllegalStateException("Cannot remove local member");
        }
    }

    private void persist() throws IOException {
        ++this.mVersion;
        try {
            this.doPersist();
        }
        catch (Throwable e) {
            --this.mVersion;
            throw e;
        }
    }

    private void doPersist() throws IOException {
        String path = this.mFile.getPath();
        File oldFile = new File(path + ".old");
        File newFile = new File(path + ".new");
        try (FileOutputStream out = new FileOutputStream(newFile);){
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
            w.write(35);
            w.write(this.getClass().getName());
            w.newLine();
            w.write("version");
            w.write(" = ");
            w.write(Long.toUnsignedString(this.mVersion));
            w.newLine();
            w.write("groupId");
            w.write(" = ");
            w.write(Long.toUnsignedString(this.mGroupId));
            w.newLine();
            GroupFile.writeMember(w, this.mLocalMemberId, this.mLocalMemberAddress, this.mLocalMemberRole);
            for (Peer peer : this.mPeerSet) {
                GroupFile.writeMember(w, peer.mMemberId, peer.mAddress, peer.role());
            }
            w.flush();
            out.getFD().sync();
        }
        this.swapFiles(oldFile, newFile);
        oldFile.delete();
    }

    private void swapFiles(File oldFile, File newFile) throws IOException {
        if (!this.mFile.renameTo(oldFile) && this.mFile.exists()) {
            throw new IOException("Unable to rename: " + this.mFile + " to " + oldFile);
        }
        if (!newFile.renameTo(this.mFile)) {
            throw new IOException("Unable to rename: " + newFile + " to " + this.mFile);
        }
    }

    private static void writeMember(BufferedWriter w, long memberId, SocketAddress addr, Role role) throws IOException {
        w.write(Long.toUnsignedString(memberId));
        w.write(" = ");
        w.write(addr.toString());
        w.write(" | ");
        w.write(role.toString());
        w.newLine();
    }

    private static RandomAccessFile openFile(File file) throws IOException {
        String path = file.getPath();
        File oldFile = new File(path + ".old");
        File newFile = new File(path + ".new");
        while (true) {
            try {
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                if (raf.length() == 0L) {
                    raf.close();
                    raf = null;
                }
                oldFile.delete();
                newFile.delete();
                return raf;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (newFile.exists()) {
                    newFile.renameTo(file);
                    continue;
                }
                if (oldFile.exists()) {
                    oldFile.renameTo(file);
                    continue;
                }
                return null;
            }
            break;
        }
    }

    static SocketAddress parseSocketAddress(String str) throws UnknownHostException {
        InetAddress addr;
        int port;
        int ix = str.lastIndexOf(58);
        if (ix <= 0) {
            return null;
        }
        try {
            port = Integer.parseInt(str.substring(ix + 1).trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
        str = str.substring(0, ix).trim();
        ix = str.indexOf(47);
        if (ix < 0) {
            addr = InetAddress.getByName(str);
        } else {
            String host = str.substring(0, ix).trim();
            String addrStr = str.substring(ix + 1).trim();
            if (host.length() == 0) {
                addr = InetAddress.getByName(addrStr);
            } else {
                addr = InetAddress.getByName(addrStr);
                addr = InetAddress.getByAddress(host, addr.getAddress());
            }
        }
        try {
            return new InetSocketAddress(addr, port);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    static {
        try {
            cLocalMemberRoleHandle = MethodHandles.lookup().findVarHandle(GroupFile.class, "mLocalMemberRole", Role.class);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }
}

