/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

final class LCache<E extends Entry<E, C>, C> {
    private static final long HASH_SPREAD = -7046029254386353131L;
    private int mMaxSize;
    private E[] mEntries;
    private int mSize;
    private E mMostRecentlyUsed;
    private E mLeastRecentlyUsed;

    LCache(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.mMaxSize = maxSize;
        this.mEntries = new Entry[LCache.roundUpPower2(maxSize)];
    }

    public synchronized int size() {
        return this.mSize;
    }

    public synchronized E remove(long key, C check) {
        E[] entries = this.mEntries;
        int slot = LCache.hash(key) & entries.length - 1;
        E entry = entries[slot];
        Entry prev = null;
        while (entry != null) {
            Object next = entry.cacheNext();
            if (entry.cacheKey() != key || !entry.cacheCheck(check)) {
                prev = (Entry)entry;
                entry = next;
                continue;
            }
            if (prev == null) {
                entries[slot] = next;
            } else {
                prev.cacheNext(next);
            }
            entry.cacheNext(null);
            --this.mSize;
            Object lessUsed = entry.cacheLessUsed();
            Object moreUsed = entry.cacheMoreUsed();
            if (lessUsed != null) {
                entry.cacheLessUsed(null);
                if (moreUsed != null) {
                    entry.cacheMoreUsed(null);
                    lessUsed.cacheMoreUsed(moreUsed);
                    moreUsed.cacheLessUsed(lessUsed);
                } else if (entry == this.mMostRecentlyUsed) {
                    this.mMostRecentlyUsed = lessUsed;
                    lessUsed.cacheMoreUsed(null);
                }
            } else if (entry == this.mLeastRecentlyUsed) {
                this.mLeastRecentlyUsed = moreUsed;
                if (moreUsed != null) {
                    entry.cacheMoreUsed(null);
                    moreUsed.cacheLessUsed(null);
                } else {
                    this.mMostRecentlyUsed = null;
                }
            }
            return entry;
        }
        return null;
    }

    public synchronized E add(E entry) {
        E first;
        E[] entries = this.mEntries;
        int slot = LCache.hash(entry.cacheKey()) & entries.length - 1;
        for (E e = first = entries[slot]; e != null; e = e.cacheNext()) {
            if (e.cacheKey() != entry.cacheKey()) continue;
            return e == entry ? null : (E)entry;
        }
        entry.cacheNext(first);
        entries[slot] = entry;
        E most = this.mMostRecentlyUsed;
        if (most == null) {
            this.mLeastRecentlyUsed = entry;
        } else {
            entry.cacheLessUsed(most);
            most.cacheMoreUsed(entry);
        }
        this.mMostRecentlyUsed = entry;
        int size = this.mSize;
        if (size < this.mMaxSize) {
            this.mSize = size + 1;
            return null;
        }
        return this.evictOne();
    }

    private E evictOne() {
        E entry = this.mLeastRecentlyUsed;
        Object moreUsed = entry.cacheMoreUsed();
        this.mLeastRecentlyUsed = moreUsed;
        entry.cacheMoreUsed(null);
        moreUsed.cacheLessUsed(null);
        E[] entries = this.mEntries;
        int slot = LCache.hash(entry.cacheKey()) & entries.length - 1;
        E e = entries[slot];
        Entry prev = null;
        while (e != null) {
            Object next = e.cacheNext();
            if (e == entry) {
                if (prev == null) {
                    entries[slot] = next;
                } else {
                    prev.cacheNext(next);
                }
                e.cacheNext(null);
                break;
            }
            prev = (Entry)e;
            e = next;
        }
        return entry;
    }

    public synchronized E maxSize(int maxSize) {
        if (maxSize == this.mMaxSize) {
            return null;
        }
        if (maxSize < this.mMaxSize) {
            if (maxSize <= 0) {
                throw new IllegalArgumentException();
            }
            if (this.mSize - maxSize > 1) {
                --this.mMaxSize;
            } else {
                int newLen = LCache.roundUpPower2(maxSize);
                if (newLen < this.mEntries.length >> 5) {
                    newLen = this.mEntries.length >> 1;
                    this.rehash(newLen);
                }
                this.mMaxSize = maxSize;
                if (this.mSize <= maxSize) {
                    return null;
                }
            }
            --this.mSize;
            return this.evictOne();
        }
        int newLen = LCache.roundUpPower2(maxSize);
        if (newLen > this.mEntries.length) {
            this.rehash(newLen);
        }
        this.mMaxSize = maxSize;
        return null;
    }

    private void rehash(int newLen) {
        Entry[] newEntries = new Entry[newLen];
        E[] entries = this.mEntries;
        int i = entries.length;
        while (--i >= 0) {
            Entry e = entries[i];
            while (e != null) {
                Object next = e.cacheNext();
                int slot = LCache.hash(e.cacheKey()) & newEntries.length - 1;
                e.cacheNext((Entry)newEntries[slot]);
                newEntries[slot] = e;
                e = next;
            }
        }
        this.mEntries = newEntries;
    }

    private static int roundUpPower2(int i) {
        return Math.max(1, Integer.highestOneBit(i - 1) << 1);
    }

    private static int hash(long v) {
        return Long.hashCode(v * -7046029254386353131L);
    }

    static interface Entry<E extends Entry<E, C>, C> {
        public long cacheKey();

        public boolean cacheCheck(C var1);

        public E cacheNext();

        public void cacheNext(E var1);

        public E cacheMoreUsed();

        public void cacheMoreUsed(E var1);

        public E cacheLessUsed();

        public void cacheLessUsed(E var1);
    }
}

