/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

class LocalHost {
    private static volatile InetAddress cLocalAddress;

    LocalHost() {
    }

    public static void main(String[] args) throws Exception {
        System.out.println(LocalHost.getLocalHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress local = cLocalAddress;
        if (local != null) return local;
        Class<LocalHost> clazz = LocalHost.class;
        synchronized (LocalHost.class) {
            local = cLocalAddress;
            if (local != null) return local;
            cLocalAddress = local = LocalHost.doGetLocalHost();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return local;
        }
    }

    private static InetAddress doGetLocalHost() throws UnknownHostException {
        InetAddress actual;
        InetAddress local = InetAddress.getLocalHost();
        if (!local.isLoopbackAddress()) {
            return local;
        }
        NetworkInterface ni = null;
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface n = en.nextElement();
                if (n.isLoopback()) continue;
                ni = n;
                break;
            }
        }
        catch (SocketException e) {
            UnknownHostException u = new UnknownHostException(e.getMessage());
            u.initCause(e);
            throw u;
        }
        if (ni == null) {
            return local;
        }
        InetAddress v4 = null;
        InetAddress v6 = null;
        Enumeration<InetAddress> en = ni.getInetAddresses();
        while (en.hasMoreElements()) {
            InetAddress a = en.nextElement();
            if (a instanceof Inet4Address && v4 == null) {
                v4 = (Inet4Address)a;
                continue;
            }
            if (!(a instanceof Inet6Address) || v6 != null) continue;
            v6 = (Inet6Address)a;
        }
        if (v4 == null) {
            if (v6 == null) {
                return local;
            }
            actual = v6;
        } else {
            actual = v6 == null || Boolean.getBoolean("java.net.preferIPv4Stack") ? v4 : v6;
        }
        String name = actual.getHostName();
        if (name.equals(actual.getHostAddress()) && (name = local.getHostName()).equals(local.getHostAddress())) {
            name = null;
        }
        return InetAddress.getByAddress(name, actual.getAddress());
    }
}

