/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.repl.RangeSet;
import org.cojen.tupl.repl.Role;
import org.cojen.tupl.repl.SnapshotScore;

final class Peer
implements Comparable<Peer> {
    private static final VarHandle cRoleHandle;
    private static final VarHandle cGroupVersionHandle;
    private static final VarHandle cRangesHandle;
    private static final VarHandle cCompactPositionHandle;
    final long mMemberId;
    final SocketAddress mAddress;
    private Role mRole;
    long mMatchPosition;
    long mSyncMatchPosition;
    volatile long mCompactPosition;
    volatile long mGroupVersion;
    private Map<Object, SnapshotScore> mSnapshotScores;
    volatile long mLeaderCheck;
    private volatile RangeSet mQueryRanges;

    Peer(long memberId) {
        this.mMemberId = memberId;
        this.mAddress = null;
    }

    Peer(long memberId, SocketAddress addr, Role role) {
        if (memberId == 0L || addr == null || role == null) {
            throw new IllegalArgumentException();
        }
        this.mMemberId = memberId;
        this.mAddress = addr;
        this.mRole = role;
    }

    Role role() {
        return cRoleHandle.getOpaque(this);
    }

    void role(Role role) {
        cRoleHandle.setOpaque(this, role);
    }

    void updateCompactPosition(long position) {
        long currentPosition;
        while ((position = Math.max(currentPosition = this.mCompactPosition, position)) > currentPosition && !cCompactPositionHandle.compareAndSet(this, currentPosition, position)) {
        }
    }

    void updateGroupVersion(long groupVersion) {
        long currentVersion;
        while (groupVersion > (currentVersion = this.mGroupVersion) && !cGroupVersionHandle.compareAndSet(this, currentVersion, groupVersion)) {
        }
    }

    synchronized void prepareSnapshotScore(Object requestedBy) {
        if (this.mSnapshotScores == null) {
            this.mSnapshotScores = new HashMap<Object, SnapshotScore>(2);
        }
        this.mSnapshotScores.put(requestedBy, new SnapshotScore(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SnapshotScore awaitSnapshotScore(Object requestedBy, long timeoutMillis) {
        SnapshotScore score;
        Peer peer = this;
        synchronized (peer) {
            score = this.mSnapshotScores.get(requestedBy);
        }
        if (score == null) {
            throw new IllegalStateException();
        }
        try {
            if (!score.await(timeoutMillis, TimeUnit.MILLISECONDS)) {
                score = null;
            }
        }
        catch (Throwable e) {
            score = null;
        }
        peer = this;
        synchronized (peer) {
            this.mSnapshotScores.remove(requestedBy);
            if (this.mSnapshotScores.isEmpty()) {
                this.mSnapshotScores = null;
            }
        }
        return score;
    }

    synchronized void snapshotScoreReply(int activeSessions, float weight) {
        if (this.mSnapshotScores != null) {
            this.mSnapshotScores.values().forEach(s -> s.snapshotScoreReply(activeSessions, weight));
        }
    }

    RangeSet queryData(long startPosition, long endPosition) {
        RangeSet set = this.mQueryRanges;
        while (true) {
            RangeSet result = null;
            if (set == null) {
                set = new RangeSet();
                RangeSet existing = cRangesHandle.compareAndExchange(this, null, set);
                if (existing == null) {
                    result = set;
                } else {
                    set = existing;
                }
            }
            if (set.add(startPosition, endPosition)) {
                return result;
            }
            set = this.finishedQueries(set);
        }
    }

    RangeSet finishedQueries(RangeSet set) {
        if (set.closeIfEmpty()) {
            RangeSet existing = cRangesHandle.compareAndExchange(this, set, null);
            set = existing == set ? null : existing;
        }
        return set;
    }

    void discardQueries(RangeSet set) {
        this.mQueryRanges = null;
        set.close();
    }

    public int hashCode() {
        return Long.hashCode(this.mMemberId) + Objects.hashCode(this.mAddress) + Objects.hashCode((Object)this.mRole);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof Peer)) return false;
        Peer other = (Peer)obj;
        if (this.mMemberId != other.mMemberId) return false;
        if (!Objects.equals(this.mAddress, other.mAddress)) return false;
        if (!Objects.equals((Object)this.mRole, (Object)other.mRole)) return false;
        return true;
    }

    @Override
    public int compareTo(Peer other) {
        return Long.compare(this.mMatchPosition, other.mMatchPosition);
    }

    public String toString() {
        return "Peer{memberId=" + Long.toUnsignedString(this.mMemberId) + ", address=" + this.mAddress + ", role=" + this.mRole + "}";
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cRoleHandle = lookup.findVarHandle(Peer.class, "mRole", Role.class);
            cGroupVersionHandle = lookup.findVarHandle(Peer.class, "mGroupVersion", Long.TYPE);
            cRangesHandle = lookup.findVarHandle(Peer.class, "mQueryRanges", RangeSet.class);
            cCompactPositionHandle = lookup.findVarHandle(Peer.class, "mCompactPosition", Long.TYPE);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }
}

