/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

import java.util.TreeSet;

final class RangeSet
extends TreeSet<Range> {
    private boolean mClosed;

    @Override
    public synchronized boolean isEmpty() {
        return super.isEmpty();
    }

    public synchronized boolean add(long start, long end) {
        if (this.mClosed) {
            return false;
        }
        if (end <= start) {
            return true;
        }
        Range range = new Range(start, end);
        Range existing = super.floor(range);
        if (existing != null) {
            if (start > existing.end) {
                super.add(range);
            } else {
                if (end <= existing.end) {
                    return true;
                }
                existing.end = end;
                range = existing;
            }
        } else {
            existing = super.higher(range);
            if (existing == null || end < existing.start) {
                super.add(range);
                return true;
            }
            super.remove(existing);
            super.add(range);
            if (end <= existing.end) {
                range.end = existing.end;
                return true;
            }
        }
        do {
            if ((existing = super.higher(range)) == null || end < existing.start) {
                return true;
            }
            super.remove(existing);
        } while (end > existing.end);
        range.end = existing.end;
        return true;
    }

    public synchronized Range removeLowest() {
        return (Range)super.pollFirst();
    }

    public synchronized RangeSet copy() {
        RangeSet copy = new RangeSet();
        for (Range r : this) {
            copy.add(new Range(r.start, r.end));
        }
        return copy;
    }

    public synchronized boolean closeIfEmpty() {
        if (super.isEmpty()) {
            this.mClosed = true;
            return true;
        }
        return false;
    }

    public synchronized void close() {
        this.mClosed = true;
        super.clear();
    }

    static final class Range
    implements Comparable<Range> {
        public final long start;
        public long end;

        Range(long start, long end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public int compareTo(Range other) {
            return Long.compare(this.start, other.start);
        }

        public String toString() {
            return "[" + this.start + ", " + this.end + ")";
        }
    }
}

