/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

import java.net.SocketAddress;
import java.util.Collections;
import java.util.Set;
import org.cojen.tupl.repl.GroupFile;
import org.cojen.tupl.repl.GroupJoiner;
import org.cojen.tupl.repl.JoinException;

public class RemoveMember {
    public static void main(String[] args) throws Exception {
        Long groupToken = null;
        SocketAddress connectAddr = null;
        long removeMemberId = 0L;
        SocketAddress removeMemberAddr = null;
        try {
            block14: for (int i = 0; i < args.length; ++i) {
                switch (args[i]) {
                    case "--token": {
                        groupToken = Long.parseLong(args[++i]);
                        continue block14;
                    }
                    case "--connect": {
                        connectAddr = GroupFile.parseSocketAddress(args[++i]);
                        continue block14;
                    }
                    case "--remove": {
                        removeMemberAddr = GroupFile.parseSocketAddress(args[++i]);
                        if (removeMemberAddr != null) continue block14;
                        removeMemberId = Long.parseLong(args[i]);
                        continue block14;
                    }
                    default: {
                        throw new Exception();
                    }
                }
            }
            if (groupToken == null || connectAddr == null || removeMemberId == 0L && removeMemberAddr == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            System.out.println("Usage: RemoveMember --token <group token> --connect <existing member address> --remove <member to remove>");
            return;
        }
        Set<Object> seeds = Collections.singleton(connectAddr);
        GroupJoiner joiner = new GroupJoiner(groupToken, groupToken);
        int timeoutMillis = 10000;
        try {
            if (removeMemberAddr != null) {
                joiner.unjoin(seeds, timeoutMillis, removeMemberAddr);
            } else {
                joiner.unjoin(seeds, timeoutMillis, removeMemberId);
            }
            System.out.println("Removed");
        }
        catch (JoinException e) {
            String message = e.getMessage();
            if (message != null) {
                if (message.contains("EOFException")) {
                    System.out.println("Incorrect group token");
                    return;
                }
                if (message.contains("ConnectException")) {
                    System.out.println("Connection refused");
                    return;
                }
                if (message.contains("invalid address")) {
                    System.out.println("Cannot remove group leader");
                    return;
                }
                if (message.contains("no leader")) {
                    System.out.println("No group leader");
                    return;
                }
                if (message.contains("timed out")) {
                    System.out.println("Operation timed out");
                    return;
                }
                if (message.contains("version mismatch")) {
                    System.out.println("Member not found (or concurrent group modification)");
                    return;
                }
            }
            System.out.println(e);
        }
    }

    private RemoveMember() {
    }
}

