/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.cojen.tupl.repl.Role;
import org.cojen.tupl.repl.SnapshotReceiver;
import org.cojen.tupl.repl.SnapshotSender;

public interface Replicator
extends Closeable {
    public long encoding();

    public void start() throws IOException;

    public SnapshotReceiver restore(Map<String, String> var1) throws IOException;

    public SnapshotReceiver requestSnapshot(Map<String, String> var1) throws IOException;

    public void snapshotRequestAcceptor(Consumer<SnapshotSender> var1);

    public boolean isReadable(long var1);

    public Reader newReader(long var1, boolean var3);

    public Writer newWriter();

    public Writer newWriter(long var1);

    public boolean syncCommit(long var1, long var3) throws IOException;

    public void compact(long var1) throws IOException;

    public long commitPosition();

    public long localMemberId();

    public SocketAddress localAddress();

    public Role localRole();

    public Socket connect(SocketAddress var1) throws IOException;

    public void socketAcceptor(Consumer<Socket> var1);

    public void sync() throws IOException;

    public boolean failover() throws IOException;

    public static interface Writer
    extends Accessor {
    }

    public static interface Reader
    extends Accessor {
    }

    public static interface Accessor
    extends Closeable {
        public long term();

        public long termStartPosition();

        public long termEndPosition();

        public long position();

        public long commitPosition();

        public void addCommitListener(LongConsumer var1);

        public void uponCommit(long var1, LongConsumer var3);

        public long waitForCommit(long var1, long var3) throws InterruptedIOException;

        default public long waitForEndCommit(long nanosTimeout) throws InterruptedIOException {
            long endNanos = nanosTimeout > 0L ? System.nanoTime() + nanosTimeout : 0L;
            long endPosition = this.termEndPosition();
            long position;
            while ((position = this.waitForCommit(endPosition, nanosTimeout)) != -2L) {
                endPosition = this.termEndPosition();
                if (endPosition == Long.MAX_VALUE) {
                    return -1L;
                }
                if (position == endPosition) {
                    return position;
                }
                if (nanosTimeout <= 0L) continue;
                nanosTimeout = Math.max(0L, endNanos - System.nanoTime());
            }
            return -2L;
        }

        @Override
        public void close();
    }
}

