/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.repl;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.repl.GroupFile;
import org.cojen.tupl.repl.LocalHost;
import org.cojen.tupl.repl.Role;

public class ReplicatorConfig
implements Cloneable {
    File mBaseFile;
    boolean mMkdirs;
    long mGroupToken1;
    long mGroupToken2;
    SocketAddress mLocalAddress;
    SocketAddress mListenAddress;
    ServerSocket mLocalSocket;
    Role mLocalRole;
    Set<SocketAddress> mSeeds;
    boolean mProxyWrites;
    boolean mChecksumSockets;
    EventListener mEventListener;
    SocketFactory mSocketFactory;
    ServerSocketFactory mServerSocketFactory;

    public ReplicatorConfig() {
        this.createFilePath(true);
        this.localRole(Role.NORMAL);
        this.checksumSockets(true);
    }

    public ReplicatorConfig baseFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.mBaseFile = file.getAbsoluteFile();
        return this;
    }

    public ReplicatorConfig baseFilePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        this.mBaseFile = new File(path).getAbsoluteFile();
        return this;
    }

    public ReplicatorConfig createFilePath(boolean mkdirs) {
        this.mMkdirs = mkdirs;
        return this;
    }

    public ReplicatorConfig groupToken(long token) {
        return this.groupTokens(token, token);
    }

    public ReplicatorConfig groupTokens(long token, long altToken) {
        if (token == 0L || altToken == 0L) {
            throw new IllegalArgumentException();
        }
        this.mGroupToken1 = token;
        this.mGroupToken2 = altToken;
        return this;
    }

    public ReplicatorConfig localPort(int port) throws UnknownHostException {
        if (port <= 0) {
            throw new IllegalArgumentException();
        }
        this.mLocalAddress = new InetSocketAddress(LocalHost.getLocalHost(), port);
        this.mListenAddress = new InetSocketAddress(port);
        return this;
    }

    public ReplicatorConfig localAddress(SocketAddress addr) {
        InetSocketAddress sockAddr;
        if (addr == null) {
            throw new IllegalArgumentException();
        }
        if (addr instanceof InetSocketAddress && (sockAddr = (InetSocketAddress)addr).getAddress().isAnyLocalAddress()) {
            throw new IllegalArgumentException("Wildcard address: " + addr);
        }
        this.mLocalAddress = addr;
        return this;
    }

    public ReplicatorConfig listenAddress(SocketAddress addr) {
        if (addr == null) {
            throw new IllegalArgumentException();
        }
        this.mListenAddress = addr;
        return this;
    }

    public ReplicatorConfig localSocket(ServerSocket ss) throws UnknownHostException {
        InetSocketAddress sockAddr;
        InetAddress addr;
        this.mLocalSocket = ss;
        this.mListenAddress = ss.getLocalSocketAddress();
        this.mLocalAddress = this.mListenAddress;
        SocketAddress socketAddress = this.mLocalAddress;
        if (socketAddress instanceof InetSocketAddress && (addr = (sockAddr = (InetSocketAddress)socketAddress).getAddress()).isAnyLocalAddress()) {
            this.mLocalAddress = new InetSocketAddress(LocalHost.getLocalHost(), sockAddr.getPort());
        }
        return this;
    }

    public ReplicatorConfig localRole(Role role) {
        if (role == null) {
            throw new IllegalArgumentException();
        }
        this.mLocalRole = role;
        return this;
    }

    public ReplicatorConfig addSeed(String addressString) throws UnknownHostException {
        if (addressString == null) {
            throw new IllegalArgumentException();
        }
        SocketAddress addr = GroupFile.parseSocketAddress(addressString);
        if (addr == null) {
            throw new IllegalArgumentException("Malformed address: " + addressString);
        }
        return this.addSeed(addr);
    }

    public ReplicatorConfig addSeed(String hostname, int port) {
        return this.addSeed(new InetSocketAddress(hostname, port));
    }

    public ReplicatorConfig addSeed(SocketAddress addr) {
        if (addr == null) {
            throw new IllegalArgumentException();
        }
        if (this.mSeeds == null) {
            this.mSeeds = new HashSet<SocketAddress>();
        }
        this.mSeeds.add(addr);
        return this;
    }

    public ReplicatorConfig proxyWrites(boolean proxy) {
        this.mProxyWrites = proxy;
        return this;
    }

    public ReplicatorConfig checksumSockets(boolean checksums) {
        this.mChecksumSockets = checksums;
        return this;
    }

    public ReplicatorConfig eventListener(EventListener listener) {
        this.mEventListener = listener;
        return this;
    }

    public ReplicatorConfig socketFactory(SocketFactory factory) {
        this.mSocketFactory = factory;
        return this;
    }

    public ReplicatorConfig serverSocketFactory(ServerSocketFactory factory) {
        this.mServerSocketFactory = factory;
        return this;
    }

    public ReplicatorConfig clone() {
        ReplicatorConfig copy;
        try {
            copy = (ReplicatorConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Utils.rethrow(e);
        }
        if (this.mSeeds != null) {
            copy.mSeeds = new HashSet<SocketAddress>(this.mSeeds);
        }
        return copy;
    }
}

